/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.wedget;

import java.util.List;
import jp.sourceforge.logviewer.Activator;
import jp.sourceforge.logviewer.filters.Filter;
import jp.sourceforge.logviewer.filters.FilterAction;
import jp.sourceforge.logviewer.filters.TextStyleFilterAction;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class FilterTableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private final Table table;
    private static final int COLUMN_ENABLED = 0;
    private static final int COLUMN_NAME = 1;
    private final Image enableImage;
    private final Image disableImage;

    public FilterTableLabelProvider(Table table) {
        this.table = table;
        this.enableImage = Activator.createImageDescriptor("icons/enable/enabled_co.gif").createImage();
        this.disableImage = Activator.createImageDescriptor("icons/disable/disabled_co.gif").createImage();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Filter filter = (Filter)element;
        Image image = null;
        switch (columnIndex) {
            case 0: {
                if (filter.isEnabled()) {
                    image = this.enableImage;
                    break;
                }
                image = this.disableImage;
                break;
            }
            case 1: {
                break;
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        Filter filter = (Filter)element;
        String text = null;
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                text = filter.getName();
            }
        }
        return text;
    }

    public Color getForeground(Object element, int columnIndex) {
        Filter filter = (Filter)element;
        List<FilterAction> filterActionList = filter.getFilterActionList();
        if (filterActionList == null) {
            return null;
        }
        Color color = null;
        block0 : switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                for (FilterAction filterAction : filterActionList) {
                    if (!(filterAction instanceof TextStyleFilterAction)) continue;
                    TextStyleFilterAction action = (TextStyleFilterAction)filterAction;
                    color = action.getForeColor();
                    break block0;
                }
                break;
            }
        }
        return color;
    }

    public Color getBackground(Object element, int columnIndex) {
        Filter filter = (Filter)element;
        List<FilterAction> filterActionList = filter.getFilterActionList();
        if (filterActionList == null) {
            return null;
        }
        Color color = null;
        block0 : switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                for (FilterAction filterAction : filterActionList) {
                    if (!(filterAction instanceof TextStyleFilterAction)) continue;
                    TextStyleFilterAction action = (TextStyleFilterAction)filterAction;
                    color = action.getBackColor();
                    break block0;
                }
                break;
            }
        }
        return color;
    }

    public Font getFont(Object element, int columnIndex) {
        Filter filter = (Filter)element;
        List<FilterAction> filterActionList = filter.getFilterActionList();
        if (filterActionList == null) {
            return null;
        }
        Font font = null;
        block0 : switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                for (FilterAction filterAction : filterActionList) {
                    if (!(filterAction instanceof TextStyleFilterAction)) continue;
                    TextStyleFilterAction action = (TextStyleFilterAction)filterAction;
                    Display display = this.table.getDisplay();
                    FontData[] data = display.getSystemFont().getFontData();
                    FontData fontData = new FontData(data[0].getName(), data[0].getHeight(), action.getFontStyle());
                    font = new Font((Device)display, fontData);
                    break block0;
                }
                break;
            }
        }
        return font;
    }
}

