/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.wizard;

import jp.sourceforge.logviewer.filters.Filter;
import jp.sourceforge.logviewer.filters.TextStyleFilterAction;
import jp.sourceforge.logviewer.wizard.FilterActionChooserPage;
import jp.sourceforge.logviewer.wizard.KeywordSpecifyPage;
import jp.sourceforge.logviewer.wizard.Messages;
import jp.sourceforge.logviewer.wizard.TextStylePage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;

public class CreateFilterWizard
extends Wizard {
    private final boolean replaceMode;
    private Filter filter;
    private KeywordSpecifyPage keywordPage;
    private FilterActionChooserPage filterPage;
    private TextStylePage stylePage;

    public CreateFilterWizard(Filter filter) {
        boolean bl = this.replaceMode = filter != null;
        if (this.replaceMode) {
            this.setWindowTitle(Messages.getString("CreateFilterWizard.0"));
        } else {
            this.setWindowTitle(Messages.getString("CreateFilterWizard.1"));
        }
        this.initPages(filter);
    }

    protected void initPages(Filter filter) {
        this.keywordPage = new KeywordSpecifyPage(filter);
        this.filterPage = new FilterActionChooserPage(filter);
        this.stylePage = new TextStylePage(filter);
        this.addPage((IWizardPage)this.keywordPage);
        this.addPage((IWizardPage)this.filterPage);
        this.addPage((IWizardPage)this.stylePage);
    }

    public boolean performFinish() {
        String keyword = this.keywordPage.getKeyword();
        if (keyword == null || keyword.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)"error", (String)"keyword is empty.");
            return false;
        }
        this.filter = new Filter(keyword);
        FilterActionChooserPage.SELECTED selected = this.filterPage.getSelectedFilterAction();
        if (selected == FilterActionChooserPage.SELECTED.STYLE) {
            int fontStyle = this.stylePage.getFontStyle();
            RGB foregroundRGB = new RGB(0, 0, 0);
            RGB backgroundRGB = new RGB(255, 255, 255);
            if (this.stylePage.getForegroundColor() != null) {
                foregroundRGB = this.stylePage.getForegroundColor().getRGB();
            }
            if (this.stylePage.getBackgroundColor() != null) {
                backgroundRGB = this.stylePage.getBackgroundColor().getRGB();
            }
            Color foregroundColor = new Color((Device)this.getShell().getDisplay(), foregroundRGB);
            Color backgroundColor = new Color((Device)this.getShell().getDisplay(), backgroundRGB);
            TextStyleFilterAction filterAction = new TextStyleFilterAction(foregroundColor, backgroundColor, fontStyle);
            this.filter.addFilterAction(filterAction);
        }
        return true;
    }

    public boolean canFinish() {
        boolean judge = false;
        String keyword = this.keywordPage.getKeyword();
        if (keyword != null && !keyword.equals("")) {
            judge = true;
        }
        return judge;
    }

    public boolean performCancel() {
        this.keywordPage.dispose();
        this.filterPage.dispose();
        this.stylePage.dispose();
        return super.performCancel();
    }

    public Filter getFilter() {
        return this.filter;
    }
}

