/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.wizard;

import jp.sourceforge.logviewer.Activator;
import jp.sourceforge.logviewer.filters.Filter;
import jp.sourceforge.logviewer.wizard.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class KeywordSpecifyPage
extends WizardPage {
    public static final String PAGE_NAME = "keyword";
    private Text keywordText;
    private final boolean replaceMode;
    private Filter filter;

    public KeywordSpecifyPage(Filter filter) {
        super(PAGE_NAME, Messages.getString("KeywordSpecifyPage.1"), Activator.createImageDescriptor("icons/enable/filter_wiz.png"));
        this.replaceMode = filter != null;
        this.filter = filter;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        this.createKeywordRow(composite);
        this.createKeywordHintRow(composite);
    }

    private void createKeywordRow(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText(Messages.getString("KeywordSpecifyPage.3"));
        GridData gridData = new GridData();
        gridData.widthHint = 250;
        this.keywordText = new Text(composite, 2048);
        this.keywordText.setLayoutData((Object)gridData);
        if (this.replaceMode) {
            this.keywordText.setText(this.filter.getPatternString());
        }
    }

    private void createKeywordHintRow(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        Group keywordHintGroup = new Group(parent, 0);
        keywordHintGroup.setLayoutData((Object)gridData);
        keywordHintGroup.setText(Messages.getString("KeywordSpecifyPage.4"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        keywordHintGroup.setLayout((Layout)layout);
        new Label((Composite)keywordHintGroup, 0).setText(Messages.getString("KeywordSpecifyPage.5"));
        new Label((Composite)keywordHintGroup, 0).setText(Messages.getString("KeywordSpecifyPage.6"));
        new Label((Composite)keywordHintGroup, 0).setText(Messages.getString("KeywordSpecifyPage.7"));
    }

    public String getDescription() {
        return Messages.getString("KeywordSpecifyPage.8");
    }

    public String getKeyword() {
        return this.keywordText.getText();
    }

    public void setKeyword(String word) {
        this.keywordText.setText(word);
    }

    public boolean isPageComplete() {
        return true;
    }

    public IWizardPage getNextPage() {
        IWizardPage page = this.getWizard().getPage("filterAction");
        return page;
    }
}

