/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.wizard;

import java.util.List;
import jp.sourceforge.logviewer.Activator;
import jp.sourceforge.logviewer.filters.Filter;
import jp.sourceforge.logviewer.filters.FilterAction;
import jp.sourceforge.logviewer.filters.TextStyleFilterAction;
import jp.sourceforge.logviewer.wizard.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TextStylePage
extends WizardPage {
    public static final String PAGE_NAME = "textStyle";
    private final boolean replaceMode;
    private Filter filter;
    private Color foregroundColor;
    private Color backgroundColor;
    private int style = 0;
    private Label imageLabel;
    private Font imageFont;

    public TextStylePage(Filter filter) {
        super(PAGE_NAME, Messages.getString("TextStylePage.1"), Activator.createImageDescriptor("icons/enable/filter_wiz.png"));
        this.replaceMode = filter != null;
        this.filter = filter;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.createForegroundColorRow(composite);
        this.createBackgroundColorRow(composite);
        this.createStyleRow(composite);
        this.createStyleImage(composite);
    }

    private void createForegroundColorRow(Composite composite) {
        List<FilterAction> filterActionList;
        Display display = composite.getDisplay();
        new Label(composite, 0).setText(Messages.getString("TextStylePage.3"));
        GridData gridData = new GridData(256);
        gridData.heightHint = 20;
        gridData.widthHint = 60;
        final Canvas canvas = new Canvas(composite, 2048);
        this.foregroundColor = display.getSystemColor(2);
        canvas.setBackground(this.foregroundColor);
        canvas.setLayoutData((Object)gridData);
        Button colorButton = new Button(composite, 8);
        colorButton.setText(Messages.getString("TextStylePage.4"));
        colorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dialog = new ColorDialog(TextStylePage.this.getShell());
                dialog.open();
                if (dialog.getRGB() != null) {
                    if (TextStylePage.this.foregroundColor != null) {
                        TextStylePage.this.foregroundColor.dispose();
                    }
                    TextStylePage.this.foregroundColor = new Color((Device)TextStylePage.this.getShell().getDisplay(), dialog.getRGB());
                    canvas.setBackground(TextStylePage.this.foregroundColor);
                    TextStylePage.this.imageLabel.setForeground(TextStylePage.this.foregroundColor);
                }
            }
        });
        colorButton.setLayoutData((Object)gridData);
        if (this.replaceMode && (filterActionList = this.filter.getFilterActionList()).size() > 0 && filterActionList.get(0) instanceof TextStyleFilterAction) {
            TextStyleFilterAction tsfa = (TextStyleFilterAction)filterActionList.get(0);
            this.foregroundColor = tsfa.getForeColor();
            canvas.setBackground(this.foregroundColor);
        }
    }

    private void createBackgroundColorRow(Composite composite) {
        List<FilterAction> filterActionList;
        Display display = composite.getDisplay();
        new Label(composite, 0).setText(Messages.getString("TextStylePage.5"));
        GridData gridData = new GridData(256);
        gridData.heightHint = 20;
        gridData.widthHint = 60;
        final Canvas canvas = new Canvas(composite, 2048);
        this.backgroundColor = display.getSystemColor(1);
        canvas.setBackground(this.backgroundColor);
        canvas.setLayoutData((Object)gridData);
        Button colorButton = new Button(composite, 8);
        colorButton.setText(Messages.getString("TextStylePage.6"));
        colorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dialog = new ColorDialog(TextStylePage.this.getShell());
                dialog.open();
                if (dialog.getRGB() != null) {
                    if (TextStylePage.this.backgroundColor != null) {
                        TextStylePage.this.backgroundColor.dispose();
                    }
                    TextStylePage.this.backgroundColor = new Color((Device)TextStylePage.this.getShell().getDisplay(), dialog.getRGB());
                    canvas.setBackground(TextStylePage.this.backgroundColor);
                    TextStylePage.this.imageLabel.setBackground(TextStylePage.this.backgroundColor);
                }
            }
        });
        colorButton.setLayoutData((Object)gridData);
        if (this.replaceMode && (filterActionList = this.filter.getFilterActionList()).size() > 0 && filterActionList.get(0) instanceof TextStyleFilterAction) {
            TextStyleFilterAction tsfa = (TextStyleFilterAction)filterActionList.get(0);
            this.backgroundColor = tsfa.getBackColor();
            canvas.setBackground(this.backgroundColor);
        }
    }

    private void createStyleRow(final Composite composite) {
        List<FilterAction> filterActionList;
        new Label(composite, 0).setText(Messages.getString("TextStylePage.7"));
        GridData gridData = new GridData(256);
        gridData.heightHint = 20;
        gridData.widthHint = 60;
        gridData.horizontalSpan = 2;
        Combo styleCombo = new Combo(composite, 8);
        styleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Combo styleCombo = (Combo)event.getSource();
                switch (styleCombo.getSelectionIndex()) {
                    case 0: {
                        TextStylePage.this.style = 0;
                        break;
                    }
                    case 1: {
                        TextStylePage.this.style = 1;
                        break;
                    }
                    case 2: {
                        TextStylePage.this.style = 2;
                        break;
                    }
                    case 3: {
                        TextStylePage.this.style = 3;
                        break;
                    }
                    default: {
                        TextStylePage.this.style = 0;
                    }
                }
                Display display = composite.getDisplay();
                FontData[] data = display.getSystemFont().getFontData();
                FontData fontData = new FontData(data[0].getName(), data[0].getHeight(), TextStylePage.this.style);
                if (TextStylePage.this.imageFont != null) {
                    TextStylePage.this.imageFont.dispose();
                }
                TextStylePage.this.imageFont = new Font((Device)display, fontData);
                TextStylePage.this.imageLabel.setFont(TextStylePage.this.imageFont);
            }
        });
        styleCombo.add("NORMAL");
        styleCombo.add("BOLD");
        styleCombo.add("ITALIC");
        styleCombo.add("BOLD/ITALIC");
        styleCombo.select(0);
        if (this.replaceMode && (filterActionList = this.filter.getFilterActionList()).size() > 0 && filterActionList.get(0) instanceof TextStyleFilterAction) {
            TextStyleFilterAction tsfa = (TextStyleFilterAction)filterActionList.get(0);
            int index = 0;
            int style = tsfa.getFontStyle();
            switch (style) {
                case 0: {
                    index = 0;
                    break;
                }
                case 1: {
                    index = 1;
                    break;
                }
                case 2: {
                    index = 2;
                    break;
                }
                case 3: {
                    index = 3;
                    break;
                }
                default: {
                    index = 0;
                }
            }
            styleCombo.select(index);
            if (this.imageFont != null) {
                this.imageFont.dispose();
            }
            Display display = composite.getDisplay();
            FontData[] data = display.getSystemFont().getFontData();
            FontData fontData = new FontData(data[0].getName(), data[0].getHeight(), style);
            this.imageFont = new Font((Device)display, fontData);
        }
    }

    private void createStyleImage(Composite composite) {
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        Group imageGroup = new Group(composite, 0);
        imageGroup.setLayoutData((Object)gridData);
        imageGroup.setText(Messages.getString("TextStylePage.12"));
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        imageGroup.setLayout((Layout)layout);
        this.imageLabel = new Label((Composite)imageGroup, 0x1000000);
        this.imageLabel.setText("aA bB cC dD");
        this.imageLabel.setBackground(this.backgroundColor);
        this.imageLabel.setForeground(this.foregroundColor);
        this.imageLabel.setFont(this.imageFont);
    }

    public void dispose() {
        super.dispose();
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        if (this.imageFont != null) {
            this.imageFont.dispose();
        }
    }

    public String getDescription() {
        return Messages.getString("TextStylePage.14");
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getFontStyle() {
        return this.style;
    }
}

