#
#   a2ps_cfg.py
#
#   2004.5.12
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import os

import Lpy.paper_size
import Lpy.utils.file_utils
import Lpy.utils.get_env

a2ps_conf = os.path.join(Lpy.utils.get_env.get_home(),'.a2ps','a2psrc')
paper_head = "Medium:"

# Medium: name     width height [llx lly urx ury]
# Medium: UserSize	595	 842

def get_user_paper(flag,sizes = None):
    data = Lpy.utils.file_utils.get_filedata(a2ps_conf)
    if data:
        for line in data:
            if line[0] == '#' or len(line) <= 14:
                continue

            dat = line.strip().split()
            if len(dat) < 4:
                continue
            if dat[0].startswith(paper_head) and dat[1] == Lpy.paper_size.UserSize:
                if flag == 0:
                    return dat[2:]
                else:
                    data.remove(line)
                    break

        if flag != 0 and sizes:
            new_data = paper_head + ' ' + Lpy.paper_size.UserSize
            for key in sizes:
                new_data += ' ' + key
            data.append(new_data + os.linesep)
            ret = Lpy.utils.file_utils.write_tmpfile(a2ps_conf,data,"w")
            return ret
    return None



