#
#   a2ps_class.py
#
#   2003.7.8
#   2003.9.26
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#############################################
import Lpy.def_class
import Lpy.paper_size
import Lpy.a2ps_cfg
import Lpy.utils.get_env
import Lpy.fconvert.f_encoding

L_nuplist = ('1x1','1x2','1x3','2x2','2x3','2x4','3x3') # x,y

class Color_Type(Lpy.def_class.VPrint):
    title = _("Color_Print")
    value_list = (_('BW'),_('Color'))
    a2_cmd = ("bw","color","gray","gray2")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.set_value(0)

    def get_a2ps(self):
        if self.support != self.ON:
            return None
        return "--prologue=%s " % (self.a2_cmd[self.get_selected()])

class Paper(Lpy.def_class.VPrint):
    import Lpy.utils.file_utils
    title = _("PaperSize")
    value_list = Lpy.paper_size.A2_papers
    data = Lpy.utils.file_utils.get_command_data("a2ps --list=media")
    if data :
        for line in data:
            dat = line.strip().split()
            if len(dat) <= 8:
                continue
            if dat[0] == Lpy.paper_size.UserSize:
                continue
            if not dat[0] in value_list:
                value_list.append(dat[0])
    #value_list.sort()
    value_list.append(Lpy.paper_size.UserSize)

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.set_value('A4')

        ## User paper size
        self.unit = Lpy.paper_size.U_points
        dat = Lpy.a2ps_cfg.get_user_paper(0)
        if dat:
            self.width  = dat[0]
            self.height = dat[1]
        else:
            self.width  = 0.0
            self.height = 0.0

        #print self.width,self.height
    def get_paperName(self):
        return self.value_list[self.value]

    def get_realPaper(self,units):
        papersize = self.value_list[self.value]
        if papersize != Lpy.paper_size.UserSize:
            paper = Lpy.paper_size.gs_support_name(papersize)
        if paper is None:
            return self.get_optionSize(units)
        return paper,None

    def get_user_paperSize(self):
        return self.unit,self.width,self.height

    def set_user_paperSize(self,units,width,height):
        self.unit = units
        self.width  = width
        self.height = height
        self.set_value(Lpy.paper_size.UserSize)

        if self.unit != Lpy.paper_size.U_points:
            width  = Lpy.paper_size.convert_unit(self.unit,Lpy.paper_size.U_points,self.width)
            height = Lpy.paper_size.convert_unit(self.unit,Lpy.paper_size.U_points,self.height)

        Lpy.a2ps_cfg.get_user_paper(1,(width,height))

    def get_optionSize(self,units = None):
        if self.value == Lpy.paper_size.UserSize:
            if units == None:
                units = Lpy.paper_size.U_points
            if self.unit == units:
                return self.width,self.height
            else:
                return (Lpy.paper_size.convert_unit(self.unit,units,self.width),
                        Lpy.paper_size.convert_unit(self.unit,units,self.height))
        return Lpy.paper_size.get_papersize(self.value_list[self.value],units)

    def get_a2ps(self):
        return "--medium=%s " % self.value_list[self.value]

class Copies(Lpy.def_class.VPrint):
    title = _('Copies')
    value_list = '1-999-1-5-4-0'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.value = 1

    def get_a2ps(self):
        return "--copies=%d " % (self.value)

class Portrait(Lpy.def_class.VPrint):
    title = _("Orientation")
    value_list = (_('Portrait'),_('Landscape'))
    a2_cmd = ('--portrait','--landscape')

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.set_value(0)

    def get_nameValue(self):
        return self.a2_cmd[self.get_selected()][2:]

    def get_a2ps(self):
        return "%s " % (self.a2_cmd[self.get_selected()])

class Nup(Lpy.def_class.VPrint):
    title = _('Nup Printing')
    value_list = L_nuplist
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.set_value(0)

    def get_nup_value(self):
        row,colum = self.value_list[self.value].split('x')
        return int(row),int(colum)

    def get_a2ps(self):
        row,colum = self.get_nup_value()
        return '--rows=%d --columns=%d --major=rows ' % (row,colum)
        # 0: --rows=1 --columns=1 --major=rows --portrait
        # 1: --rows=1 --columns=2 --major=rows --landscape

class BookletPage(Lpy.def_class.VPrint):
    title =  _("Booklet Style")
    value_list = '4-36-4-8-0-0'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.OFF # ON_OFF
        self.value = 4
    def get_value(self):
        if self.support == self.ON:
            return self.value
        return 0

class Page_All(Lpy.def_class.VPrint):
    title = _('Page Range')
    value_list = (_('All'),_('Range'))
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.set_value(0)

class Page_Range(Lpy.def_class.VPrint):
    title = "" # _('Page Range')
    value_list = '256-0'
    # 'reverse','even','odd'

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value = "1-"

    def check_min(self,min,val):
        try:
            mm = int(val)
        except:
            mm = 0
        if mm > min:
            return mm
        return 0

    def check_range(self):
        if self.value == '':
            return self.ON
        self.value = self.value.strip()
        min = 0
        data = self.value.split(',')
        for vv in data:
            if vv.find('-') >=0:
                dat = vv.split('-')
                if dat[0] == '':
                    if dat[1] == '':
                        return self.OFF
                    dat[0] = dat[1]
                    dat[1] = ''
                min = self.check_min(min,dat[0])
                if min == 0:
                    return self.OFF
                if dat[1] != '':
                    min = self.check_min(min,dat[1])
                    if min == 0:
                        return self.OFF
            else:
                min = self.check_min(min,vv)
                if min == 0:
                    return self.OFF
        return self.ON

    def set_value(self,val):
        self.value = val

    def get_a2ps(self):
        if self.support != self.ON or self.value == '':
            return None
        return "--pages=%s " % (self.value)

## Pretty print: program source printing ##
class Stylesheets(Lpy.def_class.VPrint):
    ## a2ps --list=style-sheets
    title = _("Source Language")

    value_list = ('No source','Any lang','awk','c','cpp','csh','cxx','eps',
    'fortran','gmake','gnuc','haskell','html','java','js','lex','make','objc',
    'ocaml','oracle','pascal','perl','ps','python','scheme','sed','sh','sql',
    'tcl','tcsh','tex','texinfo','tk','vrml')

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.set_value(0)
    def get_a2ps(self):
        if self.value == 0: # 'plain text': no program
            return "--pretty-print=plain "
        elif self.value == 1: # 'any language'
            return "--pretty-print "
        else:
            return "--pretty-print=%s " % self.value_list[self.value]

class Pretty(Lpy.def_class.VPrint):
    title = _("Highlight Level")
    value_list = (_('None'),_('Normal'),_('Heavy'))
    a2_cmd = ("none","normal","heavy")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.set_value(1)

    def get_a2ps(self):
        return "--highlight-level=%s " % (self.a2_cmd[self.get_selected()])

class Strip_Level(Lpy.def_class.VPrint):
    title = _('Comments Printing')
    value_list = (_('Everything is printed'),_('Cut Regular Comments'),
                    _('Cut Strong Comments'),_('Cut All Comments'))

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.set_value(0)
    def get_a2ps(self):
        return "--strip-level=%d " % self.get_value()

class Encoding(Lpy.def_class.VPrint):
    title = _('Encoding')

    ## a2ps --list=encoding
    
    L_encode_tbl = Lpy.fconvert.f_encoding.L_encode_tbl
    value_list = L_encode_tbl.keys()
    value_list.sort()
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        encoding =  Lpy.fconvert.f_encoding.get_encode()
        if encoding in ('euc-jp','euc-kr'):
            self.value = encoding
            self.encode_filter = encoding
        else:
            if encoding.startswith('mac'):
                data = 'macintosh'
            else:
                data = encoding
            self.value = self.L_encode_tbl[data][0]
            self.encode_filter = self.L_encode_tbl[data][1]
 
    def get_a2ps(self):
        if self.support != self.ON:
            return None
        return '--encoding=%s ' % self.value

    def set_value(self,data):
        self.value = self.L_encode_tbl[data][0]
        self.encode_filter = self.L_encode_tbl[data][1]
 
    def get_selected(self,data =None):
        count = 0
        for key in self.value_list:
            if self.value == self.L_encode_tbl[key][0]:
                return count
            count += 1
        return 0

    def get_save_value(self):
        if self.support != self.ON:
            return None
        return self.support,self.value

    def set_load_value(self,values):
        if values is None:
            return None
        #print "set_load_value:(%s:%s)" % (self.__class__.__name__,values)
        self.set_support(values[0])
        num = len(values)
        if num >= 2:
            self.value = values[1]

    def get_encode_filter(self):
        return self.encode_filter

class Font_Size(Lpy.def_class.VPrint):
    title = _('FontSize')
    value_list = '2.0-300.0-1.0-5.0-0-1'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value = 9.0 #(points)
    def get_a2ps(self):
        return "--font-size=%s " % self.value # Float

class Fixed_Lines(Lpy.def_class.VPrint):
    title = _('Lines per page')

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value_list = self.ON_OFF
        self.set_value(0)

class Lines_Page(Lpy.def_class.VPrint):
    title = _('Lines per page')
    value_list = '1-200-1-10-0-1'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value = 66
    def get_a2ps(self):
        if self.support != self.ON or self.value < 1:
            return None
        return "--lines-per-page=%d " % self.value

class Tab_Size(Lpy.def_class.VPrint):
    title = _('Tab Size')
    value_list = '2-24-1-2-0-1'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.value = 4
    def get_a2ps(self):
        return "--tabsize=%d " % self.value

class Line_Numbers(Lpy.def_class.VPrint):
    title = _("Line Numbers")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.OFF
        self.value_list = self.ON_OFF
        self.set_value(0)

    def get_a2ps(self):
        if self.support != self.ON or self.value == 0:
            return None
        return '--line-numbers=1 ' # each lines

# cut too long lines
class Trancate_Lines(Lpy.def_class.VPrint):
    title = _("Trancate Lines")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value_list = self.ON_OFF
        self.set_value(0)
    def get_a2ps(self):
        if self.support != self.ON or self.value == 0:
            return None
        return "--truncate-lines=%s " % self.Yes_No[self.get_selected()]

class WaterMark(Lpy.def_class.VPrint):
    title = _("WaterMark")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value_list = self.ON_OFF
        self.set_value(0)

class Water_Text(Lpy.def_class.VPrint):
    title =  None
    value_list = '32-0'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value = 'Secret'
    def get_a2ps(self):
        return '--underlay="%s" ' % self.value

class Border(Lpy.def_class.VPrint):
    title = _("Border")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value_list = self.ON_OFF
        self.set_value(1)
    def get_a2ps(self):
        if self.support != self.ON:
            return None
        return "--borders=%s " % self.Yes_No[self.get_selected()]

## Header ##
class Header(Lpy.def_class.VPrint):
    title = _('Header')
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value_list = self.ON_OFF
        self.set_value(1)

    def get_a2ps(self):
        if self.support != self.ON or self.value == 0:
            return "--no-header "
        else:
            return None

class UserID(Lpy.def_class.VPrint):
    title = _('UserID Printing')
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value_list = self.ON_OFF
        self.set_value(0)

    def get_a2ps(self):
        return '--header '

class UserID_Text(Lpy.def_class.VPrint):
    title = None
    value_list = '32-0'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value = Lpy.utils.get_env.get_logname()

    def get_a2ps(self):
        if len(self.value) >= 1:
            return '--header="%s" ' % self.value
        else:
            return '--header '

# title print position
class Title_Position(Lpy.def_class.VPrint):
    title = _("Title Position")
    value_list = (_('Center'),_('Left'))

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.set_value(0)

    def get_a2ps(self):
        if self.value == 0: # self.value_list[0]:
            return '--left-title --right-title="#?2|$t2|%p./%p#|" --center-title='
        else:
            return '--center-title --right-title="#?2|$t2|%p./%p#|" --left-title='
        # header page number '--right-title="#?2|$t2|%p./%p#|" '

class Title_Text(Lpy.def_class.VPrint):
    L_def_title = 'filename'
    title = _("Title")
    value_list = '32-0'

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value = self.L_def_title

    def get_a2ps(self):
        if self.value :
            return self.value
        else:
            return None

## Footer ##
class Footer_Print(Lpy.def_class.VPrint):
    title = _("Footer Print")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value_list = self.ON_OFF
        self.set_value(1)

class Footer_Text(Lpy.def_class.VPrint):
    title = None
    value_list = '32-0'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value = "Design And Communication"
    def get_a2ps(self):
        if len(self.value) >= 1:
            return '--footer="%s" ' % self.value
        else:
            return '--footer '

class Date_Print(Lpy.def_class.VPrint):
    title = _("Date Print(footer)")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value_list = self.ON_OFF
        self.set_value(1)

        # "#?l!%E!#?v|%E|%s./%s#|!"
    def get_a2ps(self):
        if self.value == 1: # self.ON:
            return '--left-footer="%E" '
        else:
            return '--left-footer '

class Footer_Page(Lpy.def_class.VPrint):
    title = _("Page Number(footer)")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.value_list = self.ON_OFF
        self.set_value(1)

        # "#?l!%s./%s#!#?v|%s./%s#|%E|!"
    def get_a2ps(self):
        if self.value == 1: # self.ON:
            return '--right-footer="-%s.-" '
        else:
            return '--right-footer '

## margin
class Margin(Lpy.def_class.VPrint):
    value_list = '0-200-1-10-0-1'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.set_value(0)
    def get_a2ps(self):
        if self.support == self.ON and self.value >= 1:
            return '--margin=%d ' % self.value
        else:
            return None

class Margin_Left(Margin):
    title = _('Left Margin')
    def __init__(self):
        Margin.__init__(self)
        self.support = self.ON
        self.value = 20

class Margin_Right(Margin):
    title = _('Right Margin')
    def __init__(self):
        Margin.__init__(self)
        self.support = self.OFF
        self.value = 0

class Margin_Top(Margin):
    title = _('Top Margin')
    def __init__(self):
        Margin.__init__(self)
        self.support = self.OFF
        self.value = 0

class Margin_Bottom(Margin):
    title = _('Bottom Margin')
    def __init__(self):
        Margin.__init__(self)
        self.support = self.OFF
        self.value = 0
