#
#       a2ps_value.py
#
#       2003.9.27
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.def_func

class A2PS_Value(Lpy.def_func.FuncSpace):
    off = 0
    ok = 1

    T_printer    = 'T_printer'
    T_option     = 'T_option'
    T_output     = 'T_output'
    T_outprinter = 'T_outprinter'
    T_outfile    = 'T_outfile'

    T_errorstop  = 'T_errorstop'
    T_filealign  = 'T_filealign'

    T_colortype  = 'T_colortype'
    ####
    T_copies     = 'T_copies'
    T_portrait   = 'T_portrait'
    T_paper      = 'T_paper'
    T_pageall    = 'T_pageall'
    T_pagerange  = 'T_pagerange'
    T_nup        = 'T_nup'
    T_fontsize   = 'T_fontsize'

    T_fixedlines = 'T_fixedlines'
    T_linespage  = 'T_linespage'
    T_linenumbers= 'T_linenumbers'
    T_tabsize    = 'T_tabsize'
    T_trancate   = 'T_trancate'
    T_watermark  = 'T_watermark'
    T_watertext  = 'T_watertext'
    T_booklet    = 'T_booklet'

    ## margin
    T_marginleft   = 'T_marginleft'
    T_marginright  = 'T_marginright'
    T_margintop    = 'T_margintop'
    T_marginbottom = 'T_marginbottom'

    ## Header Border
    T_header    = 'T_header'
    T_border    = 'T_border'
    ## Title ##
    T_userid      = 'T_userid'
    T_useridtext  = 'T_useridtext'
    T_titleposition = 'T_titleposition'
    T_titletext     = 'T_titletext'
    ## Footer ##
    T_footerprint = 'T_footerprint'
    T_footertext  = 'T_footertext'
    T_dateprint   = 'T_dateprint'
    T_footerpage  = 'T_footerpage'

    ## pretty print
    T_stylesheets = 'T_stylesheets'
    T_pretty      = 'T_pretty'
    T_striplevel  = 'T_striplevel'
    T_encoding    = 'T_encoding'

    def __init__(self):
        Lpy.def_func.FuncSpace.__init__(self)
        Pname = self.get_a2ps_class()
        keys = Pname.keys()
        for key in keys:
            if Pname[key]:
                setattr(self.dlist,key,Pname[key])

        self.set_clist()
        self.PR = self.get_func(self.T_printer)

    def get_a2ps_class(self):
        import Lpy.a2ps_class
        import Lpy.def_printer

        return {
        self.T_printer   : Lpy.def_printer.Printers(),
        self.T_option    : Lpy.def_printer.Print_Option(),
        self.T_output    : Lpy.def_printer.Output(),
        self.T_outprinter: Lpy.def_printer.Out_Printer(),
        self.T_outfile   : Lpy.def_printer.Out_File(),

        self.T_errorstop : Lpy.def_printer.Error_stop(),
        self.T_filealign : Lpy.def_printer.File_align(),

        self.T_colortype : Lpy.a2ps_class.Color_Type(),
        self.T_copies    : Lpy.a2ps_class.Copies(),
        self.T_portrait  : Lpy.a2ps_class.Portrait(),
        self.T_paper     : Lpy.a2ps_class.Paper(),
        self.T_pageall   : Lpy.a2ps_class.Page_All(),
        self.T_pagerange : Lpy.a2ps_class.Page_Range(),
        self.T_nup       : Lpy.a2ps_class.Nup(),
        self.T_fontsize  : Lpy.a2ps_class.Font_Size(),
        ##
        self.T_fixedlines :  Lpy.a2ps_class.Fixed_Lines(),
        self.T_linespage  :  Lpy.a2ps_class.Lines_Page(),
        self.T_linenumbers : Lpy.a2ps_class.Line_Numbers(),
        self.T_tabsize     : Lpy.a2ps_class.Tab_Size(),
        self.T_trancate    : Lpy.a2ps_class.Trancate_Lines(),
        self.T_watermark   : Lpy.a2ps_class.WaterMark(),
        self.T_watertext   : Lpy.a2ps_class.Water_Text(),
        self.T_booklet     : Lpy.a2ps_class.BookletPage(),

        ## margin
        self.T_marginleft   : Lpy.a2ps_class.Margin_Left(),
        self.T_marginright  : Lpy.a2ps_class.Margin_Right(),
        self.T_margintop    : Lpy.a2ps_class.Margin_Top(),
        self.T_marginbottom : Lpy.a2ps_class.Margin_Bottom(),

        ## Header , Border
        self.T_header      : Lpy.a2ps_class.Header(),
        self.T_border      : Lpy.a2ps_class.Border(),

        ## Title ##
        self.T_userid      : Lpy.a2ps_class.UserID(),
        self.T_useridtext  : Lpy.a2ps_class.UserID_Text(),
        self.T_titleposition : Lpy.a2ps_class.Title_Position(),
        self.T_titletext     : Lpy.a2ps_class.Title_Text(),

        ## Footer ##
        self.T_footerprint : Lpy.a2ps_class.Footer_Print(),
        self.T_footertext  : Lpy.a2ps_class.Footer_Text(),
        self.T_dateprint   : Lpy.a2ps_class.Date_Print(),
        self.T_footerpage  : Lpy.a2ps_class.Footer_Page(),

        ## pretty print
        self.T_pretty      : Lpy.a2ps_class.Pretty(),
        self.T_stylesheets : Lpy.a2ps_class.Stylesheets(),
        self.T_striplevel  : Lpy.a2ps_class.Strip_Level(),
        self.T_encoding    : Lpy.a2ps_class.Encoding(),
        }

    def get_a2ps_argument(self,ftype):
        head_related = (self.T_useridtext,self.T_userid,
                self.T_titleposition,
                self.T_footerprint,
                self.T_footertext,
                self.T_dateprint,
                self.T_footerpage)

        foot_related = (self.T_footertext,
                self.T_dateprint,
                self.T_footerpage)

        head = self.get_func(self.T_header).get_value()
        foot = self.get_func(self.T_footerprint).get_value()

        flist = "--delegate=no "
        for key in self.clist:
            if key in head_related:
                if head == self.off:
                    continue
            elif key in foot_related:
                if foot == self.off:
                    continue

            if key == self.T_encoding and ftype == 1: # binary
                continue

            tmp = self.get_func(key).get_a2ps()
            if tmp is None:
                continue

            if key == self.T_titletext or key == self.T_userid:
                continue

            elif key == self.T_useridtext:
                if self.get_func(self.T_userid).get_value() == self.off:
                    tmp = self.get_func(self.T_userid).get_a2ps()

            elif key == self.T_pagerange:
                if self.get_func(self.T_pageall).get_value() == self.off:
                    continue
            elif key == self.T_linespage:
                if self.get_func(self.T_fixedlines).get_value() == self.off:
                    continue
            elif key == self.T_watertext:
                if self.get_func(self.T_watermark).get_value() == self.off:
                    continue
            elif key == self.T_pretty or key == self.T_striplevel:
                if self.get_func(self.T_stylesheets).get_value() == self.off:
                    continue

            elif key == self.T_titleposition:
                h_title = self.get_func(self.T_titletext).get_value()
                if h_title is None:
                    continue
                flist += '%s"%s" ' % (tmp,h_title)
                continue

            flist += tmp
        return flist
