#
#       def_printer.py
#
#       2003.9.27
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import os
import types

import Lpy.def_class

import Lpy.utils.file_utils
import Lpy.fconvert.file_type
import Lpy.pjl.pjl_title

class Printers(Lpy.def_class.VPrint):
    title = Lpy.pjl.pjl_title.u_pname
    default_title = '(default)'

    import Lpy.def_spooler

    value_list = []
    default = Lpy.def_spooler.get_default_printer()
    if default:
        value_list.append(default + default_title)
    dat = Lpy.def_spooler.get_printers(default)
    if dat:
        value_list.extend(dat)

    if not value_list:
        import Lpy.def_parm
        value_list.append(Lpy.def_parm.Dummy)

    if default == None:
        default = value_list[0]

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.save_static = self.ON  # save string:"self.value"

        self.default_printer = self.value = self.default

    def set_value(self,value):
        self.value = value

    def get_printer(self,data):
        if data == self.default_printer + self.default_title:
            return self.default_printer
        elif data == self.default_printer:
            return data
        else:
            if data in self.value_list:
                return data
        return None

    def get_selected(self,data =None):
        if data is None:
            data = self.value
        return self.tuple_index(data)

class Output(Lpy.def_class.VPrint):
    title = Lpy.pjl.pjl_title.u_output
    value_list = (Lpy.pjl.pjl_title.u_printer,Lpy.pjl.pjl_title.u_file) 
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.set_value(0)

## output printer ## T_outprinter
class Out_Printer(Lpy.def_class.VPrint):
    value_list = '1023-0'
    title = Lpy.pjl.pjl_title.u_filename
    MAX_files = 999 #

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.initialize()

    def initialize(self):
        self.clean_tmpfile()
        self.ftype  = None
        self.remove = None
        self.ptitle = None
        self.printing = None
        self.vcount = 0
        self.value  = []

    def clean_tmpfile(self):
        if self.value:
            for dat in self.value:
                dat.clean_tmpfile()
        self.printer = None

    def get_printing(self):
        return self.printing
    def set_printing(self,flag):
        self.printing = flag

    def set_filedata(self,count,data):
        if isinstance(data,Lpy.fconvert.file_type.FileAttrib):
            if count < self.vcount:
                self.value[count] = data
                return None
        else:
            print "Error:set_filedata() def_printer.py:",count,self.vcount

    def get_vcount(self):
        return self.vcount

    def get_filenames(self):
        if len(self.value) <= 1:
            return None
        filenames = []
        for filedata in self.value:
            filenames.append(filedata.get_filename())
        return filenames

    def value_append(self,filename,end_del = None):
        if self.vcount >= self.MAX_files:
            return None

        if self.remove:
            end_del = 1
        self.value.append(Lpy.fconvert.file_type.FileAttrib(filename,self.ftype,end_del))
        self.vcount = len(self.value)

    def set_ptitle(self,title):
        self.ptitle = title
    def get_ptitle(self):
        return self.ptitle
    def set_remove(self):
        self.remove = self.ON
    def set_ftype(self,ftype):
        self.ftype = ftype

    def set_value(self,files):
        if not files:
            return None
        self.initialize()
        if isinstance(files, types.StringType):
            self.value_append(files)
        elif isinstance(files,(types.ListType,types.TupleType)):
            for tmp in files:
                self.value_append(tmp)
        return 1

    def get_fileslist(self):
        return self.value

    def get_value(self):
        if self.value:
            vv = self.value[len(self.value) -1]
            return vv.get_filename()
        return None

    ## save,load
    def set_load_value(self,values):
        if len(values) >= 2:
            for tmp in values[1]:
                if Lpy.utils.file_utils.check_filename(tmp):
                    self.set_value(tmp)

    def get_save_value(self):
        if self.value and len(self.value) >= 1:
            files = []
            for dat in self.value:
                files.append(dat.get_filename())
            return self.support,files
        else:
            return self.support,None

## output file
class Out_File(Lpy.def_class.VPrint):
    suffix   = ".ps"
    #suffixes = (suffix,'.pdf')
    value_list = '1023-0'
    title = Lpy.pjl.pjl_title.u_outputfile
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.value = None
    def get_value(self):
        #if self.value:
        #    return self.value
        return self.set_output_name()

    def set_value(self,val):
        return self.set_output_name(val)

    def set_output_name(self,files = None,suffix = None):
        if suffix is None:
           suffix = self.suffix
        if not files:
            if self.value:
                files = self.value
            else:
                files = 'output'

        self.value = Lpy.utils.file_utils.set_ps_filename(files,suffix)
        #print self.value
        return self.value

class Print_Option(Lpy.def_class.VPrint):
    title = Lpy.pjl.pjl_title.u_option
    value_list = '255-0'
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.value = ''

## T_filealign
class File_align(Lpy.def_class.VPrint): # T_filealign
    title = _("File align")
    value_list = (_('next virtual page'),_('next row'),_('new page'),_('new sheet'))

    align_list = ('virtual','rank','page','sheet')
    new_sheet = 3
    new_page  = 2

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.set_value(2)

    def get_a2ps(self):
        return '--file-align=%s ' % self.align_list[self.value]
        #return None

class Error_stop(Lpy.def_class.VPrint): # T_errorstop  = 'T_errorstop'
    stop_err = 0
    continue_err = 1
    title = _("Continue at error")
    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.ON
        self.value_list = self.ON_OFF
        self.set_value(0)


