#
#       dialog_menu.py
#
#       2004.4.26
#       2004.11.18
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
#
############################
import gtk
import pango
import os
import types

import Lpy.pjl.pjl_title 

def get_font_desc(Font_name = "Sans 12"):
        desc = pango.FontDescription(Font_name)
        if not desc:
            for font in ("Couier 12","Serif 12"):
                desc = pango.FontDescription(Font_name)
                break
        return desc

def get_textview(Font_name = "Sans 12"):
        textview = gtk.TextView()
        colormap = textview.get_colormap()
        #textview.modify_base(gtk.STATE_NORMAL,colormap.alloc_color('#152636')) 
        #textview.modify_text(gtk.STATE_NORMAL,colormap.alloc_color("#FFDF8F")) 
        textview.modify_base(gtk.STATE_NORMAL,colormap.alloc_color('gray')) 
        textview.set_property("left-margin",6)
        desc = get_font_desc(Font_name)
        if desc:
            textview.modify_font(desc)
        return textview

## FileSelect
def inputfile_normalize(filename):
        dat = filename.strip().split()
        if len(dat) >= 2:
            name = ''
            for key in dat:
                name += key
            return os.path.normpath(name)
        else:
            return os.path.normpath(dat[0])

def file_ok(widget,filew,callback):
        filename = filew.get_filename()
        if filename:
            callback(inputfile_normalize(filename))
        filew.destroy()

def multi_file_ok(widget,filew,callback):
        files = filew.get_selections()
        if files:
            filenames = []
            for name in files:
                filenames.append(inputfile_normalize(name))
            callback(filenames)
        filew.destroy()

def fileDialog(widget,callback,filename=None,subtitle = "",pattern = None):
        filew = gtk.FileSelection(subtitle)
        filew.connect("destroy", lambda w: filew.destroy())
        filew.ok_button.connect("clicked", file_ok,filew,callback)
        filew.cancel_button.connect("clicked",lambda w:filew.destroy())
        if pattern:
            filew.complete(pattern)
        if filename:
            filew.set_filename(filename)
        filew.show()

def fileDialog_multi( widget,callback,filename=None,subtitle = ""):
        filew = gtk.FileSelection(subtitle)
        filew.connect("destroy", lambda w: filew.destroy())
        filew.ok_button.connect("clicked", multi_file_ok,filew,callback)
        filew.cancel_button.connect("clicked",lambda w:filew.destroy())
        filew.set_select_multiple(gtk.TRUE)
        if filename:
            filew.set_filename(filename)
        filew.show()

def selectFile(callback,filename=None,subtitle = None):
        button = gtk.Button('' ,gtk.STOCK_OPEN)
        button.set_border_width(6)
        button.connect("clicked", fileDialog,callback,filename,subtitle)
        button.show()
        return button

def selectFile2(filedialog,keyname):
        button = gtk.Button('' ,gtk.STOCK_OPEN)
        button.set_border_width(6)
        button.connect("clicked", filedialog,keyname)
        button.show()
        return button

## Error
Error   = 'Err'
Warning = 'Warning'

def error_dialog(message1,message2,error=None):
        if error == None:
            err = Lpy.pjl.pjl_title.u_waring_msg
            stock_msg = gtk.MESSAGE_WARNING
        else:
            err = Lpy.pjl.pjl_title.u_error_msg
            stock_msg = gtk.MESSAGE_ERROR

        err += "%s%s%s%s%s" % (os.linesep,os.linesep,message1,os.linesep,message2)
        dialog = gtk.MessageDialog(None,gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
           stock_msg, gtk.BUTTONS_OK,err)
        dialog.run()
        dialog.destroy()

## Dialog
def sure_dialog(message1,message2):
        msg = "%s%s%s" % (message1,os.linesep,message2)
        dialog = gtk.MessageDialog(None,gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
           gtk.MESSAGE_QUESTION,gtk.BUTTONS_YES_NO,msg)

        ret = dialog.run()
        dialog.destroy()
        if ret == gtk.RESPONSE_YES:
            return 1
        return None

def get_textList(data):
        textview = get_textview()
        textview.set_editable(0)
        textview.set_cursor_visible(0)
        textbuffer = textview.get_buffer()

        if isinstance(data,types.StringTypes):
            textbuffer.set_text(data)
        else:
            for line in data:
                textbuffer.insert(textbuffer.get_end_iter(),line + os.linesep)
        textview.show()
        return textview

def _to_string(title,src):
        data = []
        #data.append(title)
        for line in src:
            try:
                parent,subdata = line
            except:
                print "Error:parent:",line
                continue

            data.append(parent)
            for child in subdata:
                if isinstance(child,types.StringTypes):  
                    data.append(child)
                else: 
                    try:
                        ch1,sub1 = child
                    except:
                        print "Error:subdata:",child
                        continue
                    data.append(ch1)
                    for line2 in sub1:
                        if isinstance(line2,types.StringTypes):  
                            data.append(line2)
                        else:
                            try:
                                ch2,sub2 = line2 
                            except:
                                print "Error:subdata line:",line2
                                continue
                            data.append(ch2)
                            for line3 in sub2:
                                if isinstance(line2,types.StringTypes):  
                                    data.append(line3)
            data.append(os.linesep)
        return data

## TreeView
def get_treeList(title,data):
        treestore = gtk.TreeStore(str)

        for line in data:
            try:
                parent,subdata = line
            except:
                print "Error:parent:",line
                continue

            piter = treestore.append(None, [parent])
            for child in subdata:
                if isinstance(child,types.StringTypes):  
                    treestore.append(piter, [child])
                else: # (types.TupleType,types.ListType)
                    try:
                        ch1,sub1 = child
                    except:
                        print "Error:subdata:",child
                        continue
                    c_iter = treestore.append(piter, [ch1])
                    for line2 in sub1:
                        if isinstance(line2,types.StringTypes):  
                            treestore.append(c_iter, [line2])
                        else:
                            try:
                                ch2,sub2 = line2 
                            except:
                                print "Error:subdata line:",line2
                                continue
                            s_iter = treestore.append(c_iter, [ch2])
                            for line3 in sub2:
                                if isinstance(line2,types.StringTypes):  
                                    treestore.append(s_iter, [line3])

        treeview = gtk.TreeView(treestore)
        colormap = treeview.get_colormap()
        treeview.modify_text(gtk.STATE_SELECTED,colormap.alloc_color('white'))
  
        tvcolumn = gtk.TreeViewColumn(title)
        treeview.append_column(tvcolumn)
        cell = gtk.CellRendererText()
        tvcolumn.pack_start(cell,0) # extra space
        tvcolumn.set_attributes(cell, text=0) 
        treeview.modify_base(gtk.STATE_NORMAL,colormap.alloc_color('gray'))
        return treeview

## TreeViewColumn
def get_treeColumn(title,data):
 
        liststore = gtk.ListStore(str, str)
        for line in data:
            try:
                parent,subdata = line
            except:
                print "Error:parent:",line
                continue
            
            #liststore.append([parent,None])
            for child in subdata:
                #print child 
                if isinstance(child,types.StringTypes): 
                    tmp0,tmp1 = child.split('=',2)
                    if tmp1:
                        liststore.append([tmp0.strip(),tmp1.strip()])
                    else:
                        liststore.append([child,None])
                else: 
                    try:
                        ch1,sub1 = child
                        liststore.append([ch1,sub1])
                    except:
                        print "Error:subdata:",child
                        continue
                        
        treeview = gtk.TreeView(liststore)
        colormap = treeview.get_colormap()
        treeview.modify_text(gtk.STATE_SELECTED,colormap.alloc_color('white'))
  
        tvcolumn0 = gtk.TreeViewColumn(title)
        tvcolumn1 = gtk.TreeViewColumn(None)

        treeview.append_column(tvcolumn0)
        treeview.append_column(tvcolumn1)

        cell0 = gtk.CellRendererText()
        cell1 = gtk.CellRendererText()

        tvcolumn0.pack_start(cell0,1) # extra space
        tvcolumn1.pack_start(cell1,1) # extra space

        tvcolumn0.set_attributes(cell0, text=0) 
        tvcolumn1.set_attributes(cell1, text=1) 
        tvcolumn0.set_min_width(180)

        treeview.modify_base(gtk.STATE_NORMAL,colormap.alloc_color('gray'))
        return treeview


## ComboBox
def combo_callback(combobox,callback):
        model = combobox.get_model()
        index = combobox.get_active()
        if index > -1:
            callback(None,model[index][0])

def create_option_menu(callback,slist,value):
        # 2004.11.17 modified 
        if gtk.pygtk_version >= (2,4,0):
            liststore = gtk.ListStore(str)
            for op in slist:
                liststore.append([op])
            option_menu = gtk.ComboBox(liststore)
        
            cell = gtk.CellRendererText()
            option_menu.pack_start(cell, gtk.TRUE)
            option_menu.add_attribute(cell,'text', 0)
            option_menu.set_active(value)
            option_menu.connect("changed",combo_callback,callback)
            option_menu.show()
            return option_menu
        else:
            menu = gtk.Menu()
            for op in slist:
                item = gtk.MenuItem(op)
                item.connect("activate", callback,op)
                item.show()
                menu.append(item)

            option_menu = gtk.OptionMenu()
            option_menu.set_menu(menu)
            option_menu.set_history(value)
            option_menu.show()
            return option_menu

def message_lists(title,data,setButton= None,xsize = 600,ysize = 600):
        if not data:
            return None
        if not type(data) in (types.TupleType,types.ListType):
            print "Error:(message_lists)data type"
            return None

        if setButton:
            dialog = gtk.Dialog(title,None,gtk.DIALOG_MODAL |gtk.DIALOG_DESTROY_WITH_PARENT,
                (gtk.STOCK_APPLY,gtk.RESPONSE_APPLY,gtk.STOCK_CLOSE,gtk.RESPONSE_NONE))
        else:
            dialog = gtk.Dialog(title,None,gtk.DIALOG_MODAL |gtk.DIALOG_DESTROY_WITH_PARENT,
                (gtk.STOCK_CLOSE,gtk.RESPONSE_NONE))

        vbox = gtk.VBox(gtk.FALSE, 0)
        vbox.set_size_request(xsize,ysize)
        vbox.set_border_width(6)
        vbox.show()
        dialog.vbox.pack_start(vbox,gtk.FALSE,gtk.FALSE,0)
        sw = gtk.ScrolledWindow()
        sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)

        if gtk.pygtk_version[0] >= 2:
            sw.add(get_treeColumn(title,data))
        else:
            sw.add(get_textList(_to_string(title,data)))
 
        sw.show()
        vbox.pack_start(sw)
        dialog.show_all()
        response = dialog.run()
        dialog.destroy()
        return response

def message_dialog(title,data,setButton= None,xsize = 600,ysize = 600):
        if not data:
            return None
 
        if setButton:
            dialog = gtk.Dialog(title,None,gtk.DIALOG_MODAL |gtk.DIALOG_DESTROY_WITH_PARENT,
                (gtk.STOCK_APPLY,gtk.RESPONSE_APPLY,gtk.STOCK_CLOSE,gtk.RESPONSE_NONE))
        else:
            dialog = gtk.Dialog(title,None,gtk.DIALOG_MODAL |gtk.DIALOG_DESTROY_WITH_PARENT,
                (gtk.STOCK_CLOSE,gtk.RESPONSE_NONE))

        vbox = gtk.VBox(gtk.FALSE, 0)
        vbox.set_size_request(xsize,ysize)
        vbox.set_border_width(6)
        vbox.show()
        dialog.vbox.pack_start(vbox,gtk.FALSE,gtk.FALSE,0)
        sw = gtk.ScrolledWindow()
        sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)

        if type(data) in (types.TupleType,types.ListType):
            if gtk.pygtk_version[0] >= 2:
                sw.add(get_treeList(title,data))
            else:
                sw.add(get_textList(_to_string(title,data)))
        else:
            sw.add(get_textList(data))

        sw.show()
        vbox.pack_start(sw)
        dialog.show_all()
        response = dialog.run()
        dialog.destroy()
        return response

def input_dialog(title,data,xsize = 200,ysize = 80):
        import gui_set
        import Lpy.paper_size

        global units,x_size,y_size
        global x_entry,y_entry

        units_title,unitsList,units = data[0]
        x_title,x_size = data[1]
        y_title,y_size = data[2]

        def input_callback(widget,event,entry):
            if event.type == gtk.gdk.KEY_RELEASE:
                global x_size,y_size
                name = entry.get_property('name')
                if name == x_title:
                    x_size = entry.get_text()
                elif name == y_title:
                    y_size = entry.get_text()

        def menu_callback(widget,item):
            global units
            if units == item:
                return None

            global x_size,y_size
            global x_entry,y_entry

            x_size = Lpy.paper_size.convert_unit(units,item,float(x_size))
            y_size = Lpy.paper_size.convert_unit(units,item,float(y_size))
            x_entry.set_text(x_size)
            y_entry.set_text(y_size)
            units = item

        dialog = gtk.Dialog(title,None,gtk.DIALOG_MODAL |gtk.DIALOG_DESTROY_WITH_PARENT,
                (gtk.STOCK_OK,gtk.RESPONSE_OK,gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL))

        vbox = gtk.VBox(gtk.FALSE, 0)
        vbox.set_size_request(xsize,ysize)
        vbox.set_border_width(6)
        vbox.show()
        dialog.vbox.pack_start(vbox,gtk.FALSE,gtk.FALSE,0)
        x_entry = gui_set.input_box(x_title ,input_callback,str(x_size))
        y_entry = gui_set.input_box(y_title ,input_callback,str(y_size))
        units_menu = create_option_menu(menu_callback,unitsList,unitsList.index(units))

        A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        A_table = gui_set.create_table(3)
        gui_set.group_menu(A_table,A_group,0,gui_set.set_label(x_title),x_entry)
        gui_set.group_menu(A_table,A_group,1,gui_set.set_label(y_title),y_entry)
        gui_set.group_menu(A_table,A_group,2,gui_set.set_label(units_title),units_menu)
        vbox.pack_start(A_table, gtk.FALSE,gtk.FALSE, 0)
        A_table.show()

        dialog.show_all()
        response = dialog.run()
        dialog.destroy()
        if response == gtk.RESPONSE_OK:
            return (units,x_size,y_size)
        return None

