#
#       page_paper.py
#
#       2003.5.13
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import gtk
import gui_set

class PagePaper:
    #title = " a2ps "
    import Lpy.pjl.pjl_title
    sub_title = (Lpy.pjl.pjl_title.u_prettyPrint,)

    def __init__(self):
        self.BDev_box = None
        self.titletext_ent = None

    def page(self):
        base_vbox = gtk.VBox(gtk.FALSE, 0)
        base_vbox.set_border_width(self.S.Border)
        base_vbox.set_size_request(self.S.Hsize, self.S.Vsize)
        base_vbox.show()
## Header
        Mframe = gtk.Frame()
        base_vbox.pack_start(Mframe, gtk.FALSE, gtk.FALSE, 0)

        VDev_box = gtk.VBox(gtk.FALSE, 0)
        VDev_box.show()
        Mframe.add(VDev_box)
        Mframe.show()

        Dev_box = gtk.HBox(gtk.FALSE, 0)
        Dev_box.show()
        VDev_box.pack_start(Dev_box, gtk.FALSE , gtk.FALSE,0)

        Abox = gtk.VBox(gtk.TRUE, 0)
        Abox.show()
        Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)
        self.M_header = self.GUI.make_chkbutton(self.P.T_header)
        Abox.pack_start(self.M_header,gtk.TRUE,gtk.FALSE,0)
        Bbox = gtk.VBox(gtk.TRUE, 0)
        Bbox.show()
        Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 0)
        self.M_border = self.GUI.make_chkbutton(self.P.T_border)
        Bbox.pack_start(self.M_border,gtk.TRUE,gtk.FALSE,0)

        ## separator
        separator = gtk.HSeparator()
        VDev_box.pack_start(separator, gtk.FALSE, gtk.TRUE, 0)
        separator.show()

        ## header Menu
        self.make_header(VDev_box)
        self.header_menu()

## Paper
        Pframe = gtk.Frame('')
        base_vbox.pack_start(Pframe, gtk.FALSE, gtk.FALSE, 0)
        Dev_box = gtk.HBox(gtk.FALSE, 0)
        Dev_box.show()
        Pframe.add(Dev_box)

    ## Abox
        Abox = gtk.VBox(gtk.FALSE, 0)
        Abox.show()

        Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)

        A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        A_table = gui_set.create_table(2)
        Abox.pack_start(A_table, gtk.TRUE,gtk.FALSE, 0)
        self.tabsize = self.GUI.make_spin(self.P.T_tabsize)
        self.GUI.group_table(A_table, 0,A_group, self.P.T_tabsize, self.tabsize)

        fixlines = self.GUI.make_chkbutton(self.P.T_fixedlines)
        lines_per_page = self.GUI.make_spin(self.P.T_linespage)
        gui_set.group_menu(A_table,A_group,1,fixlines,lines_per_page)
        A_table.show()

        Abox.pack_start(self.GUI.make_chkbutton(self.P.T_trancate), gtk.TRUE, gtk.FALSE, 0)
        Abox.pack_start(self.GUI.make_chkbutton(self.P.T_linenumbers), gtk.TRUE, gtk.FALSE, 0)

    ## Bbox
        Bbox = gtk.VBox(gtk.TRUE, 0)
        Bbox.show()
        Dev_box.pack_start(Bbox,gtk.FALSE, gtk.FALSE, 0)

        Bbox.pack_start(self.GUI.make_chkbutton(self.P.T_watermark),gtk.TRUE,gtk.FALSE,0)
        Wbox , ent = self.GUI.input_hbox(self.P.T_watertext)
        Bbox.pack_start(Wbox,gtk.TRUE, gtk.TRUE, 0)

        button,encoding = self.GUI.table_set(self.P.T_encoding)
        Bbox.pack_start(button, gtk.TRUE, gtk.FALSE,0)

        Pframe.show()

    ## Pretty Print :program source printing
        Prframe = gtk.Frame(self.sub_title[0])
        base_vbox.pack_start(Prframe, gtk.FALSE, gtk.FALSE, 0)
        Dev_box = gtk.HBox(gtk.FALSE, 0)
        Dev_box.show()
        Prframe.add(Dev_box)
        Prframe.show()

    ## Abox
        Abox = gtk.VBox(gtk.TRUE, 0)
        Abox.show()
        Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)
        A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        A_table = gui_set.create_table(2)
        Abox.pack_start(A_table, gtk.TRUE, gtk.FALSE, 0)
        self.GUI.make_table(A_table,0,A_group,self.P.T_stylesheets)
        self.GUI.make_table(A_table,1,A_group,self.P.T_pretty)
        A_table.show()

        Bbox = gtk.VBox(gtk.TRUE, 0)
        Bbox.show()
        Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 0)
        strip,tstrip = self.GUI.table_set(self.P.T_striplevel,None,self.GUI.Upper)
        Bbox.pack_start(strip, gtk.TRUE, gtk.FALSE,0)
        return base_vbox

    def header_menu(self):
        if self.P.get_func(self.P.T_header).get_value() == 1:
            if self.BDev_box:
                self.BDev_box.show()
        else:
            if self.BDev_box:
                self.BDev_box.hide()

    def set_title_name(self,file):
        if self.titletext_ent:
            self.titletext_ent.set_text(file)
        self.P.get_func(self.P.T_titletext).set_value(file)

    def make_header(self,VDev_box):
        self.BDev_box = gtk.HBox(gtk.TRUE, 0)
        self.BDev_box.show()
        VDev_box.pack_start(self.BDev_box,gtk.TRUE,gtk.FALSE,0)

        ## Abox
        Abox = gtk.VBox(gtk.FALSE,0)
        Abox.show()
        self.BDev_box.pack_start(Abox,gtk.TRUE, gtk.FALSE,0)
        self.userID = self.GUI.make_chkbutton2(self.P.T_userid)
        Abox.pack_start(self.userID,gtk.TRUE,gtk.FALSE,0)
        Tbox ,self.useridtext_ent = self.GUI.input_hbox(self.P.T_useridtext)
        Abox.pack_start(Tbox,gtk.TRUE, gtk.FALSE, 0)

        ## title
        Tbox,self.titletext_ent = self.GUI.input_hbox(self.P.T_titletext)
        Abox.pack_start(Tbox,gtk.TRUE, gtk.FALSE, 0)
        tbutton,self.titleposition = self.GUI.table_set(self.P.T_titleposition)
        Abox.pack_start(tbutton, gtk.TRUE, gtk.FALSE,0)

        ## Bbox
        Bbox = gtk.VBox(gtk.FALSE,0)
        Bbox.show()
        self.BDev_box.pack_start(Bbox,gtk.TRUE,gtk.TRUE, 0)
        self.footerprint = self.GUI.make_chkbutton2(self.P.T_footerprint)
        Bbox.pack_start(self.footerprint, gtk.FALSE, gtk.FALSE, 0)
        Tbox , self.footer_ent = self.GUI.input_hbox(self.P.T_footertext)
        Bbox.pack_start(Tbox,gtk.FALSE,gtk.FALSE, 0)
        self.dateprint = self.GUI.make_chkbutton2(self.P.T_dateprint)
        Bbox.pack_start(self.dateprint, gtk.FALSE, gtk.FALSE, 0)
        #Bbox.pack_start(self.GUI.make_chkbutton('page'), gtk.TRUE, gtk.TRUE, 0)
