#
#   lpy_programs.py
#
#   2004.3.11
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import os

import Lpy.utils.file_utils

base_prg = {
    'gs':   'gs' ,   # "/usr/local/bin/gs",
    'a2ps':  "a2ps", # "/usr/local/bin/a2ps",
    #'a2ps_perl':    # "/usr/local/bin/a2ps_perl",

    'file': "file",  # "/usr/local/bin/file"
    'gunzip': 'gunzip',
    'bunzip2': 'bunzip2',

    'convert' : "convert",    # "/usr/local/bin/convert" (ImageMagick)
    'groff'   : 'groff',
    'grog'    : 'grog',       # troff check-program
    'texi2dvi': 'texi2dvi4a2ps', # LaTeX
    'fixps'   : "fixps",
    'dvips'   : 'dvips',         # TeX DVI to PS

    'nkf':   "nkf",     # japanese encoding
    #'pdftops': "pdftops", # xpdf

## psutils ##
    'epsffit':  "epsffit",
    #'psresize': "psresize",
    'psnup':    "psnup",
    'pstops':   "pstops",
    'psselect': "psselect",
    'psbook':   "psbook",
    'psset':    "psset",
    }

psutil_flag = 1

def not_found(prg,logfile):
    if prg == 'file':
        msg += os.linesep
        msg += "I can't check a filetype.%s" % os.linesep
        msg += "Please install %s, and Retry" % (prg)
    elif prg in ('pstops','psnup','psselect'):
        global psutil_flag
        psutil_flag = None

    msg = "%s can't be found." % (prg)
    if logfile:
        Lpy.utils.file_utils.write_logs(logfile,msg)
    else:
        print msg

def check_program(logfile = None):
    global base_prg

    for key in base_prg.keys():
        if Lpy.utils.file_utils.find_command(base_prg[key]) is None:
            base_prg[key] = None
            not_found(key,logfile)
        #print key,base_prg[key]

def get_prg(prg):
    if base_prg.has_key(prg) and base_prg[prg] != None:
        return base_prg[prg]
    return None

def check_sp_program(mprg):
    from distutils import sysconfig
    import lpy_version

    t_prg = os.sep + lpy_version.Project_dir + os.sep + mprg

    prg = sysconfig.get_python_lib() + t_prg
    if Lpy.utils.file_utils.find_command(prg):
        return prg
    else:
        prg = os.getcwd() + t_prg

        #print "check_sp_program",prg
        if Lpy.utils.file_utils.find_command(prg):
            return prg
    return None

