#
#   def_tray.py
#
#   2004.5.16
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import types
import pjl_title

class InputTray_Dict:
    TR_default = "Default"
    TR_auto   = "Auto"
    TR_tray   = "Tray"
    TR_manual = "Manual"
    TR_MPtray = "MPTray"
    TR_envelope = "Envelope"
    TR_duplex   = "Duplex"
    TR_external = "ExternalTray"
    TR_large  = "LargeTray"
    TR_roll   = "Roll"

    TrayList = (TR_default,TR_auto,TR_tray,TR_manual,TR_MPtray,
        TR_envelope,TR_duplex,TR_external,TR_large,TR_roll)

    NumTray = (TR_tray,TR_external,TR_roll)

    def init_trayList(self,flag = None):
        self.select_dict = {
            self.TR_default: [self.ON    ,pjl_title.u_default,"DEFAULT"],
            self.TR_auto:    [self.ON    ,pjl_title.u_auto   ,"AUTOSELECT"],
            self.TR_tray:    [self.ON    ,pjl_title.u_tray   ,'TRAY',self.max_val],
            self.TR_manual:  [self.ON    ,pjl_title.u_manual ,"MANUALFEED"], 
            self.TR_envelope: [self.OFF  ,pjl_title.u_EnvelopeTray,"ENVELOPETRAY"],
            self.TR_duplex :  [self.OFF  ,pjl_title.u_duplexTray  ,"DUPLEXTRAY"],
            self.TR_external: [self.OFF  ,pjl_title.u_externalTray,"EXTERNALTRAY",1],
            self.TR_MPtray  : [self.Never,pjl_title.u_mptray      ,"MPTRAY"], 
            self.TR_large   : [self.Never,pjl_title.u_lcc         ,"LCC"], 
            self.TR_roll    : [self.Never,pjl_title.u_roll        ,"ROLL",1], 
            }

        if flag == 'hp':
            no_supp = None
        else:
            no_supp = (self.TR_default,self.TR_envelope,self.TR_duplex,self.TR_external)
 
        if no_supp:
            for key in no_supp:
               self.select_dict[key][0] = self.Never

    def get_mkey(self,media = None):
        if media is None:
            media = self.value_list[self.value]
        for key in self.select_dict.keys():
            if media == self.select_dict[key][1]:
                return key
        return None

    def set_selectDict(self,lists = None):
        self.value_list = []
        for key in self.TrayList:
            if not self.select_dict.has_key(key):
                continue

            if lists:
                if self.select_dict[key][0] != self.Never:
                    self.select_dict[key][0] = self.OFF
                for name in lists:
                    if name == key:
                        self.select_dict[key][0] = self.ON
                        break
                else:
                    continue
 
            if self.select_dict[key][0] != self.ON:
                continue
            t_len = len(self.select_dict[key])
            if t_len <= 2:
                print "Error:(%s) select_dict InputTray_Dict." % key
            elif t_len == 3:
                self.value_list.append(self.select_dict[key][1])
            elif t_len >= 4:
                if key in self.NumTray:
                    for num in range(1,1 + self.select_dict[key][3]):
                        tray = self.select_dict[key][1] + ' ' + str(num)
                        self.value_list.append(tray)
        
        if self.select_dict.has_key(self.TR_auto):
            self.set_value(self.TR_auto)
        else:
            self.set_value(0)   

    def get_select_list(self,flag):
        select_lists = None
        if flag in self.NumTray:
            if self.select_dict.has_key(flag):
                if flag == self.TR_tray:
                    max = self.max_val
                elif flag == self.TR_roll:
                    max = self.roll_max
                elif flag == self.TR_external:
                    max = self.externalTray_max
                if max >= 1:
                    select_lists = '1-%d-1-2-0-0' % (max)
        return select_lists

    def get_cmdType(self):
        return self.oldCmd

    def get_tray_support(self,flag):
        if self.select_dict.has_key(flag):
            return self.select_dict[flag][0]
        return None
    def get_tray_name(self,flag):
        if self.select_dict.has_key(flag):
            return self.select_dict[flag][1]
        return None

    def get_tray_number(self,flag = None):
        if flag is None:
            return self.select_dict[self.TR_tray][3]
        if flag in self.NumTray:
            if self.select_dict.has_key(flag):
                return self.select_dict[flag][3]
        return None

    def set_tray_number(self,flag,value):
        if flag in self.NumTray:
            if self.select_dict.has_key(flag):
                self.select_dict[flag][3] = value
    
    def set_tray_support(self,flag,value):
        if self.select_dict.has_key(flag):
            if value in (self.ON,self.OFF,self.Never):
                self.select_dict[flag][0] = value
 
    def get_vlist(self):
        return self.value_list
    def set_vlist(self,value):
        pass

    def get_numTray_num(self,tray):
        if self.value_list == None or len(self.value_list) == 0:
            return None

        if self.select_dict.has_key(tray):
            tray_head = self.select_dict[tray][1]
            if isinstance(self.value,types.IntType):
                val = self.value_list[self.value]
            elif isinstance(self.value,types.StringTypes):
                val = self.value
            else:
                return None
            if val.startswith(tray_head):
                try:
                    ret = int(val.replace(tray_head,''))
                except:
                    ret = None
                return ret

        return None

    def get_pjlparm(self):
        if self.support != self.ON:
            return None

        tray = self.get_mkey()
        if tray:
            val = self.select_dict[tray][2]
        else:
            for tray in self.NumTray:
                num = self.get_numTray_num(tray)
                if num:
                    if tray == self.TR_external:
                        if num == 1:
                            val = self.select_dict[tray][2]
                        elif num >= 2:
                            val = "%s%02d" % (self.select_dict[tray][2],num)
                    else:
                        val = "%s%d" % (self.select_dict[tray][2],num)
                    break

        return "%s=%s" % (self.pjl_cmd,val)

    def get_save_value(self):
        if self.support != self.ON:
            return None
 
        mlist = []
        for key in self.TrayList:
            if not self.select_dict.has_key(key):
                continue
            if self.select_dict[key][0] == self.ON:
                mlist.append(key)

        num = []
        for tray in self.NumTray:
            num.append(str(self.get_tray_number(tray)))
        return self.support,self.get_selected(),mlist,num

    def set_load_value(self,values):
        if values and len(values) >= 4:
            tray,external,roll = values[3]
            if tray:
                self.set_tray_number(self.TR_tray,int(tray))
            if external:
                self.set_tray_number(self.TR_external,int(external))
            if roll:
                self.set_tray_number(self.TR_roll,int(roll))
            self.set_selectDict(values[2])
            self.value = int(values[1])
            self.support = self.ON
        else:
            self.support = self.Never
 
