#
#       pjl_class.py
#
#       2003.9.22
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
#
#############################################
import Lpy.utils.get_env
import Lpy.paper_size
import pjl_title
import def_pjl
import def_tray
import def_mediatype
import select_dict

## dummy Class
class Unique(def_pjl.Vparm):
    title = None
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.unique  = self.ON
        self.support = self.Never
    def get_pjlparm(self):
        if self.pjl_cmd:
            return self.pjl_cmd
        return None
    def set_load_value(self,val):
        return None
    def get_save_value(self):
        return None

## 
class Copies(def_pjl.Vparm):
    title = None
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.unique  = self.OFF
        self.support = self.ON
        self.value = 1
        self.max_val = 999
        self.pjl_cmd = 'COPIES'

    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        return "%s=%d" % (self.pjl_cmd,self.value)

class Orientation(def_pjl.Vparm):
    title = None
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.unique  = self.OFF
        self.support = self.ON
        self.value = 0
        self.pjl_cmd  = 'ORIENTATION'
        self.pjl_lists = ("PORTRAIT","LANDSCAPE")

class Resolution(def_pjl.Vparm):
    L_resolution = ('300','360','400','600','720','800','900',
            '1200','1600','1800','2400')
    title = _("Resolution")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.unique  = self.OFF
        self.save_static = self.ON
        self.pjl_cmd  = 'RESOLUTION'
        self.select_lists = self.L_resolution

        self.value_list = ['300','600','1200']
        self.media_dict = {}
        self.set_vlist(self.value_list,1)
        self.support = self.OFF
        self.set_value(1)
        self.save_list = self.ON

    def set_vlist(self,data,value = None):
        self.value_list = data
        for key in self.select_lists:
            if key in self.value_list:
                self.media_dict[key] = self.ON
            else:
                self.media_dict[key] = self.OFF
        if value >= 0:
            self.value = value

    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        return "%s=%s" % (self.pjl_cmd,self.value_list[self.get_selected()])

class Density(def_pjl.Vparm):
    title = pjl_title.u_density
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.unique  = self.OFF
        self.support = self.OFF
        self.min_val = 1
        self.max_val = 5
        self.pjl_cmd = 'DENSITY'
        self.value_list = '%d-%d-1-2-0-0' % (self.min_val,self.max_val)
        self.set_value(3)

    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        return "%s=%d" % (self.pjl_cmd,self.value)

class TonerSave(def_pjl.Vparm):
    title = _("Toner Save")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.unique  = self.OFF
        self.pjl_cmd   = 'ECONOMODE'
        self.pjl_lists = self.ON_OFF
        self.support = self.OFF
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class Smoothing(select_dict.Select_Dict,def_pjl.Vparm):
    title = _("Smoothing")
    medium_support = _('Medium Support')

    medium4 = ((pjl_title.u_off,pjl_title.u_light,pjl_title.u_medium,pjl_title.u_dark),
                ('OFF','LIGHT','MEDIUM','DARK'))
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.unique  = self.OFF
        self.support = self.OFF
        self.save_list  = self.ON
        self.pjl_cmd  = 'RET'
        self.select_dict = {
            0: [pjl_title.u_onoff, (pjl_title.u_off, pjl_title.u_on),0,self.ON_OFF],
            1: [self.medium_support,self.medium4[0],2,self.medium4[1]],
            }
        self.list_num = len(self.select_dict) -1
        self.set_selectDict()

    def get_save_value(self):
        return self.support,self.get_selected(),self.list_num

class MediaType(def_mediatype.MediaTypes,def_pjl.Vparm):
    title = pjl_title.u_media
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.save_list = self.ON
        self.pjl_cmd  = 'MEDIATYPE' 
        self.value = 0

class PaperSize(def_pjl.Vparm):
    title = pjl_title.u_paper
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.pjl_cmd = 'PAPER'
        self.value_list = Lpy.paper_size.pjl_papers
        self.set_value(0)        
        self.width  = 0
        self.height = 0
    def set_customPaper(self,width,height):
        self.width  = width
        self.height = height

class InputTray(def_tray.InputTray_Dict,def_pjl.Vparm):
    title = pjl_title.u_intray
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.ON
        self.max_val = 6
        self.roll_max = 4
        self.externalTray_max = 32
        self.oldCmd = self.OFF
        self.select_lists = '1-%d-1-2-0-0' % (self.max_val)
        self.pjl_cmd = 'MEDIASOURCE'

        #print "Tray",self.value_list

class OutTray(def_pjl.Vparm):
    title  = pjl_title.u_outtray
    title2 = pjl_title.u_outtray_number 
    select_src = (pjl_title.u_upper,pjl_title.u_lower,pjl_title.u_side)

    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.save_list  = self.ON
        self.pjl_cmd  = 'OUTBIN'
        self.max_val = 3
        self.list_num = 2
        self.select_lists = '1-%d-1-1-0-0' % (self.max_val)
        self.value = 0
        self.set_vlist(self.list_num,0)

    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        if self.pjl_cmd is None or self.pjl_lists is None:
            return None
        if len(self.pjl_lists) == 1:
             return None
        if self.value >= 0 and self.value < len(self.pjl_lists):
           return "%s=%s" % (self.pjl_cmd, self.pjl_lists[self.value])
        else:
           return None

    def get_title2(self):
        return self.title2

    def set_vlist(self,data,value = None):
        self.list_num = data
        if self.list_num == 0:
            self.support = self.OFF
        else:
            self.value_list = self.select_src[:data]
        if value >= 0:
           if value < self.list_num:
                self.value = value

    def get_slist_num(self):
        return self.list_num

    def set_load_value(self,vals):
        if len(vals) >= 3:
            self.support = vals[0]
            self.value   = vals[1]
            self.list_num = vals[2]

    def get_save_value(self):
        return self.support,self.get_selected(),self.list_num

class MailBin(def_pjl.Vparm):
    title = pjl_title.u_mailbin
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.save_list = self.ON
        self.pjl_cmd  = 'OUTBIN' # 1-62
        self.max_val = 12 #
        self.select_lists = '1-62-1-4-0-0' # max 62
        self.value_list = '1-%d-1-4-0-0' % (self.max_val)
        self.set_value(1)

class FaceUp(def_pjl.Vparm):
    title = _("FaceUp,Down")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.value_list = (pjl_title.u_faceup,pjl_title.u_facedown)
        self.set_value(0)

class Staple(def_pjl.Vparm):
    title = _("Staple")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.pjl_cmd  = 'FINISH'
        self.value_list = (pjl_title.u_none,pjl_title.u_staple1,pjl_title.u_staple2)

        self.set_value(0)

class Binding(def_pjl.Vparm):
    title = _("Binding")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = (_('LongEdge'),_('ShortEdge'))
        self.pjl_lists = ("LONGEDGE","SHORTEDGE")
        self.pjl_cmd  = 'BINDING'
        self.set_value(0)

class Punch(def_pjl.Vparm):
    title = _("Punch")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.pjl_lists = self.ON_OFF
        self.support = self.OFF
        self.value_list = self.ON_OFF
        self.pjl_cmd  = 'PUNCH'
        self.set_value(0)
        self.auto_value = self.ON

class Booklet(def_pjl.Vparm):
    title = _("Booklet Style")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.pjl_lists = self.ON_OFF
        self.support = self.OFF
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class Banner(def_pjl.Vparm):
    title = _("Banner Sheet")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.ON
        self.value_list = self.ON_OFF
        self.value = 0

class Proof(def_pjl.Vparm):
    title = _("Proof Print")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.ON
        self.value_list = self.ON_OFF
        self.value = 0

class MediaColor(def_pjl.Vparm):
    title = _("Media Color")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.set_value(0)
        self.auto_value = self.ON

## Transparency (OHP) insert paper
class InsertPaper(def_pjl.Vparm):
    title = _("Transparency interleaves")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None or self.pjl_lists is None:
            return None
        if self.value == 0:
            return "%s=%s" % (self.pjl_cmd,self.pjl_lists[0])
        else:
            return self.ON

class InsertMedia(def_mediatype.MediaTypes,def_pjl.Vparm):
    title = pjl_title.u_papertype
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.save_list = self.ON
        self.value = 0

class InsertPrinting(def_pjl.Vparm):
    title = _("Printing")
    
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = (_('Blank'),_('Printed'))
        self.set_value(0)

class InsertColor(def_pjl.Vparm):
    title = _("Interleave Color")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.set_value(0)
        self.auto_value = self.ON

## FrontCover Print
class CoverPrint(def_pjl.Vparm):
    title = _("FrontCover Insert") #Printing")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class CoverPrinting(def_pjl.Vparm):
    title = _("FrontCover Printing")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class CoverMedia(def_mediatype.MediaTypes,def_pjl.Vparm):
    title = _("FrontCover Media")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.save_list = self.ON
        self.value = 0

class CoverDuplex(def_pjl.Vparm):
    title = _("Front Duplex")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = self.ON_OFF # (pjl_title.u_off, pjl_title.u_on)
        self.set_value(0)
        self.auto_value = self.ON

class CoverColor(def_pjl.Vparm):
    title = _("FrontCover Color")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.set_value(0)
        self.auto_value = self.ON

## 
class Collation(def_pjl.Vparm):
    title = _("Collation")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        #self.value_list = self.ON_OFF
        self.value = 0

class Scaling(def_pjl.Vparm):
    title = _("Fit to Page")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class Rotate(def_pjl.Vparm):
    title = _("Rotate")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = ('0','90','180','270')
        self.set_value(0)

class Mirror(def_pjl.Vparm):
    title = _("Mirror")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.pjl_cmd  = 'MIRROR'
        self.pjl_lists = self.ON_OFF
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class Quality(def_pjl.Vparm):
    title  = _("Quality")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.pjl_cmd  = 'PRINTQUALITY'
        self.pjl_lists = ("DRAFT","NORMAL","HIGH")
        self.value_list = (_("DRAFT"),_("NORMAL"),_("HIGH"))
        self.set_value(1)

class PhotoEnhance(def_pjl.Vparm):
    title = _("Photo Enhancement")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

# Hold
class HoldData(def_pjl.Vparm):
    title = _("Hold data")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never

class HoldKey(def_pjl.Vparm):
    title = _("Hold key")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never

    def get_save_value(self):
        if self.support != self.ON:
            return None
        return self.support,self.value

    def set_load_value(self,values):
        if values is None:
            self.support = self.Never
            return None

        self.set_support(values[0])
        if not values[1]:
            self.value = 0
        else:
            self.value = values[1]

class HoldType(def_pjl.Vparm):
    title = _("Hold type")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never

## Panel Lock
class PanelLock(def_pjl.Vparm): 
    title = _("Panel Lock")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

# DiskLock
class DiskLock(def_pjl.Vparm): 
    title = _("Disk Lock")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class PanelPassword(def_pjl.Vparm): 
    title = _('Lock Password')
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.value = 0
        self.old_value = None
        self.max_val = 65535
        self.value_list = '5-1'

    def get_old_pw(self):
        return self.old_value

    def set_old_pw(self):
        self.old_value = self.value

## Division ##
class Division(def_pjl.Vparm):
    title = _("Division")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class DivisionName(def_pjl.Vparm):
    title = _("Division Code")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = '5-1'
        self.value = None
        self.max_val = 99999

## DelayPrint ##
class DelayPrint(def_pjl.Vparm): # P_delayPrint
    title = _("DelayPrint(Minutes)")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.value_list = self.ON_OFF
        self.value = self.OFF
        self.auto_value = self.ON

class DelayTime(def_pjl.Vparm): # P_delayTime
    title = _("Delay Time")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.ON #FF
        self.min_val = 0
        self.max_val = 4320 # 72 * 60 minutes
        self.value_list = '%d-%d-1-10-0-0' % (self.min_val,self.max_val)
        self.value = 0

## Accounting
class Accounting(def_pjl.Vparm): # P_accounting
    title = _("Set Accounting")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class AccountName(def_pjl.Vparm): # P_accountName
    title = _("Accounting")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.value = None
        self.value_list = '16-0'

## Security ##
class Security(def_pjl.Vparm):
    title = _("Security Print")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.Never
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

class Password(def_pjl.Vparm):
    title = _('Printing Password')
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value = None
        self.value_list = '5-1'
        self.max_val = 99999

class UserName(def_pjl.Vparm):
    title = _('User Name')
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.value_list = '16-0'

        logname = Lpy.utils.get_env.get_logname()
        if logname:
            self.value = logname

## Color Printer
class ColorPrinter(def_pjl.Vparm):
    title = pjl_title.u_colorPrinter
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.pjl_cmd  = 'RENDERMODE'
        self.pjl_lists = ("GRAYSCALE","COLOR")
        self.support = self.Never
        self.value_list = self.ON_OFF
        self.set_value(0)
        self.auto_value = self.ON

## Margin
class Margin(def_pjl.Vparm):
    title = _("Margin")
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.min_val = 0
        self.max_val = 300
        self.value_list = '%d-%d-1-10-0-0' % (self.min_val,self.max_val)
        self.value = 0
    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None:
            return None
        return "%s=%d" % (self.pjl_cmd,self.value)

class MarginLeft(Margin):
    title = _("Margin(Left)")
    def __init__(self):
        Margin.__init__(self)
        self.support = self.OFF
        self.value = 0
class MarginRight(Margin):
    title = _("Margin(Right)")
    def __init__(self):
        Margin.__init__(self)
        self.support = self.OFF
        self.value = 0
class MarginTop(Margin):
    title = _("Margin(Top)")
    def __init__(self):
        Margin.__init__(self)
        self.support = self.OFF
        self.value = 0
class MarginBottom(Margin):
    title = _("Margin(Bottom)")
    def __init__(self):
        Margin.__init__(self)
        self.support = self.OFF
        self.value = 0

