#
#   Printer_model.py
#
#   2004.1.5
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_title
import Lpy.fconvert.file_type
import Lpy.gs_filter

# for snmp/snmp_option.py
o_printer = 'printertype'
o_color  =  'color' 
o_supply =  'supply'
o_lang   =  'lang'  
o_duplex =  'duplex'
o_intray  = 'inputTray'  
o_outtray =  'outputTray' 
o_first2last = 'firstToLast'
o_faceup  = 'faceup'   
o_mailbin = 'mailbin'  
o_media   = 'mediatype'
o_finisher = 'finisher' 
o_papersize = 'papersize'

supply_colors = (('black',Lpy.pjl.pjl_title.u_black),('cyan',Lpy.pjl.pjl_title.u_cyan),
                 ('magenta',Lpy.pjl.pjl_title.u_magenta),('yellow',Lpy.pjl.pjl_title.u_yellow))

class Model_lang:
    ## Mechanism ##
    Laser  = "PM_Laser"
    CLaser = "PM_CLaser"
    InkJet = "PM_InkJet"
    Thermal = "PM_Thermal"
    DotMatrix = "PM_DotMatrix"

    ## Model ##
    N_enterprise = 'Enterprise'
    N_personal   = 'Personal'
 
    models = (N_enterprise,N_personal)

    PP_type = {
            Laser : (Lpy.pjl.pjl_title.u_Laser),
            CLaser: (Lpy.pjl.pjl_title.u_ColorLaser),
            InkJet: (Lpy.pjl.pjl_title.u_InkJet),
        }
    pt_keys = (Laser,CLaser,InkJet)

    ## Lang
    F_ps   = Lpy.fconvert.file_type.F_ps
    F_pcl  = Lpy.fconvert.file_type.F_pcl
    F_hpgl = Lpy.fconvert.file_type.F_HPGL

    pcl3 = Lpy.gs_filter.get_filters("pcl3")
    pcl4 = Lpy.gs_filter.get_filters("pcl4")
    pcl5 = Lpy.gs_filter.get_filters("pcl5")
    pcl5c = Lpy.gs_filter.get_filters("pcl5c")

    def __init__(self):
        pass

    def get_keyname(self,name):
        if name in self.pt_keys:
            return name
        for key in self.pt_keys:
            if name == self.PP_type[key]:
                return key
        else:
            print "Printer_model.py:get_keyname():Error(%s)" % (name)
        return None

    def get_typename(self,keyname):
        if self.PP_type.has_key(keyname):
            return self.PP_type[keyname]
        return None

    def get_namelists(self,names):
        value_list = []
        for key in names:
            if self.PP_type.has_key(key):
                value_list.append(self.PP_type[key])
        return value_list

    # overwrite !!
    def get_printer_model(self,ptype):
        return self.models

    def get_langList(self,ptype,model,flag = 0):
        support_pjl = (self.F_pcl,self.F_ps)

        if ptype == self.Laser: # B/W Laser
            if flag == 0:   # Lang list
                return support_pjl
            elif flag == 1: # GS filter
                return self.pcl4 + self.pcl5

        elif ptype == self.CLaser: # Color Laser
            if flag == 0:
                return support_pjl
            elif flag == 1:
                return self.pcl4 + self.pcl5 + self.pcl5c
        else:
            print "No supported printer_type(%s:%s:%s)" % (ptype,model,flag)
            return None


# print "check_model:%s (%s:%s)" % (self.__class__.__name__,printertype,model)
 
