#
#       socket_cmd.py
#
#       2003.9.14
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import socket,select

class Socket_Client: # UDP client

    def __init__(self,host,port,timeout = 2.0,retries = 5):
        self.host = host
        self.port = port
        self.timeout = timeout
        self.retries = retries
        self.sock  = None
        self.error = []
        self.open(socket.SOCK_DGRAM)  # socket.SOCK_STREAM

    def get_error(self,last = None):
        if self.error:
            if last == "last":
                return self.error[-1]
            else:
                return self.error
        return None

    def __del__(self):
        if self.sock:
            self.sock.close()

    def close(self):
        if self.sock:
            try:
                self.sock.close()
            except socket.error,msg:
                self.error = 'socket close() error: %s' % str(msg)
            self.sock = None

    def open_v4(self):
            try:
                self.sock = socket.socket(socket.AF_INET,socket.SOCK_DGRAM)
            except socket.error, msg:
                self.sock = None
                self.error.append("socket open Error:%d" % msg[0])
                print "socket open Error:" ,msg[1]

    ## open v4 and v6
    def open(self,socketType = socket.SOCK_DGRAM):
        try:
            addresses = socket.getaddrinfo(self.host,self.port,socket.AF_UNSPEC,socketType)
        except:
            self.error.append("socket open Error:")
            #print "socket open Error:"
            return None

        for res in addresses:
            af,socktype,proto,canonname,sa = res

            try:
                self.sock = socket.socket(af,socktype,proto)
            except socket.err,msg:
                self.sock = None
                self.error.append("socket open Error:%d" % msg[0])
                #print "socket open Error:" ,msg[1]
                continue
            try:
                self.sock.connect(sa)
            except socket.err,msg:
                self.sock.close()
                self.sock = None
                self.error.append("socket connect Error:%d" % msg[0])
                #print "socket open Error:" ,msg[1]
                continue
            break

    def send(self,data):
        try:
            #ret = self.sock.sendto(data,(self.host,self.port))
            ret = self.sock.send(data)
        except socket.error,msg:
            self.error.append("socket send Error: %s" % msg)
            return None
        if ret != len(data):
            self.error.append("socket send data Size Error.")
            return None
        return ret

    def host_check(self,host,port):
        if port == self.port:
            if host != self.host:
                if host != socket.gethostbyname(self.host):
                    return None
            return 1
        return None

    def receive(self):
        input,output,exc = select.select([self.sock],[],[],self.timeout)
        if input:
            try:
                #message,address = self.sock.recvfrom(65535)
                message = self.sock.recv(65535)
            except socket.error,msg:
                self.error.append("socket receive Error: %d" % msg[0])
                print "socket receive Error:" ,msg[1]
                return None
            return message
        else:
            self.error.append("socket receive timeout Error.")
        return None

    def send_and_receive(self,data):
        if not self.sock:
            return None

        retries = 0
        while retries < self.retries:
            ret = self.send(data)
            if ret:
                message = self.receive()
                if message:
                    return message
            retries += 1
        return None
