#
#       epson_pjl.py
#
#       2003.11.20
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_printer
import Lpy.pjl.pjl_class
import epson_models

class Vendor_PrinterType(Lpy.pjl.pjl_printer.PrinterType,epson_models.Epson_Model):
    def __init__(self,ptype = None,model = None):
        Lpy.pjl.pjl_printer.PrinterType.__init__(self)
        epson_models.Epson_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_model(Lpy.pjl.pjl_printer.PrinterModel,epson_models.Epson_Model):
    def __init__(self,ptype,model = None):
        Lpy.pjl.pjl_printer.PrinterModel.__init__(self)
        epson_models.Epson_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_lang(Lpy.pjl.pjl_printer.PrinterLang,epson_models.Epson_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.PrinterLang.__init__(self)
        epson_models.Epson_Model.__init__(self)
        self.check_model(ptype,model)
        self.value = self.value_list[0]

class Vendor_gs(Lpy.pjl.pjl_printer.GhostScript,epson_models.Epson_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.GhostScript.__init__(self)
        epson_models.Epson_Model.__init__(self)
        self.support = self.ON
        self.value = "escpage"

class Vendor_PrinterPJL(Lpy.pjl.pjl_printer.PrinterPJL,epson_models.Epson_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.PrinterPJL.__init__(self)
        epson_models.Epson_Model.__init__(self)
        self.support = self.OFF

#####
class Vendor_SNMP(Lpy.pjl.pjl_printer.SNMP,epson_models.Epson_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.SNMP.__init__(self)
        epson_models.Epson_Model.__init__(self)
        self.vendorID = 1248
    def check_model(self,ptype,model):
        self.support = self.OFF

class Vendor_IPP(Lpy.pjl.pjl_printer.IPP,epson_models.Epson_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.IPP.__init__(self)
        epson_models.Epson_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.OFF

class Vendor_Duplex(Lpy.pjl.pjl_printer.Duplex,epson_models.Epson_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.Duplex.__init__(self)
        epson_models.Epson_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

#####
class Vendor_Copies(Lpy.pjl.pjl_class.Copies,epson_models.Epson_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Copies.__init__(self)
        epson_models.Epson_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_Orientation(Lpy.pjl.pjl_class.Orientation,epson_models.Epson_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Orientation.__init__(self)
        epson_models.Epson_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

## Color Printer
class Vendor_colorPrinter(Lpy.pjl.pjl_class.ColorPrinter,epson_models.Epson_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.ColorPrinter.__init__(self)
        epson_models.Epson_Model.__init__(self)
        self.pjl_cmd = None
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
        else:
            self.support = self.ON


