#
#       hp.py
#
#       2003.10.23
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_vendor
import Lpy.vendors.hp_pjl
import Lpy.pjl.pjl_snmp

private_mib = "Lpy.vendors.hp_snmp"

class Maker_PJL(Lpy.pjl.pjl_vendor.PJL_Vendor,Lpy.pjl.pjl_snmp.PJL_SNMP):
    #Maker = 'HP'
    pjl_files = "Lpy.vendors.hp_pjl"
    d_classes = Lpy.pjl.pjl_vendor.get_dummy_class(pjl_files,Lpy.vendors.hp_pjl.__dict__.keys())
 
    def __init__(self,maker,printertype,model):
        Lpy.pjl.pjl_vendor.PJL_Vendor.__init__(self,maker,printertype)
        Lpy.pjl.pjl_snmp.PJL_SNMP.__init__(self,private_mib)

        self.init_vendor(maker,printertype,model)
        self.init_support()

        ## PJL end reset
        #self.pjl_Reset = self.OFF

    def get_snmpFile(self,productname,model):
        # Get a privateMIB file 
        # Lpy/vendors/hp_snmp/CLJ8550.py
        if self.get_func(self.P_model).get_color_model(model):
            return "CLJ8550" 
        else:
            return "LJ4300"

    def set_privateMib(self,snmp_data,privateMIB,productname):
        Lpy.printer_model

        check_titles = ('phd','outbins','media',
                'prtoutputdecollating',
                'prtoutputpagecollated',
                'prtoutputoffsetstacking')

        p_data = self.get_vendor_mib(snmp_data,privateMIB,check_titles)
        if not p_data:
            return None

        keys = p_data.keys()
        keys.sort()
        phds     = []
        outbins = []
        medias  = []

        for key in keys:
            #print "%s (%s) = %s" % (key,p_data[key][0],p_data[key][1])
            if key.startswith('phd'):
                phds.append(p_data[key][1])
                
            elif key.startswith('outbins'):
                outbins.append(p_data[key][1])

            elif key.startswith('media'):
                medias.append(p_data[key][1])

        dat = {} 
        """
        if len(phds) >= 1: # P_outtray
            dat[Lpy.printer_model.o_intray ] = [intrays,self.ON]
            dat[Lpy.printer_model.o_finisher] = [finishers,self.ON]

            # P_staple  
            # P_punch 
            # P_binding 
  
        if len(outbins) >= 1: # P_outtray ,P_mailbin 
            mailbins = []
            dat[Lpy.printer_model.o_outtray] = [outtrays,self.ON]
            dat[Lpy.printer_model.o_mailbin] = [mailbins,self.ON]

        #P_collate
 
        if len(medias) >= 1:
            vlist = self.get_func(self.P_mediatype).get_vlist()
            dat[Lpy.printer_model.o_media] = [medias,self.ON]
        """
        
        if not dat:
            return None
        else:
            return dat
