#
#       okidata_pjl.py
#
#       2003.12.18
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_class
import Lpy.pjl.pjl_printer

import Lpy.printer_model

class OkiData_Model(Lpy.printer_model.Model_lang):
    model_lists = [Lpy.printer_model.Model_lang.Laser,Lpy.printer_model.Model_lang.CLaser] 

    def __init__(self):
        Lpy.printer_model.Model_lang.__init__(self)

class Vendor_PrinterType(Lpy.pjl.pjl_printer.PrinterType,OkiData_Model):
    def __init__(self,ptype = None,model = None):
        Lpy.pjl.pjl_printer.PrinterType.__init__(self)
        OkiData_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_model(Lpy.pjl.pjl_printer.PrinterModel,OkiData_Model):
    def __init__(self,ptype,model= None):
        Lpy.pjl.pjl_printer.PrinterModel.__init__(self)
        OkiData_Model.__init__(self)

        self.check_model(ptype,model)

class Vendor_lang(Lpy.pjl.pjl_printer.PrinterLang,OkiData_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.PrinterLang.__init__(self)
        OkiData_Model.__init__(self)

        self.check_model(ptype,model)
        self.value = self.value_list[0]

class Vendor_gs(Lpy.pjl.pjl_printer.GhostScript,OkiData_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.GhostScript.__init__(self)
        OkiData_Model.__init__(self)

        self.support = self.OFF
        self.value = None

class Vendor_PrinterPJL(Lpy.pjl.pjl_printer.PrinterPJL,OkiData_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.PrinterPJL.__init__(self)
        OkiData_Model.__init__(self)

    def check_model(self,ptype,model):
        self.support = self.OFF
        self.tmp = self.OFF

#####

class Vendor_SNMP(Lpy.pjl.pjl_printer.SNMP,OkiData_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.SNMP.__init__(self)
        OkiData_Model.__init__(self)

        self.vendorID = 2001
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_IPP(Lpy.pjl.pjl_printer.IPP,OkiData_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.IPP.__init__(self)
        OkiData_Model.__init__(self)

    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_Duplex(Lpy.pjl.pjl_printer.Duplex,OkiData_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.Duplex.__init__(self)
        OkiData_Model.__init__(self)

    def check_model(self,ptype,model):
        self.support = self.ON

#####
class Vendor_Copies(Lpy.pjl.pjl_class.Copies,OkiData_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Copies.__init__(self)
        OkiData_Model.__init__(self)

    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_Orientation(Lpy.pjl.pjl_class.Orientation,OkiData_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Orientation.__init__(self)
        OkiData_Model.__init__(self)

    def check_model(self,ptype,model):
        self.support =  self.ON

## Color Printer
class Vendor_colorPrinter(Lpy.pjl.pjl_class.ColorPrinter,OkiData_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.ColorPrinter.__init__(self)
        OkiData_Model.__init__(self)

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
        else:
            self.support = self.ON
