#
#       output_set.py
#
#       2003.11.25
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import os

import Lpy.utils.file_utils
import Lpy.utils.get_env
import Lpy.lpy_programs
import Lpy.def_spooler
import Lpy.paper_size

import file_type

class OutPut_Set:
    Number_file = ".record"

    def set_jobnumber(self):
        nfile = self.lpy_dir + os.sep + self.Number_file
        number = Lpy.utils.file_utils.get_filedata(nfile,12)
        if number is None or len(number) == 0:
            number = 0
        else:
            number = number[0]
        jobnumber = int(number) + 1

        if jobnumber >= 10000:
           jobnumber = 1
        Lpy.utils.file_utils.write_tmpfile(nfile,str(jobnumber),"w")
        return jobnumber

    def get_jobname(self,jobnumber):
        uname = self.PJL.get_func(self.PJL.P_userName).get_value()
        if uname is None:
            uname = Lpy.utils.get_env.get_logname()
        return "%s_%04d %s" % (uname,jobnumber,Lpy.utils.file_utils.get_localtime())

   ## ToPS ##
    def a2ps_duplex(self,ftype):
        flist = self.get_a2ps_argument(ftype)

        if self.PJL.get_func(self.PJL.P_duplex).get_value() == self.ok:
            if (self.get_func(self.T_output).get_value() == self.ok or
                (self.get_func(self.T_output).get_value() == self.off and
                 self.PJL.get_func(self.PJL.P_duplex).get_support() == self.ON)):
                flist += ' --sides=duplex'

        return flist + ' --output=-'

    ## PJL
    def reserve_pjl_parm(self,filetype,flag):
        if flag == 1:
            self.copies_support = self.PJL.get_func(self.PJL.P_copies).get_support()
            self.copies_value = self.PJL.get_func(self.PJL.P_copies).get_value()
            self.orientation_support = self.PJL.get_func(self.PJL.P_orientation).get_support()
            self.orientation_value = self.PJL.get_func(self.PJL.P_orientation).get_value()
        else:
            self.PJL.get_func(self.PJL.P_copies).set_support(self.copies_support)
            self.PJL.get_func(self.PJL.P_copies).set_value(self.copies_value)
            self.PJL.get_func(self.PJL.P_orientation).set_support(self.orientation_support)
            self.PJL.get_func(self.PJL.P_orientation).set_value(self.orientation_value)
            return None

        if filetype == file_type.F_text:
            self.PJL.get_func(self.PJL.P_copies).set_support(self.OFF)
            self.PJL.get_func(self.PJL.P_orientation).set_support(self.OFF)
        else:
            self.PJL.get_func(self.PJL.P_copies).set_support(self.ON)
            self.PJL.get_func(self.PJL.P_copies).set_value(self.get_func(self.T_copies).get_value())
            self.PJL.get_func(self.PJL.P_orientation).set_support(self.ON)
            self.PJL.get_func(self.PJL.P_orientation).set_value(self.get_func(self.T_portrait).get_selected())

    def set_PJL_header(self,cmds,filetype, tmpfile,jobnumber):
        self.reserve_pjl_parm(filetype,1)
        jobname = self.get_jobname(jobnumber)
        pjl_parm = self.PJL.get_pjl_header(jobname)
        pjl_parm += self.PJL.pjl_output_common()

        dat = self.PJL.pjl_output_inputTray()
        if dat:
            pjl_parm += dat
        dat = self.PJL.pjl_output_outputTray()
        if dat:
            pjl_parm += dat
        
        dat = self.PJL.vendor_unique_pjl()
        if dat:
            pjl_parm += dat

        ## end setting
        self.reserve_pjl_parm(filetype,2)

        pjl_parm += self.PJL.get_pjl_head_end(filetype)
        if Lpy.utils.file_utils.write_tmpfile(tmpfile,pjl_parm,"w") is None:
            return _("I can't write a tmpfile for pjl data.")

        msg = Lpy.utils.file_utils.sys_command("%s >> %s" % (cmds,tmpfile))
        if msg:
            return _("I can't add a pjl data.")

        pjl_parm = self.PJL.get_pjl_tail(jobname)
        if Lpy.utils.file_utils.write_tmpfile(tmpfile,pjl_parm,"a") == None:
            return _("I can't write a tmpfile for pjl data.")
        return None

    ## Send data ==> Printer
    def send_data_spooler(self,printer,filename,cmd,jobnumber,jobname):
        spooler = Lpy.def_spooler.spooler
        options = self.get_func(self.T_option).get_value()

        if spooler == Lpy.def_spooler.L_lp:
            if cmd is None:
                Lpr = "%s -c -d %s -t %s %s " % (spooler,printer,jobname,options)
            else:
                Lpr = "%s -d %s -t %s %s " % (spooler,printer,jobname,options)
        else:
                Lpr = "%s -P %s -J %s %s " % (spooler,printer,jobname,options)

        if filename and os.path.isfile(filename):
            cmds = "%s %s" % (Lpr,filename)
        elif cmd:
            cmds = cmd + ' | ' + Lpr
        else:
            return "send_data_spooler: program error."

        if self.Debug < 5:
            ret = Lpy.utils.file_utils.sys_command(cmds)
        else:
            ret = None
            print cmds

        if self.Debug >= 1:
            self.write_logs("%d:%s" % (jobnumber,cmds))
        return ret

    def out_data_cmds(self,cmds,lang,psfile,pdl,jobname):
        if pdl is None:
            ## GS Filter
            mylang = self.PJL.get_func(self.PJL.P_lang).get_value() # printer PDL
            if mylang != file_type.F_ps:
                papersize,hh = self.get_func(self.T_paper).get_realPaper(Lpy.paper_size.U_points)
                filters = self.PJL.get_func(self.PJL.P_GS).get_filter(papersize,hh)
                if filters:
                    if cmds:
                        cmds += "| %s -" % (filters)
                    else:
                        cmds = "%s %s " % (filters,psfile)
                else:
                    return _("A GhostScript filter isn't defined.")
                lang = mylang

        if cmds is None:
            cmds = "cat %s " % (psfile)

        jobnumber = self.set_jobnumber()
        tmpfile = None

        ## PJL header
        if self.PJL.get_func(self.PJL.P_pjl).check_personality(lang) == self.ON: # file LANG
            tmpfile = Lpy.utils.file_utils.make_tmpfile("pjloutfile")
            msg = self.set_PJL_header(cmds,lang,tmpfile,jobnumber)
            if msg:
                Lpy.utils.file_utils.remove_file(tmpfile)
                return msg
            cmds = None
        ret = self.send_data_spooler(self.printer,tmpfile,cmds,jobnumber,jobname)
        if tmpfile and self.Debug <= 1:
            Lpy.utils.file_utils.remove_file(tmpfile)
        return ret
