#
#   gs_filter.py
#
#   2004.2.25
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################

pcl_filter = {
    "pcl3" : ["ljet3","ljet3d"],
    "pcl4" : ["ljet4","ljet4d","laserjet","ljet3","ljet3d","ljet4pjl","ljetplus"], 
    "pcl5" : ["lj5mono","lj5gray","pxlmono"],
    "pcl5c" : ["cljet5","cljet5c","cljet5pr","pxlcolor"],

    "lips":   ["lips4","lips4v","lips3"],
    "epson":  ["escpage","lp8000","lp2000","lq850","alc4000","alc8600",
              "alc2000","alc8500","epl2050","epl2050p","epl5800"],
    "nec":     ["npdl",],
    "ricoh":   ["rpdl",],
    #"fujitsu": ["fmlbp","fmpr"],
    #"gdi_Samsung": ["gdi",],
    #"lexmark": ["lxm5700m","lxm3200","lex5700","lex7000","lex2050","lex3200","lx5000"],
  }

upp_filter = None

import Lpy.utils.file_utils

def get_filters(name):
    if pcl_filter.has_key(name):
        return pcl_filter[name]
    return None

# check a upp-filter file
def check_upp(gs_path):
    global upp_filter
    for upp in upp_filter.keys():
        count = 0
        for filter in upp_filter[upp]:
            if Lpy.utils.file_utils.check_file(gs_path + os.sep + filter) in Lpy.utils.file_utils.Error_lists:
                del upp_filter[upp][count]
            count += 1

def check_gs_filters():
        import Lpy.lpy_programs
        gs = Lpy.lpy_programs.get_prg('gs')
        if gs is None:
            return None

        data = Lpy.utils.file_utils.get_command_data('%s -h' % gs)
        if data is None :
            return None

        gs_devices = []
        gs_paths = []
        indata = 0
        for line in data:
            if line.startswith("Available devices:"):
                indata = 1
            elif line.startswith("Search path:"):
                indata = 2
            else:
                if indata == 1:
                    gs_devices += line.split()
                elif indata == 2:
                    if line[0] != ' ' and line[0] != '\t':
                        break
                    gs_paths += line.split()

        global pcl_filter
        for key in pcl_filter.keys():
            count = 0
            for filter in pcl_filter[key]:
                if not filter in gs_devices:
                    del pcl_filter[key][count]
                count += 1

        # for upp
        if upp_filter and gs_paths:
            gs_path = None
            for key in gs_paths:
                if len(key) > 4 and key.rfind("/lib") > 4:
                    gs_path = key
                    break
            if gs_path:
                check_upp(gs_path)
        return 1

def check_gs(logfile = None):
        if check_gs_filters() is None:
            msg = "Ghostscript doesn't have a filter."
            if logfile:
                Lpy.utils.file_utils.write_logs(logfile,msg)
            else:
                print msg


