#
#   lpy_main.py
#
#   2003.6.16
#   2003.9.30
#   2004.11.19
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#############################################
import os
import gettext
import lpy_version

try:
    gettext.install(lpy_version.Command_name, None, unicode = 1)
except:
    import __builtin__
    def dummy(text):
        return text
    __builtin__.__dict__["_"] = dummy

###########################################
import def_parm
import Lpy.utils.file_utils
import Lpy.utils.get_env
import lpy_programs
import gs_filter

if def_parm.log_encode:
    Encoding = def_parm.log_encode
else:
    import Lpy.fconvert.f_encoding
    Encoding = Lpy.fconvert.f_encoding.get_encode()

lpy_dir = Lpy.utils.get_env.get_home() + os.sep + def_parm.lpy_dir
logfile = lpy_dir + os.sep + def_parm.logFile
Lpy.utils.file_utils.check_dir(lpy_dir)

# program check
prg_installed = lpy_dir + os.sep + def_parm.notFound
Lpy.utils.file_utils.remove_file(prg_installed)
lpy_programs.check_program(prg_installed)
gs_filter.check_gs(prg_installed)

import a2ps_value
import lpy_parmfile
import Lpy.fconvert.output_data
import Lpy.vendors

class Printer(object, a2ps_value.A2PS_Value, lpy_parmfile.Parm_File, Lpy.fconvert.output_data.OutPut_Data):
    vendor_makers = Lpy.vendors.vendor_names
    Display_menu = 1
    Commandline  = 2
    menutype = Display_menu # Commandline
    gui_menu = def_parm.gui_gtk

    Debug = def_parm.debug

    def __init__(self):
        a2ps_value.A2PS_Value.__init__(self)
        self.lpy_dir = lpy_dir
        self.lastprinter = None
        self.printer  = None
        self.PJL      = None
        self.Menu     = None
        self.messages = None
        self.PJL_dict = {}
        
        for key in self.PR.get_vlist():
            self.load_pjl_file(self.PR.get_printer(key))
        self.set_pjl_parm(self.PR.get_value(), 1)

## start ##
    def start(self,argvs):
        self.write_logs('Start lpy program.')

        self.set_args(argvs)
        files = self.get_func(self.T_outprinter).get_value()
        if files:
            self.get_func(self.T_titletext).set_value(os.path.basename(files))

        if self.menutype == self.Commandline and files:
            self.gui_menu = None
            self.output_data()
        else:
            ## GUI Menu

            try:
                import pygtk
                pygtk.require('2.0')
                import gtk
            except:
                try:
                    import qt
                    self.gui_menu = def_parm.gui_qt
                except:
                    self.gui_menu = None

            if self.gui_menu == def_parm.gui_gtk: # GTK
                import message_win
                import gtk_menu.menu_main
  
                self.Menu = gtk_menu.menu_main.Memu_Main(self.gui_menu,'lpy')
                self.messages = message_win.Message_Win(self.gui_menu) 
        
            elif self.gui_menu == def_parm.gui_qt: # Qt
                print _("Now PyQt is not supported.")

            else:
                print _("GUI modules are not installed.")
                print _("Please install python GTK.")

            if self.Menu:
                self.set_menu_value()
                self.Menu.main()
                self.messages.end_msg_win()

        self.get_func(self.T_outprinter).clean_tmpfile()
        self.write_logs('End lpy program.')

        if Lpy.utils.file_utils.check_filename(logfile) == None:
            return None
        try:
            size = os.path.getsize(logfile)
        except:
            return None
        if size < def_parm.maxBytes:
            return None
        Lpy.utils.file_utils.log_rotate(lpy_dir,def_parm.logFile,def_parm.logCount)  

## Set Maker PJL
    def set_maker(self,name,maker,printertype=None,model = None):
        self.PJL_dict[name] = Lpy.vendors.get_vendor_obj(maker,printertype,model)
        if self.PJL_dict[name] == None:
            print "invalid vendor-name (%s:%s)" % (maker,model)
            return None

        pjl = self.PJL_dict[name]
        pjl.get_func(pjl.P_printer).set_value(name)
        pjl.get_func(pjl.P_maker).set_vlist(self.vendor_makers,maker)
        return self.PJL_dict[name]

    def set_menu_value(self):
        if self.Menu is None:
            return None
        self.Menu.__dict__['P']   = self
        self.Menu.__dict__['PJL'] = self.PJL

    def get_printer_pjl(self,printer):
        if self.PJL_dict.has_key(printer):
            return self.PJL_dict[printer]
        else:
            print "get_printer_pjl :Error (%s)" % (printer)
            return None

    def set_pjl_parm(self,printer,force = None):
        dprinter = self.PR.get_printer(printer)
        self.lastprinter = self.lpy_dir + os.sep + "lastprint" + '.' + dprinter
        if dprinter != self.printer or force:
            self.printer = dprinter
            self.PR.set_value(self.printer)
            self.PJL = self.get_printer_pjl(self.printer)
            if self.PJL is None:
                print "self.PJL is None. (%s)" % printer
            self.set_menu_value()

## Error ##
    def write_logs(msg1,msg2 = None):
        if not msg1:
            return None
        msg = Lpy.utils.file_utils.get_localtime() + msg1
        if not msg1.endswith(os.linesep):
           msg += os.linesep

        if msg2:
            if not msg2.endswith(os.linesep):
                msg2 += os.linesep
            msg += msg2

        if Lpy.utils.file_utils.write_tmpfile(logfile,msg,"a",Encoding) is None:
            print "A log isn't be written in the logfile (%s)." % logfile
            print Lpy.utils.file_utils.get_error_msg()
            print msg1

    write_logs = staticmethod(write_logs)
    
## Error Dialog
    def error_menu(message, data = None, error = None):
        Printer.write_logs(message,data)

        if  Printer.gui_menu == def_parm.gui_gtk: ## GTK
                import gtk_menu.dialog_menu
                if error is None:
                    error = gtk_menu.dialog_menu.Error
                gtk_menu.dialog_menu.error_dialog(message,data,error)
        elif  Printer.gui_menu == def_parm.gui_qt: ## Qt
                pass
        else:
            print message
            if data:
                print data

    error_menu = staticmethod(error_menu)

## Sure Dialog
    def sure_dialog(self,title,message):
        if self.gui_menu == def_parm.gui_gtk: ## GTK
            import gtk_menu.dialog_menu
            if gtk_menu.dialog_menu.sure_dialog(title,message):
                return 1
        elif self.gui_menu == def_parm.gui_qt:
            pass # Qt message

        return None

