#
#       lpy_parmfile.py
#
#       2004.4.2
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import os
import types

import Lpy.def_parm
import Lpy.lpy_argset

import Lpy.utils.file_utils
import Lpy.utils.read_xml
import Lpy.pjl.pjl_value

tabs = ' '*4

debug = 0

class Parm_File(Lpy.lpy_argset.Lpy_ArgSet):
    xml_top = 'printer'
    PJL_suffix  = '.pjl'
    A2PS_suffix = '.a2ps'
    XML_suffix  = '.xml'

#### Load,Save filename ####
    def get_filename(self,printer):
        return self.lpy_dir + os.sep + printer

    def get_suffix(self,flag = None):
        if flag and flag == self.PJL_suffix:
            suffix = self.PJL_suffix
        else:
            suffix = self.A2PS_suffix

        if Lpy.def_parm.Parm_type == Lpy.def_parm.F_xml:
            suffix += self.XML_suffix
        return  suffix

    def check_suffix(self,filename,flag = None):
        suffix = self.get_suffix(flag)

        if not filename.endswith(suffix):
            filename += suffix
        return filename

## PJL:Save
    def save_pjl_file(self,PJL,printer):
        filename = self.check_suffix(self.get_filename(printer),self.PJL_suffix)

        num = self.lastprinter.rfind('.')
        if printer == self.lastprinter[num + 1:]:
            lastprint = self.lastprinter + self.A2PS_suffix
            if Lpy.def_parm.Parm_type == Lpy.def_parm.F_xml:
                lastprint += self.XML_suffix
            Lpy.utils.file_utils.remove_file(lastprint)

        data = {}
        for key in PJL.get_clist():
            data[key] = PJL.get_func(key).get_save_value()
            #print "%s:%s" % (key,data[key] )

        if Lpy.def_parm.Parm_type == Lpy.def_parm.F_marshal:
            ret = Lpy.utils.file_utils.save_parm_marshal(filename,data)
        else:
            xml_data = self.dict_to_xml(self.xml_top,data)
            ret = Lpy.utils.file_utils.write_tmpfile(filename,xml_data,"w")
        return ret

 ## PJL:Load
    def load_pjl_file(self,name):
        filename = self.check_suffix(self.get_filename(name),self.PJL_suffix)
        if os.path.isfile(filename):
            ret,PJL = self._load_pjl_parm(name,filename)
            if ret == Lpy.utils.file_utils.OK and PJL:
                return PJL

        if name == Lpy.def_parm.Dummy:
            return self.set_maker(name,Lpy.def_parm.Dummy)
        else:
            return self.set_maker(name,Lpy.def_parm.default_vendor)

    def _load_pjl_parm(self,printer,filename = None):
        if filename == None:
            filename = self.get_filename(printer)
        filename = self.check_suffix(filename,self.PJL_suffix)
        if not os.path.isfile(filename):
            return None
        if Lpy.def_parm.Parm_type == Lpy.def_parm.F_marshal:
            data = Lpy.utils.file_utils.load_parm_marshal(filename)
            if data is None:
                #print Lpy.utils.file_utils.get_error_msg()
                return None
        else:
            xmlparse = Lpy.utils.read_xml.Set_XML(filename)
            xdata = xmlparse.get_syntax(self.xml_top) # top document
            if xdata is None:
                #print xmlparse.get_error()
                return None
            #  xmlparse.print_xml_data()
            data = self._set_dict(xdata[0])

        if not isinstance(data,types.DictType):
            print "The (%s) file_data is a error." % filename
            return Lpy.utils.file_utils.Error_datatype,None
        name = data[Lpy.pjl.pjl_value.AP_printer][0]
        if name != printer:
            print "Load data::printer name is different:(%s:%s) (%s)" % (name,printer,filename)
            return Lpy.utils.file_utils.Error_datatype,None

        return self._check_load_data(name,data,filename)

    def _check_load_data(self,name,data,filename):
        maker = data[Lpy.pjl.pjl_value.AP_maker][1]
        printertype = data[Lpy.pjl.pjl_value.AP_type][1]
        model = data[Lpy.pjl.pjl_value.AP_model][1]

        if not isinstance(maker,types.StringType) or not maker in self.vendor_makers:
            print "Load data::maker Error:(%s:%s) (%s)" % (maker,printertype,filename)
            return Lpy.utils.file_utils.Error_datatype,None
        else:
            PJL = self.set_maker(name,maker,printertype,model)

        keys = data.keys()
        keys.sort()
        clist = PJL.get_clist()
        for key in clist:
            if key in keys:
                if debug == 1:
                    print key,data[key]
                PJL.get_func(key).set_load_value(data[key])

        return Lpy.utils.file_utils.OK,PJL

## s2ps :Load ##
    def load_a2ps_file(self,filename):
        if filename is None:
            return None

        if not filename.endswith(self.get_suffix()):
            message = _("this file is not a a2ps parameter file.")
            self.error_menu(message,filename)
            return None

        self.printer = None
        ret = self.load_a2ps(None,filename)
        if ret == self.ON and self.Menu:
            self.Menu.menu_change()
        return ret

    def load_a2ps(self,printer=None,filename=None):
        if printer and printer != self.printer:
            self.set_pjl_parm(printer)

        if filename is None:
            if printer is None:
                return None
            filename = self.get_filename(printer)
        filename = self.check_suffix(filename)
        if not os.path.isfile(filename):
            #print "(%s) isn't found." % filename
            return None

        if Lpy.def_parm.Parm_type == Lpy.def_parm.F_marshal:
            data = Lpy.utils.file_utils.load_parm_marshal(filename)
            if data is None:
                #print Lpy.utils.file_utils.get_error_msg()
                return None
        else:
            xmlparse = Lpy.utils.read_xml.Set_XML(filename)
            xdata = xmlparse.get_syntax(self.xml_top) # top document
            if xdata is None:
                #print xmlparse.get_error()
                return None
            data = self._set_dict(xdata[0])

        if not isinstance(data,types.DictType):
            message = _("The a2ps parameter (%s) isn't a dict_type.") % filename
            self.error_menu(message,filename)
            return None

        if printer:
            if data[self.T_printer][1] != printer:
                message = _("The (%s) is different (%s:%s).") % (filename,data[self.T_printer][1],self.printer)
                self.error_menu(message,filename)
                return None
        ## set PJL-data
        if not data[self.PJL.P_printer][0]:
            return self.OFF

        ret,PJL = self._check_load_data(data[self.PJL.P_printer][0],data,filename)
        if ret == Lpy.utils.file_utils.OK and PJL:
            self.printer = None
            self.set_pjl_parm(data[self.PJL.P_printer][0])
        else:
            return self.OFF

        keys = data.keys()
        keys.sort()
        clist = self.get_clist()
        for key in clist:
            if key in keys:
                if debug == 1:
                    print key,data[key]
                self.get_func(key).set_load_value(data[key])
        return self.ON

## a2ps:Save ##
    def save_a2ps_file(self,filename = None):
        if filename is None:
            filename = self.get_filename(self.printer)
        filename = self.check_suffix(filename)

        data = {}
        for key in self.PJL.get_clist():
            data[key] = self.PJL.get_func(key).get_save_value()
            if debug == 2:
                print key,data[key]

        for key in self.get_clist():
            data[key] = self.get_func(key).get_save_value()
            if debug == 2:
                print key,data[key]

        if Lpy.def_parm.Parm_type == Lpy.def_parm.F_marshal:
            ret = Lpy.utils.file_utils.save_parm_marshal(filename,data)
        else:
            xml_data = self.dict_to_xml(self.xml_top,data)
            ret = Lpy.utils.file_utils.write_tmpfile(filename,xml_data,"w")

        if ret != Lpy.utils.file_utils.OK:
            Lpy.utils.file_utils.remove_file(filename)
            message = _("I can't save a a2ps parameter (%s:%d).") % (filename,ret)
            self.error_menu(message,filename)
            return None
        return ret

## XML
    def dict_to_xml(self,title,data):
        xmldata = []
        keys = data.keys()
        keys.sort()
        xmldata.append(Lpy.utils.read_xml.set_xml_start(title) + os.linesep)

        for key in keys:
            if data[key] is None:
                xmldata.append(tabs + Lpy.utils.read_xml.set_xml_start(key) + "None"
                              + Lpy.utils.read_xml.set_xml_end(key) + os.linesep)
            else:
                xmldata.append( tabs + Lpy.utils.read_xml.set_xml_start(key) + os.linesep)
                for ii in range(len(data[key])):
                    val = "value%d" % ii
                    xmldata.append(tabs*2 + Lpy.utils.read_xml.set_xml_start(val)
                                    + str(data[key][ii])
                                    + Lpy.utils.read_xml.set_xml_end(val) + os.linesep)

                xmldata.append(tabs + Lpy.utils.read_xml.set_xml_end(key) + os.linesep)

        xmldata.append(Lpy.utils.read_xml.set_xml_end(title) + os.linesep)
        return xmldata

    def _set_dict(self,data):
        if len(data.child) == 0:
            return None

        def make_list(data):
            nlist = []
            ii = data.split(',')
            for i in ii:
               nlist.append(i.strip()[1:-1])
            return nlist

        def make_tuple(data):
            nlist = ()
            ii = data.split(',')
            for i in ii:
               if i:
                   nlist += (i.strip()[1:-1],)
            return nlist

        dicts = {}
        for key in data.child:
            if data.child[key] == 'None':
                dicts[key] = None
                continue
            dat = []
            for ii in range(len(data.child[key])):
                val = "value%d" % ii
                if data.child[key].has_key(val):
                    if data.child[key][val].startswith('['):
                        nlist = make_list(data.child[key][val][1:-1])
                        dat.append(nlist)

                    elif data.child[key][val].startswith('('):
                        nlist = make_tuple(data.child[key][val][1:-1])
                        dat.append(nlist)
                    else:
                        try:
                            vv = int(data.child[key][val])
                        except:
                            try:
                                vv = float(data.child[key][val])
                            except:
                                vv = data.child[key][val]
                        dat.append(vv)

            dicts[key] = dat

        if debug == 3:
            keys = dicts.keys()
            keys.sort()
            for key in keys:
                print key,dicts[key]
        return dicts
