#
#       hp_pjl.py
#
#       2003.11.6
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_class
import Lpy.pjl.pjl_printer
import Lpy.pjl.pjl_title

import hp_models

class Vendor_PrinterType(Lpy.pjl.pjl_printer.PrinterType,hp_models.HP_Model):
    def __init__(self,ptype = None,model = None):
        Lpy.pjl.pjl_printer.PrinterType.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_model(Lpy.pjl.pjl_printer.PrinterModel,hp_models.HP_Model):
    def __init__(self,ptype,model= None):
        Lpy.pjl.pjl_printer.PrinterModel.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.check_model(ptype,model)

    def check_model(self,ptype,model):
        self.value_list = self.get_printer_model(self.get_keyname(ptype))

        #print "PrinterModel",ptype,model , self.value_list
        if model and model in self.value_list:
            self.value = model
            self.tmpValue = self.value

        if not self.value in self.value_list:
            self.value = self.get_defaultPrinter(ptype)
            if self.value == None:
                self.value = self.value_list[0]

class Vendor_lang(Lpy.pjl.pjl_printer.PrinterLang,hp_models.HP_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.PrinterLang.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.check_model(ptype,model)
        self.value = self.value_list[0]

class Vendor_gs(Lpy.pjl.pjl_printer.GhostScript,hp_models.HP_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.GhostScript.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.support = self.ON
        self.value = 'ljet4'

class Vendor_PrinterPJL(Lpy.pjl.pjl_printer.PrinterPJL,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.PrinterPJL.__init__(self)
        hp_models.HP_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON
        self.tmp = self.ON
        self.value_list = self.get_langList(ptype,model,0)
#####
class Vendor_SNMP(Lpy.pjl.pjl_printer.SNMP,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.SNMP.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.vendorID = 11
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_IPP(Lpy.pjl.pjl_printer.IPP,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.IPP.__init__(self)
        hp_models.HP_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_Duplex(Lpy.pjl.pjl_printer.Duplex,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.Duplex.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.support = self.ON
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2100,
                         self.LJ3200MF,self.LJ3300MF):
            self.support = self.Never
        else:
            self.support = self.ON

#####
class Vendor_Copies(Lpy.pjl.pjl_class.Copies,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Copies.__init__(self)
        hp_models.HP_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON
        modelname = self.get_model_name(model)
        if modelname in (self.LJ2300,self.LJ4100MF,self.LJ4200,self.LJ4300,
                        self.LJ9000,self.LJ9000MF):
            self.max_val = 32000
        elif modelname in (self.CLJ2500,self.CLJ4600,self.CLJ5500):
            self.max_val = 32000
        else:
            self.max_val = 999

class Vendor_Orientation(Lpy.pjl.pjl_class.Orientation,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Orientation.__init__(self)
        hp_models.HP_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_resolv(Lpy.pjl.pjl_class.Resolution,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Resolution.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.support = self.ON
        self.set_vlist(['300','600','1200'],1)
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if self.get_color_model(modelname):
            self.set_vlist(['600',],0)
            self.support = self.Never
        else:
            self.support = self.ON
            if modelname in (self.LJ1300,self.LJ1200,self.LJ2200,self.LJ2100,self.LJ3200MF,self.LJ3300MF):
                self.set_vlist(['300','600','1200'],2)
            elif modelname in (self.LJ1100,self.LJ8000,self.LJ8100):
                self.set_vlist(['300','600'],1)
            else:
                self.set_vlist(['300','600','1200'],1)

class Vendor_smooth(Lpy.pjl.pjl_class.Smoothing,hp_models.HP_Model):
    def __init__(self): # RET command
        Lpy.pjl.pjl_class.Smoothing.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.support = self.ON

    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if self.get_color_model(modelname):
           self.support = self.Never
        else:
            self.support = self.ON
            if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2200,self.LJ3200MF,self.LJ3300MF):
                self.set_vlist(0,None) # on,off
                self.value = 0
            else:
                self.set_vlist(1,None) # medium
                self.value = 2

class Vendor_TonerSave(Lpy.pjl.pjl_class.TonerSave,hp_models.HP_Model):
    def __init__(self): # ecomode 
        Lpy.pjl.pjl_class.TonerSave.__init__(self)
        hp_models.HP_Model.__init__(self)
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if self.get_color_model(modelname):
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_density(Lpy.pjl.pjl_class.Density,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Density.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.max_val = 5
        self.value = 3
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if self.get_color_model(modelname):
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_mediatype(Lpy.pjl.pjl_class.MediaType,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.MediaType.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'MEDIATYPE'
        self.support = self.ON
        self.hp_media(self.typeMedia)
        self.set_selectDict()

    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        support = None
        extra_flag = 0

        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2100,self.LJ2200):
            self.support = self.Never
        elif modelname == self.LJ2300:
            support = (self.M_default,self.M_auto,self.M_Paper,self.M_Color,
                self.M_Bond,self.M_LetterHead,self.M_Recycled,self.M_PrePrinted,
                self.M_PrePunched,self.M_Rough,self.M_CardStock,self.M_Envelope,
                self.M_Labels,self.M_Transparency)
        
        elif modelname in (self.LJ4100,self.LJ4100MF):
            self.support = self.Never
        elif modelname in (self.LJ4200,self.LJ4300):
            support = (self.M_default,self.M_Paper,self.M_Color,
                self.M_Bond,self.M_LetterHead,self.M_Recycled,self.M_PrePrinted,
                self.M_PrePunched,self.M_Rough,self.M_CardStock,self.M_Labels,self.M_Transparency,
                self.M_UserType1,self.M_UserType2,self.M_UserType3,self.M_UserType4,self.M_UserType5)

        elif modelname in (self.LJ5000,self.LJ5100,self.LJ8000,self.LJ8100,
                           self.LJ8150,self.LJ9000,self.LJ9000MF):
            self.support = self.Never
        elif modelname in (self.LJ3200MF,self.LJ3300MF):
            self.support = self.Never

        # color
        elif modelname in (self.CLJ2500,self.CLJ4500,self.CLJ4550,self.CLJ4600):
            self.support = self.Never
            
        elif modelname == self.CLJ5500:
            support = (self.M_default,self.M_Paper,self.M_Color,
                self.M_Bond,self.M_LetterHead,self.M_Recycled,self.M_PrePrinted,
                self.M_Light,self.M_Heavy,self.M_Glossy,self.M_HeavyGlossy,self.M_ToughPaper,
                self.M_PrePunched,self.M_CardStock,self.M_Labels,self.M_Transparency,self.M_Envelope,
                self.M_UserType1,self.M_UserType2,self.M_UserType3,self.M_UserType4,self.M_UserType5)
        elif modelname in (self.CLJ8500,self.CLJ8550,self.CLJ8550MF): 
            support = (self.M_Paper,self.M_Color,self.M_Bond,self.M_LetterHead,
                self.M_Recycled,self.M_PrePrinted,self.M_Heavy,self.M_Glossy,self.M_Envelope,
                self.M_PrePunched,self.M_CardStock,self.M_Labels,self.M_Transparency)
            extra_flag = 1
  
        if support:
            self.support = self.ON
            self.hp_media(self.typeMedia)
            self.set_selectDict(support)
            if extra_flag == 1:
                self.select_dict[self.M_Paper][2] = "PAPER"

class Vendor_paperSize(Lpy.pjl.pjl_class.PaperSize,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.PaperSize.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'PAPER'
        self.value_list = Lpy.paper_size.pjl_papers
        self.set_value(0)

    def check_model(self,ptype,model):
        self.support = self.ON
        self.value_list = Lpy.paper_size.pjl_papers
        modelname = self.get_model_name(model)
        no_supp = None
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ2200):
            no_supp = ('A3','JISB4',"JISEXEC","LEDGER","ROC8K","EIGHTPOINT5X13")
        elif modelname == self.LJ1100:
            no_supp = ('A3','JISB4',"JISB5","A5","JPOST","JPOSTD","LEDGER","ISOB5",
                        "ROC8K","ROC16K","JISEXEC",'FOOLSCAP',"EIGHTPOINT5X13","CUSTOM")
        elif modelname == self.LJ2100:
            no_supp = ('A3','JISB4',"LEDGER","ROC8K","ROC16K","JISEXEC",
                        "ISOB5",'FOOLSCAP',"EIGHTPOINT5X13")

        elif modelname == self.LJ2300:
            no_supp = ('A3','JISB4',"JPOST","LEDGER","ROC8K",'FOOLSCAP')
        elif modelname in (self.LJ4100,self.LJ4100MF):
            no_supp = ['JISB4',"JPOST","LEDGER","ROC8K","EIGHTPOINT5X13",'FOOLSCAP']
            if modelname == self.LJ4100:
                no_supp.append("JPOSTD")
        elif modelname in (self.LJ4200,self.LJ4300):
            no_supp = ('A3','A4','JISB4',"JPOST","LEDGER","ROC8k","EIGHTPOINT5X13",'FOOLSCAP')
        elif modelname == self.LJ5000:
            no_supp = ('A3','JISB4',"LEDGER","ROC8K","ROC16K","JISEXEC","JPOST","JPOSTD",
                        "ISOB5",'FOOLSCAP',"EIGHTPOINT5X13")

        elif modelname == self.LJ5100:
            no_supp = ("EIGHTPOINT5X13",'FOOLSCAP','ISOB5',"JISEXEC","ROC8k","ROC16K")
            add_supp = ('A4ROTATED','A5ROTATED','EXECTIVEROTATED','LETTERROTATED','A6','JISB6')
            for key in add_supp:
                self.value_list.append(key)

        elif modelname == self.LJ8000:
            no_supp = ("JPOST","ROC8K","ROC16K","JISEXEC","ISOB5",'FOOLSCAP',"EIGHTPOINT5X13")
        elif modelname == self.LJ8100:
            no_supp = ("JPOST","ISOB5",'FOOLSCAP',"EIGHTPOINT5X13")

        elif modelname == self.LJ8150:
            no_supp = ("EIGHTPOINT5X13",'FOOLSCAP','ISOB5',"JISEXEC","JPOST")
            self.value_list.append('11x17')
        elif modelname in (self.LJ9000,self.LJ9000MF):
            no_supp = ('FOOLSCAP',"JPOST")
        elif modelname in (self.LJ3200MF,self.LJ3300MF):
            no_supp = ('A3','JISB4',"JISEXEC","LEDGER","ROC8k","EIGHTPOINT5X13")

        # color
        elif modelname == self.CLJ2500:
            no_supp = ('A3','JISB4',"LEDGER","ROC8k","EIGHTPOINT5X13",'FOOLSCAP')
        elif modelname == self.CLJ4500:
            no_supp = ('A3','JISB4',"LEDGER","JPOST","JPOSTD",
                        "ROC8K","ROC16K","JISEXEC","ISOB5",'FOOLSCAP',"EIGHTPOINT5X13")
        elif modelname == self.CLJ4550:
            no_supp = ('JISB4',"JPOST","JPOSTD","LEDGER","ROC8k","EIGHTPOINT5X13",'FOOLSCAP')
        elif modelname == self.CLJ4600:
            no_supp = ('A3','ISOB5','JISB4',"JPOST","LEDGER","ROC8k","EIGHTPOINT5X13",'FOOLSCAP')
        elif modelname == self.CLJ5500:
            no_supp = ("JPOST","EIGHTPOINT5X13",'FOOLSCAP')
        elif modelname == self.CLJ8500:
            no_supp = ("JPOST","ROC8K","ROC16K","JISEXEC","ISOB5",'FOOLSCAP',"EIGHTPOINT5X13")
        elif modelname in (self.CLJ8550,self.CLJ8550MF):
            no_supp = ('ISOB5',"JPOST","EIGHTPOINT5X13",'FOOLSCAP')

        if no_supp:
            for key in no_supp:
                if key in self.value_list:
                    self.value_list.remove(key)
 
class Vendor_intray(Lpy.pjl.pjl_class.InputTray,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.InputTray.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'MEDIASOURCE'
        self.max_val = 6
        self.roll_max = 1
        self.externalTray_max = 32
        self.oldCmd  = self.OFF
        self.support = self.ON
        self.init_trayList('hp')
        self.set_selectDict()

    def set_mpTray(self):
        for key in self.TrayList:
            self.select_dict[key][0] = self.Never
        self.oldCmd = self.ON
        self.max_val = 1
        self.select_dict[self.TR_tray][3]   = 1
        self.select_dict[self.TR_tray][0]   = self.ON
        self.select_dict[self.TR_MPtray][0] = self.ON
        self.select_dict[self.TR_manual][0] = self.ON

    def set_manualTray(self):
        for key in self.TrayList:
            self.select_dict[key][0] = self.Never
        self.oldCmd = self.ON
        self.max_val = 1
        self.select_dict[self.TR_tray][3]   = 1
        self.select_dict[self.TR_tray][0]   = self.ON
        self.select_dict[self.TR_manual][0] = self.ON

    def check_model(self,ptype,model):  
        self.init_trayList()
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100):
            self.set_manualTray()
        elif modelname in (self.LJ2100,self.LJ2200):
            self.set_mpTray()
        elif modelname == self.LJ2300:
            self.max_val = 3
            self.select_dict[self.TR_tray][3] = 3
            self.select_dict[self.TR_envelope][0] = self.Never
            self.select_dict[self.TR_external][0] = self.Never
        elif modelname in (self.LJ4100,self.LJ4100MF):
            self.set_mpTray()
        elif modelname in (self.LJ4200,self.LJ4300):
            self.max_val = 4
            self.externalTray_max = 1
            self.select_dict[self.TR_tray][3] = self.max_val
            self.select_dict[self.TR_duplex][0] = self.Never
            self.select_dict[self.TR_external][3] = self.externalTray_max
        elif modelname in (self.LJ5000,self.LJ5100,self.LJ8000,self.LJ8100,
                            self.LJ8150,self.LJ9000,self.LJ9000MF):
            self.set_mpTray()
        elif modelname in (self.LJ3200MF,self.LJ3300MF):
            self.set_manualTray()

        # color
        elif modelname in (self.CLJ4550,self.CLJ8500):
            self.set_mpTray()
        elif modelname in (self.CLJ2500,self.CLJ4500,self.CLJ4600):
            self.set_manualTray()
        elif modelname == self.CLJ5500:
            self.max_val = 4
            self.select_dict[self.TR_tray][3] = self.max_val
            self.select_dict[self.TR_duplex][0] = self.Never
            self.select_dict[self.TR_external][0] = self.Never
        elif modelname in (self.CLJ8550,self.CLJ8550MF):
            self.set_mpTray()
        self.set_selectDict()

class Vendor_outtray(Lpy.pjl.pjl_class.OutTray,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.OutTray.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.max_val = 2
        self.list_num = 1
        self.select_lists = '1-%d-1-1-0-0' % (self.max_val)
        self.pjl_cmd    = 'OUTBIN'
        self.pjl_lists  = ("UPPER","LOWER")    
        self.value_list = (Lpy.pjl.pjl_title.u_facedown,Lpy.pjl.pjl_title.u_faceup)
        self.support = self.ON

    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2100,
                         self.LJ2200,self.LJ2300,self.LJ5000,self.LJ5100,self.LJ3200MF,self.LJ3300MF):
            self.support = self.Never
        elif modelname in (self.CLJ2500,self.CLJ4500,self.CLJ4550,self.CLJ4600,self.CLJ5500):
            self.support = self.Never
        else:
            self.support = self.ON
            self.value  = 0

class Vendor_mailbin(Lpy.pjl.pjl_class.MailBin,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.MailBin.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.support = self.OFF
        self.pjl_cmd = 'OUTBIN=OPTIONALOUTPUTBIN' # 1-62
        self.max_val = 1
        self.select_lists = '1-%d-1-4-0-0' % self.max_val
        self.value_list = '1-%d-1-4-0-0' % (self.max_val)
        self.set_value(0)

    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        self.max_val = 0
        self.support = self.OFF
        if modelname in (self.LJ8150,self.LJ8100,self.LJ8000):
            self.max_val = 16
        elif modelname in (self.LJ9000,self.LJ9000MF):
            self.max_val = 2
        elif modelname in (self.LJ4100,self.LJ4100MF,self.LJ4200,self.LJ4300):
            self.max_val = 1
        elif modelname in (self.CLJ8500,self.CLJ8550,self.CLJ8550MF):
            self.max_val = 9

        if self.max_val >= 1:
            self.select_lists = '1-%d-1-4-0-0' % self.max_val
            self.value_list   = '1-%d-1-4-0-0' % self.max_val
            self.set_value(0)
        else:
            self.support = self.Never
        
    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        if self.value >=1 and self.value <= self.max_val:
            return "%s%d" % (self.pjl_cmd,self.value)
        else:
            return None

## finisher,MailBin
class Vendor_ProcessingType(Lpy.pjl.pjl_class.Unique,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Unique.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'PROCESSINGTYPE'
        self.max_val = 80 # char
        self.valueType = self.charType
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ2300,self.LJ4100MF,self.LJ4200,self.LJ4300):
            self.support = self.ON
        elif modelname in (self.LJ9000,self.LJ9000MF):
            self.support = self.ON
        elif modelname in (self.CLJ2500,self.CLJ4600):
            self.support = self.ON
        elif modelname in (self.CLJ5500):
            self.support = self.ON
        else:
            self.support = self.Never
class Vendor_ProcessingOption(Lpy.pjl.pjl_class.Unique,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Unique.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'PROCESSINGOPTION'
        self.max_val = 16 # char
        self.valueType = self.charType
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ2300,self.LJ4100MF,self.LJ4200,self.LJ4300):
            self.support = self.ON
        elif modelname in (self.LJ9000,self.LJ9000MF):
            self.support = self.ON
        elif modelname in (self.CLJ2500,self.CLJ4600):
            self.support = self.ON
        elif modelname in (self.CLJ5500):
            self.support = self.ON
        else:
            self.support = self.Never
class Vendor_FinisherType(Lpy.pjl.pjl_class.Unique,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Unique.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'FINISHERTYPE'
        self.support = self.Never
        self.value = 0
        self.valueType = self.intType 
        self.min_val = 0
        self.max_val = 255
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ2300,self.LJ4100,self.LJ4100MF,self.LJ4200,self.LJ4300):
            self.support = self.ON
        elif modelname in (self.LJ5100,self.LJ9000,self.LJ9000MF):
            self.support = self.ON
        elif modelname in (self.CLJ2500,self.CLJ4550,self.CLJ4600):
            self.support = self.ON
        elif modelname in (self.CLJ5500,self.CLJ8550,self.CLJ8550MF):
            self.support = self.ON
        else:
            self.support = self.Never
class Vendor_FinisherOption(Lpy.pjl.pjl_class.Unique,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Unique.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'FINISHEROPTION'
        self.support = self.Never
        self.valueType = self.intType 
        self.value = 0
        self.min_val = 0
        self.max_val = 255
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ2300,self.LJ4100,self.LJ4100MF,self.LJ4200,self.LJ4300):
            self.support = self.ON
        elif modelname in (self.LJ5100,self.LJ9000,self.LJ9000MF):
            self.support = self.ON
        elif modelname in (self.CLJ2500,self.CLJ4550,self.CLJ4600):
            self.support = self.ON
        elif modelname in (self.CLJ5500,self.CLJ8550,self.CLJ8550MF):
            self.support = self.ON
        else:
            self.support = self.Never
class Vendor_OutbinProcess(Lpy.pjl.pjl_class.Unique,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Unique.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'OUTBINPROCESS'
        self.support = self.Never
        self.valueType = self.intType 
        self.value = 0
        self.min_val = 0
        self.max_val = 255
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ2300,self.LJ4100,self.LJ4100MF,self.LJ4200,self.LJ4300):
            self.support = self.ON
        elif modelname in (self.LJ5100,self.LJ8000,self.LJ8100,self.LJ8150,self.LJ9000,self.LJ9000MF):
            self.support = self.ON
        elif modelname in (self.CLJ2500,self.CLJ4550,self.CLJ4600):
            self.support = self.ON
        elif modelname in (self.CLJ5500,self.CLJ8550,self.CLJ8550MF):
            self.support = self.ON
        else:
            self.support = self.Never

# Staple
class Vendor_staple(Lpy.pjl.pjl_class.Staple,hp_models.HP_Model):
    s_options = ("NONE","DEFAULT","ONE","TWO","THREE","FOUR","FIVE","SIX","SEVEN",
        "ONEANGLED","ONEOPPOSED","OPTINS3","OPTINS4","OPTINS5","OPTINS6","CUSTOM")
    u_options = (Lpy.pjl.pjl_title.u_none,Lpy.pjl.pjl_title.u_default,Lpy.pjl.pjl_title.u_staple1,
        Lpy.pjl.pjl_title.u_staple2,Lpy.pjl.pjl_title.u_staple3,Lpy.pjl.pjl_title.u_staple4,
        Lpy.pjl.pjl_title.u_staple5,Lpy.pjl.pjl_title.u_staple6,Lpy.pjl.pjl_title.u_staple7,
        Lpy.pjl.pjl_title.u_staple_angle1,Lpy.pjl.pjl_title.u_staple_oppose1,Lpy.pjl.pjl_title.u_staple_opt3,
        Lpy.pjl.pjl_title.u_staple_opt4,Lpy.pjl.pjl_title.u_staple_opt5,
        Lpy.pjl.pjl_title.u_staple_opt6,Lpy.pjl.pjl_title.u_staple_custom)

    def __init__(self):
        Lpy.pjl.pjl_class.Staple.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'FINISH'
        self.pjl_lists = ("NONE","STAPLE")
        self.support = self.OFF

    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2100,
                        self.LJ2200,self.LJ5000,self.LJ3200MF,self.LJ3300MF):
            self.support = self.Never
        elif modelname in (self.CLJ4500,self.CLJ8500):
            self.support = self.Never
        else:
            self.support = self.OFF
            if modelname in (self.LJ8000,self.LJ8100,self.LJ8150):
                self.pjl_options = None
                self.value_list = (Lpy.pjl.pjl_title.u_none,Lpy.pjl.pjl_title.u_staple1)
            else:
                self.pjl_options = self.s_options
                self.value_list  = self.u_options

    def get_pjlparm(self):
        if self.support != self.ON:
            return None

        if self.value == 0:
            return "FINISH=NONE"
        else:
            return "STAPLEOPTION=STAPLE" 

    def get_pjlparm2(self):
        if self.value >= 1 and self.pjl_options:
            return "STAPLEOPTION=%s"  % self.pjl_options[self.value]
        else:
            return None

class Vendor_binding(Lpy.pjl.pjl_class.Binding,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Binding.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_lists = ("LONGEDGE","SHORTEDGE")
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2100,
                         self.LJ8000,self.LJ8100,self.LJ3200MF,self.LJ3300MF):
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_Collation(Lpy.pjl.pjl_class.Collation,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Collation.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.support = self.ON
        self.pjl_cmd  = 'QTY'
        self.value = 0
        self.min_val = 0
        self.max_val = 999
        self.value_list = '1-%d-1-4-0-0' % self.max_val
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1100,self.LJ2100):
            self.support = self.Never
        elif modelname == self.CLJ4500:
            self.support = self.Never
        else:
            self.support = self.ON
            if modelname in (self.LJ2300,self.LJ4100MF,self.LJ4200,self.LJ4300,
                             self.LJ9000,self.LJ9000MF):
                self.max_val = 32000
                self.min_val = 1
            elif modelname in (self.CLJ2500,self.CLJ4600,self.CLJ5500):
                self.max_val = 32000
                self.min_val = 1
            else:
                self.max_val = 999
                self.min_val = 0
            self.value_list = '%d-%d-1-10-0-0' % (self.min_val,self.max_val)

class Vendor_mirror(Lpy.pjl.pjl_class.Mirror,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Mirror.__init__(self)
        hp_models.HP_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.Never

class Vendor_quality(Lpy.pjl.pjl_class.Quality,hp_models.HP_Model): 
    def __init__(self):
        Lpy.pjl.pjl_class.Quality.__init__(self)
        hp_models.HP_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.Never
##
# Hold
class Vendor_Hold(Lpy.pjl.pjl_class.HoldData,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.HoldData.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'HOLD'
        self.pjl_lists  = ("OFF","ON","PROOF","STORE")
        self.value_list = (Lpy.pjl.pjl_title.u_off,Lpy.pjl.pjl_title.u_on,
                           Lpy.pjl.pjl_title.u_proof,Lpy.pjl.pjl_title.u_store)
        self.set_value(0)
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2100,self.LJ2200,
                        self.LJ8000,self.LJ3200MF,self.LJ3300MF):
            self.support = self.Never
        elif modelname in (self.CLJ4500,self.CLJ8500):
            self.support = self.Never
        else:
            self.support = self.OFF
            self.set_value(0)

class Vendor_HoldKey(Lpy.pjl.pjl_class.HoldKey,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.HoldKey.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd  = 'HOLDKEY'
        self.support = self.ON
        self.value = 0
        self.max_val = 9999
        self.valueType = self.intType 
        self.value_list = '0-%d-1-10-4-1' % (self.max_val)
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        self.support = self.ON
        if modelname in (self.LJ8000,self.LJ8100):
            # 0000,9999
            self.valueType = self.intType 
            self.value = 0
        else:
            #self.valueType = self.charType
            self.value = 0 # "" # length 4
                
class Vendor_HoldType(Lpy.pjl.pjl_class.HoldType,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.HoldType.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd  = 'HOOLTYPE'
        self.pjl_lists = ("PUBLIC","PRIVATE")
        self.value_list = (Lpy.pjl.pjl_title.u_public,Lpy.pjl.pjl_title.u_private)
        self.support = self.ON
        self.set_value(0)
    def check_model(self,ptype,model):
        pass # modelname = self.get_model_name(model)
 
class Vendor_UserName(Lpy.pjl.pjl_class.UserName,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.UserName.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd = 'USERNAME'
        self.max_val = 80
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2100,self.LJ2200,
                        self.LJ8000,self.LJ3200MF,self.LJ3300MF):
            self.support = self.Never
        elif modelname in (self.CLJ4500):
            self.support = self.Never
        else:
            self.support = self.ON
# DISKLock
class Vendor_DiskLock(Lpy.pjl.pjl_class.DiskLock,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.DiskLock.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd  = 'DISKLOCK'
        self.pjl_lists = self.ON_OFF 
        self.value_list = self.ON_OFF
        self.set_value(0)
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2100,self.LJ2200):
            self.support = self.Never
        elif modelname == self.CLJ4500:
            self.support = self.Never
        else:
            self.support = self.OFF

## Panel Lock
class Vendor_PanelLock(Lpy.pjl.pjl_class.PanelLock,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.PanelLock.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd  = 'CPLOCK'
        self.pjl_lists = ('OFF','ON','MINIMUM','MODERATE','MAXMUM')
        self.value_list = (Lpy.pjl.pjl_title.u_off,Lpy.pjl.pjl_title.u_on,
            Lpy.pjl.pjl_title.u_minimum,Lpy.pjl.pjl_title.u_moderate,Lpy.pjl.pjl_title.u_maxmum)

        self.set_value(0)
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname in (self.LJ1300,self.LJ1200,self.LJ1150,self.LJ1100,self.LJ2100,self.LJ2200):
            self.support = self.Never
        else:
            self.support = self.OFF
 
class Vendor_PanelPassword(Lpy.pjl.pjl_class.PanelPassword,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.PanelPassword.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd  = 'PASSWORD'
        self.max_val = 65535
        self.value = 0
    def check_model(self,ptype,model):
        self.support = self.OFF

 
## Color Printer
class Vendor_colorPrinter(Lpy.pjl.pjl_class.ColorPrinter,hp_models.HP_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.ColorPrinter.__init__(self)
        hp_models.HP_Model.__init__(self)
        self.pjl_cmd  = 'RENDERMODE'
        self.pjl_lists = ("GRAYSCALE","COLOR")
    def check_model(self,ptype,model):
        modelname = self.get_model_name(model)
        if modelname == self.CLJ8500:
            self.support = self.ON
        else:
            self.support = self.Never


