#
#       set_snmp_data.py
#
#       2004.7.9
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################################
import gtk
import os

import Lpy.printer_model
import Lpy.pjl.pjl_title
import Lpy.snmp.snmp_get
import Lpy.snmp.print_mib
import dialog_menu

class Set_SNMP_Data:
    import Lpy.pjl.pjl_title 
    sub_title = (Lpy.pjl.pjl_title.u_netManagement,
                 Lpy.pjl.pjl_title.u_snmp_check,
                 Lpy.pjl.pjl_title.u_option_instrument)

    ## start SNMP check
    def snmp_check(self,button):
        if self.SNMP.get_tmp() == self.S.OFF:
            Lpy.snmp.snmp_get.print_snmp_error(4)
            return None

        GetSNMP = Lpy.snmp.snmp_get.Get_SNMP(self.host,self.community,self.port)
        ret = GetSNMP.check_snmp_ports()
        if ret is None:
            return None

        self.set_tmp_value()
        ret = GetSNMP.get_snmp_printer()
        if ret is None:
            return None

        data = GetSNMP.SNMP_Data.get_dialog_data()
        if data is None or len(data) < 1:
            return None

        enterprise_dat = GetSNMP.SNMP_Data.get_options_data() 
 
        # Private MIB
        #vendorID = GetSNMP.SNMP_Data.get_enterpriseCode()
        #if vendorID:
        #    E_data = GetSNMP.get_enterprise_mib(vendorID)
        #    if E_data:
        #        enterprise = self.PJL.enterprise_support(E_data,GetSNMP.SNMP_Data.productname)
        #        if enterprise and enterprise_dat:
        #            enterprise_dat.update(enterprise)
 
        if enterprise_dat:
            response = dialog_menu.message_dialog(self.sub_title[1],data,"SetButton")
            if response == gtk.RESPONSE_APPLY:
                data = self.set_snmp_data(1,enterprise_dat)
                if data:
                    response = dialog_menu.message_lists(self.sub_title[2],[(self.sub_title[2],data)],"SetButton")
                    if response == gtk.RESPONSE_APPLY:
                        self.set_snmp_data(2,enterprise_dat)
        else:
            response = dialog_menu.message_dialog(self.sub_title[1],data)

    ## Set SNMP-data to parameter
    def set_snmp_data(self,flag,dat):
        if flag != 2:
            data = []

        if dat[Lpy.printer_model.o_printer][1]:
            if flag == 2:
                self.S.set_printertype(dat[Lpy.printer_model.o_printer][1])
            else:
                pname = self.SNMP.get_typename(dat[Lpy.printer_model.o_printer][1])
                if pname:
                    data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_printer,pname))
  
        if dat[Lpy.printer_model.o_color][0]:
            if flag == 2:
                self.S.set_colorPrinter(dat[Lpy.printer_model.o_color][1])
            else:
                data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_colorPrinter,dat[Lpy.printer_model.o_color][0]))

        if dat[Lpy.printer_model.o_lang][1]: # PJL
            if flag == 2:
                self.S.set_langPJL(dat[Lpy.printer_model.o_lang][1],dat[Lpy.printer_model.o_lang][0])
            else:
                data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_lang,dat[Lpy.printer_model.o_lang][1])) 

        if dat[Lpy.printer_model.o_duplex][1]:
            if flag == 2:
                self.S.set_duplex(dat[Lpy.printer_model.o_duplex][1])
            else:
                data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_duplex,dat[Lpy.printer_model.o_duplex][1]))

        if dat[Lpy.printer_model.o_intray][1]:
            inTray, mpTray, Manual, Roll, FanFold = dat[Lpy.printer_model.o_intray][1]
            if flag == 2:
                self.S.SetP.Tray.set_input_tray(inTray,mpTray,Manual,Roll,FanFold)
            else:
                data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_intray,inTray))
                if mpTray:
                    data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_mptray,self.S.ON))
                if Manual:
                    data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_manual,self.S.ON))
                if Roll:
                    data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_roll,Roll))
                if FanFold:
                    data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_fanfold,self.S.ON))

        if dat[Lpy.printer_model.o_outtray][1]:
            outTray, Tray, Roll,FanFold = dat[Lpy.printer_model.o_outtray][1]
            if flag == 2:
                self.S.SetP.Tray.set_output_tray(outTray,Tray,Roll,FanFold)
            else:
                data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_outtray,outTray))
                if Tray:
                    data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_unRemoveTray,self.S.ON))
                if Roll:
                    data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_roll,Roll))
                if FanFold:
                    data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_fanfold,self.S.ON))

        if dat[Lpy.printer_model.o_first2last][1]:
            firstToLast, lastToFirst = dat[Lpy.printer_model.o_first2last][1]
            if flag == 2:
                self.S.SetP.Tray.set_firstToLast(firstToLast,lastToFirst)
            else:
               data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_first,firstToLast))
               data.append( Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_last,lastToFirst))

        if dat[Lpy.printer_model.o_faceup][1]:
            faceUp, faceDown = dat[Lpy.printer_model.o_faceup][1]
            if flag == 2:
                self.S.SetP.Tray.set_faceup(faceUp,faceDown)
            else:
               data.append(Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_faceup,faceUp))
               data.append(Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_facedown,faceDown))

        if dat.has_key(Lpy.printer_model.o_mailbin) and dat[Lpy.printer_model.o_mailbin][1]:
            if flag == 2:
                self.S.SetP.Tray.set_output_tray.set_output_mailbin(dat[Lpy.printer_model.o_mailbin][0])
            else:
                data.append(Lpy.snmp.print_mib.set_text_text(Lpy.pjl.pjl_title.u_mailbin,dat[Lpy.printer_model.o_mailbin][0]))

    ## Private MIB data
        if dat.has_key(Lpy.printer_model.o_finisher) and dat[Lpy.printer_model.o_finisher][0]:
            if flag == 2:
                pass 
            else:
                pass

        if dat.has_key(Lpy.printer_model.o_papersize) and dat[Lpy.printer_model.o_papersize][0]:
            #print "papersize" , dat[Lpy.printer_model.o_papersize][0]

            if flag == 2:
                pass 
            else:
                pass 

        if dat.has_key(Lpy.printer_model.o_media) and dat[Lpy.printer_model.o_media][0]:
            if flag == 2:
                pass 
            else:
                pass 

        if flag == 2:
            self.S.change_menu()
        else:
            if len(data) >= 2:
               return data
            return None
