#
#       pjl_output.py
#
#       2003.11.4
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
# CR  = "\r"   # 0x0d
# LF  = "\n"   # 0x0a

class PJLout:
    PJL_CRLF     = "\r\n"
    PJL_header   = '\033%-12345X@PJL' + PJL_CRLF
    PJL_setParam = '@PJL SET'
    PJL_Comment  = '@PJL COMMENT'
    PJL_head_end = '@PJL ENTER LANGUAGE'
    PJL_tail     = "\033%-12345X"

    def __init__(self):
        pass

    def get_pjl_header(self,jobname):
        data = []
        data.append(self.PJL_header)
        if jobname:
            data.append('@PJL JOB NAME ="%s"%s' % (jobname,self.PJL_CRLF))
        # username
        if self.get_func(self.P_userName).get_support() == self.ON:
            username = self.get_func(self.P_userName).get_value()
            if username:
                data.append("%s USERNAME = %s%s" % (self.PJL_setParam,username,self.PJL_CRLF))
        # collation
        if self.get_func(self.P_collate).get_support() == self.ON:
            qty = self.get_func(self.P_collate).get_value()
            if qty >= 1:
                data.append("%s QTY = %d%s" % (self.PJL_setParam,qty,self.PJL_CRLF))

        dat = self._pjl_hold()
        if dat:
            data.append(dat)
        else:
            dat = self._pjl_panelLock()
            if dat:
                data.append(dat)
            else:
                if self.get_func(self.P_diskLock).get_support() == self.ON:
                    disklock = self.get_func(self.P_diskLock).get_pjlparm()
                    if disklock:
                        data.append("@PJL DEFAULT %s%s" % (disklock,self.PJL_CRLF))

        dat = self._set_mpTray()
        if dat:
            data.append(dat)
        return data

    def _pjl_hold(self):
        if self.get_func(self.P_hold).get_support() != self.ON:
            return None

        hold = self.get_func(self.P_hold).get_pjlparm()
        if hold.endswith(self.OFF):
            return None
 
        holdtype = holdkey = None
        if self.get_func(self.P_holdType).get_support() == self.ON:
            holdtype = self.get_func(self.P_holdType).get_pjlparm()
            
        if self.get_func(self.P_holdKey).get_support() == self.ON:
            holdkey = self.get_func(self.P_holdKey).get_pjlparm()

        data = []
        data.append("%s %s%s" % (self.PJL_setParam,hold,self.PJL_CRLF))
        if holdtype:
            data.append("%s %s%s" % (self.PJL_setParam,holdtype,self.PJL_CRLF))
        if holdkey:
            data.append("%s %s%s" % (self.PJL_setParam,holdkey,self.PJL_CRLF))

        return data

    def _pjl_panelLock(self):
        if self.get_func(self.P_panelLock).get_support() != self.ON:
            return None
        if self.get_func(self.P_panelLock).get_value() != 1:
            return None

        old_pw = self.get_func(self.P_panelPass).get_old_pw()
        lpw = self.get_func(self.P_panelPass).get_value()
        if lpw is None or lpw <= 0 or lpw > self.get_func(self.P_panelPass).get_maxval():
            return None
        data = []
        if old_pw:
            data.append("@PJL JOB PASSWORD = %s%s" % (old_pw,self.PJL_CRLF))
            # self.get_func(self.P_panelPass).set_old_pw()
        data.append("@PJL DEFAULT PASSWORD = %s%s" % (lpw,self.PJL_CRLF))
        data.append("@PJL DINQUIRE PASSWORD" + self.PJL_CRLF)
        data.append("@PJL DEFAULT CPLOCK = ON" + self.PJL_CRLF)
        data.append("@PJL DINQUIRE CPLOCK" + self.PJL_CRLF)
        return data

    ## MPtray ##
    def _set_mpTray(self):
        if self.get_func(self.P_intray).get_cmdType() != self.ON:
            return None
        if self.get_func(self.P_intray).get_tray_support("MPTRAY") != self.ON:
            return None

        value = self.pjl_output_value(self.P_intray)
        data = []
        if value and value.find("MPTRAY") > 1:
                mptray = "FIRST"
        else:
                mptray = "CASSETTE" # "MANUAL"
        data.append("@PJL DEFAULT MPTRAY = %s%s" % (mptray, self.PJL_CRLF))
        return  data
 
    def get_pjl_head_end(self,lang):
        return "%s=%s%s" % (self.PJL_head_end,lang,self.PJL_CRLF)

    def get_pjl_tail(self,name):
        data = []
        data.append('@PJL EOJ NAME ="%s"%s' % (name,self.PJL_CRLF))
        if self.pjl_Reset == self.ON:
            data.append('@PJL RESET' + self.PJL_CRLF)
        data.append(self.PJL_tail)
        return  data

    def pjl_output_value(self,keymame):
        value = self.get_func(keymame).get_pjlparm()
        if value:
            data = "%s %s%s" % (self.PJL_setParam,value,self.PJL_CRLF)
            val2 = self.get_func(keymame).get_pjlparm2()
            if val2:
               data += "%s %s%s" % (self.PJL_setParam,val2,self.PJL_CRLF)
            return data
        return None

    def pjl_output_common(self):
        data = []
        for name in self.clist:
            if self.get_func(name).check_unique() == self.ON: # self.unique
                continue
            value = self.pjl_output_value(name)
            if value:
               data.append(value)
        return data

    def pjl_output_inputTray(self):
        data = [] 
        if self.get_func(self.P_intray).get_support() == self.ON:
            value = self.pjl_output_value(self.P_intray)
            if value:
                if self.get_func(self.P_intray).get_cmdType() == self.ON:
                    if value and value.find("MANUALFEED") > 1:
                        data.append("%s MANUALFEED = ON%s" % (self.PJL_setParam,self.PJL_CRLF))
                else:
                    data.append(value)

        if self.get_func(self.P_mediaSize).get_support() == self.ON:
            value = self.pjl_output_value(self.P_mediaSize)
            if value:
               data.append(value)

        if self.get_func(self.P_mediatype).get_support() == self.ON:
            value = self.pjl_output_value(self.P_mediatype)
            if value:
               data.append(value)
 
        if not data:
            return data
        return None

    def pjl_output_MailBin(self):
        if self.get_func(self.P_ProcessingType).get_support() != self.ON:
            return None
        if self.get_func(self.P_ProcessingOption).get_support() != self.ON:
            return None

        data = []
        #cmds = self.get_func(self.P_ProcessingType).get_pjlparm()
        #if cmds:
        #   val = "FACE_UP","FACE_DOWN","STAPLING"
        #   data.append("%s %s = %s%s" % (self.PJL_setParam,cmds,val,self.PJL_CRLF))

        #if not data:
        #    return data
        return None

    #P_OutbinProcess 
    #P_FinisherType  
    #P_FinisherOption  

    def pjl_output_outputTray(self):
        data = []
        ## output Tray
        if (self.get_func(self.P_mailbin).get_support() == self.ON and 
            self.PJL.get_func(self.PJL.P_mailbin).get_value() >= 1):
            value = self.pjl_output_value(self.P_mailbin)
            if value:
               data.append(value)
 
        else:
            if self.get_func(self.P_outtray).get_support() == self.ON:
                value = self.pjl_output_value(self.P_outtray)
                if value:
                    data.append(value)

        ## Staple
        staple  = 0
        booklet = 0
        value = self.pjl_output_value(self.P_staple)
        if value:
            data.append(value)
            
            staple = self.get_func(self.P_staple).get_value()
            if staple >= 1: # binding
                value = self.pjl_output_value(self.P_binding)
                if value:
                    data.append(value)
        ## Punch
        if staple == 0:
            value = self.pjl_output_value(self.P_punch)
            if value:
                data.append(value)
                staple = 1
        if staple >= 1:
            return data

        ## Booklet,Pamphlet
        duplex = self.get_func(self.P_duplex).get_support()
        booklet_media = self.get_func(self.P_mediatype).is_not_Booklet()
        if (duplex == self.ON and booklet_media == self.ON):
            dat,booklet = self.booklet_pamphlet()
            if dat:
                data += dat

        if booklet >= 1:
            return data

        ## Transparency
        if (self.get_func(self.P_mediatype).is_Transparency() == self.ON and
                self.get_func(self.P_insertPaper).get_support() == self.ON):
                dat = self.insert_Transparency()
                if dat:
                    data += dat

        ## FrontCover
        if (self.get_func(self.P_coverPrint).get_support() == self.ON and
                self.get_func(self.P_coverPrint).get_value() == 1):
                dat = self.frontCover_pjl()
                if dat:
                    data += dat
        if not data:
            return data
        return None

    def booklet_pamphlet(self):
        data = []
        booklet = 0
        if self.get_func(self.P_booklet).get_support() == self.ON:
            value = self.pjl_output_value(self.P_booklet)
            if value:
                data.append(value)
                booklet = self.get_func(self.P_booklet).get_value()

        return data,booklet

    def frontCover_pjl(self):
        data = []
        value = self.pjl_output_value(self.P_coverMedia)
        if value:
            data.append(value)
            value = self.pjl_output_value(self.P_coverPrinting)
            if value:
                data.append(value)
        return data

    def insert_Transparency(self):
        value = self.get_func(self.P_insertPaper).get_value()
        data = []
        if value == 1:
            value = self.pjl_output_value(self.P_insertPrinting)
            if value:
                data.append(value)
            value = self.pjl_output_value(self.P_insertMedia)
            if value:
                data.append(value)
        else:
            value = self.pjl_output_value(self.P_insertPaper)
            if value:
                data.append(value)
        return data

    # overwrite 
    def vendor_unique_pjl(self):
        #data = []
        return None
