#
#   pjl_snmp.py
#
#   2004.7.13
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import os
import types
from distutils import sysconfig

import Lpy.def_parm

def get_snmpfiles(dirname):
    try:
        filenames = os.listdir(dirname)
    except:
        return None

    if not filenames:
        return None

    snmpfiles = []
    for vv in filenames:
        if (vv.endswith('.py') or vv.endswith('.pyc')) and not vv.startswith('__init__.'):
            snmpfiles.append(vv[:-3])
    return snmpfiles

def get_vendor_snmp(dirname):
    t_prg = dirname.replace('.',os.sep)
    snmpfiles = get_snmpfiles(sysconfig.get_python_lib() + os.sep + t_prg)
    if snmpfiles == None:
        snmpfiles = get_snmpfiles(os.getcwd() + os.sep + t_prg)
    return snmpfiles

## Private MIB
class PJL_SNMP:
    def __init__(self,private_mib):
        self.private_mib = private_mib

    ## overwrite !!
    def get_snmpFile(self,productname,model):
        return None
    ## overwrite !!
    def set_privateMib(self,snmp_data,privateMIB,productname):
        return None

    def enterprise_support(self,snmp_data,productname):
        if not self.private_mib:
            return None

        snmpfiles = get_vendor_snmp(self.private_mib)
        if snmpfiles == None:
            return None
        model_name = self.get_snmpFile(productname,self.model)  
        if model_name == None:
            return None
        if not model_name in snmpfiles:
            print "A snmp privateMIB file(%s) cann't be found." % (self.model)
            return None

        p_mib = self.private_mib + '.' + model_name

        if Lpy.def_parm.import_flag:
            exec("import " + p_mib)
        else:
            try:
                tmp_dict = {}
                __import__(p_mib,globals(),tmp_dict)
            except :
                print "Error:import error (%s)" % (p_mib)
                return None

        privateMIB = eval(p_mib).privateMIB
        if privateMIB == None:
            return None

        return self.set_privateMib(snmp_data,privateMIB,productname)

    def get_vendor_mib(self,snmp_data,privateMIB,titles = None):
        mib_index = snmp_data.keys()
        mib_index.sort()
        p_keys = privateMIB.keys()
        p_keys.sort()
        p_keys.reverse()
        #for ii in p_keys:
        #    print ii,privateMIB[ii]

        p_data = {}
        for mib in mib_index:
            for ii in p_keys:
                if mib.startswith(ii):
                    flag = 0
                    if titles:
                        if isinstance(titles,types.StringTypes):
                            if privateMIB[ii].startswith(titles):
                                flag = 1
                        elif type(titles) in (types.ListType,types.TupleType):
                            for tt in titles:
                                if privateMIB[ii].startswith(tt):
                                    flag = 1
                                    break
                    else:
                        flag = 1

                    if flag == 1:
                        p_data[privateMIB[ii]] = (mib[len(ii):],snmp_data[mib])
                    #print "%s (%s) =  %s" % (privateMIB[ii],mib[len(ii):],snmp_data[mib])
                    break
        return p_data

