#
#   pjl_value.py
#
#   2003.9.24
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
AP_printer = "AP_Printer"
AP_maker   = "AP_Maker"
AP_type    = "AP_Type"
AP_model   = "AP_model"

base_PJL_value = (AP_printer,AP_maker,AP_type,AP_model)

class PJL_Value: # pjl_vendor.py
    P_printer = AP_printer
    P_maker   = AP_maker
    P_type    = AP_type
    P_model   = AP_model
    P_lang    = "P_Lang"
    P_GS      = "P_GS"

    P_pjl     = "P_Pjl"
    P_SNMP    = "P_SNMP"
    P_IPP     = "P_IPP"
    P_duplex  = "P_Duplex"
    P_copies  = "P_copies"
    P_orientation = "P_orientation"
    P_resolution = "P_resolution"
    P_density    = "P_density"
    P_smoothing  = "P_smoothing"
    P_tonerSave  = "P_tonerSave"
    P_rotate  = "P_rotate"
    P_scaling = "P_scaling"
    P_mirror  = "P_mirror"
    P_quality = "P_quality"

    # Margin
    P_marginLTop   = "P_marginLTop"
    P_marginLeft   = "P_marginLeft"
    P_marginRight  = "P_marginRight"
    P_marginTop    = "P_marginTop"
    P_marginBottom = "P_marginBottom"
    P_margin = (P_marginLeft,P_marginRight,P_marginTop,P_marginBottom)

    P_mediaSize  = "P_mediaSize"
    P_mediatype  = "P_mediatype"
    P_mediaColor = "P_mediaColor"
    P_intray  = "P_intray"
    P_outtray = "P_outtray"
    P_collate = "P_collate"
    P_mailbin = "P_mailbin"
    P_faceup  = "P_faceup"
    P_staple  = "P_staple"
    P_binding = "P_binding"
    P_punch   = "P_punch"
    P_booklet = "P_booklet"
    P_photo    = "P_photo"
    P_banner   = "P_banner"
    P_proof    = "P_proof"

    ## Unique
    P_ProcessingType   = "P_processingType" 
    P_ProcessingOption = "P_processingOption" 
    P_OutbinProcess  = "P_outbinProcess"  
    P_FinisherType   = "P_finisherType"   
    P_FinisherOption = "P_finisherOption" 

    P_insertPaper = "P_insertPaper"
    P_insertMedia = "P_insertMedia"
    P_insertPrinting = "P_insertPrinting"
    P_insertTray  = "P_insertTray"
    P_insertColor = "P_insertColor"

    P_coverPrint  = "P_coverPrint" # FrontCover
    P_coverMedia  = "P_coverMedia"
    P_coverPrinting = "P_coverPrinting"
    P_coverDuplex = "P_coverDuplex"
    P_coverColor  = "P_coverColor"

    P_BcoverPrint = "P_BcoverPrint" # FrontCover and BackCover
    P_BcoverMedia = "P_BcoverMedia"
    P_BcoverPrinting = "P_BcoverPrinting"
    P_BcoverDuplex   = "P_BcoverDuplex"
    P_BcoverColor    = "P_BcoverColor"

    P_division     = "P_division"
    P_divisionName = "P_divisionName"
    P_delayPrint   = "P_delayPrint"
    P_delayTime    = "P_delayTime"

    ## Hold
    P_hold      = "P_hold"
    P_holdKey   = "P_holdKey"
    P_holdType  = "P_holdType"

    ## Security
    P_diskLock   = "P_diskLock"
    P_panelLock  = "P_panelLock"
    P_panelPass  = "P_panelPass"
    P_accounting = "P_accounting"
    P_accountName= "P_accountName"
    P_security   = "P_security"
    P_userName   = "P_userName"
    P_password   = "P_password"

    # Color Printer
    P_colorPrinter = "P_colorPrinter"
    P_colorImage   = "P_colorImage"
    P_colorInk     = "P_colorInk"
    P_colorDensity = "P_colorDensity"
    P_colorRed     = "P_colorRed"
    P_colorGreen   = "P_colorGreen"
    P_colorBlue    = "P_colorBlue"

    #P_printer
    #P_maker
    base_dict = {
        P_type : "Vendor_PrinterType",
        P_model: "Vendor_model",
        P_lang : "Vendor_lang",
        P_GS   : "Vendor_gs",
        }

    pjl_dict = {
            P_pjl        : "Vendor_PrinterPJL",
            P_SNMP       : "Vendor_SNMP",
            P_IPP        : "Vendor_IPP",
            P_duplex     : "Vendor_Duplex",
            P_copies     : "Vendor_Copies",
            P_orientation: "Vendor_Orientation",
            P_resolution : "Vendor_resolv",
            P_density    : "Vendor_density",
            P_smoothing  : "Vendor_smooth",
            P_tonerSave  : "Vendor_TonerSave",
            P_rotate     : "Vendor_rotate",
            P_scaling    : "Vendor_scaling",
            P_mirror     : "Vendor_mirror",
            P_quality    : "Vendor_quality",

            # Margin
            P_marginLTop : "Vendor_margin",
            P_marginLeft : "Vendor_MarginLeft",
            P_marginRight: "Vendor_MarginRight",
            P_marginTop  : "Vendor_MarginTop",
            P_marginBottom: "Vendor_MarginBottom",

            P_mediaSize: "Vendor_paperSize",
            P_mediatype: "Vendor_mediatype",
            P_mediaColor: "Vendor_mediaColor",
            P_intray  :  "Vendor_intray",
            P_outtray :  "Vendor_outtray",
            P_collate :  "Vendor_Collation",
            P_mailbin :  "Vendor_mailbin",
            P_faceup  :  "Vendor_faceup",
            P_staple  :  "Vendor_staple",
            P_binding :  "Vendor_binding",
            P_punch   :  "Vendor_punch",
            P_booklet :  "Vendor_booklet",
            P_photo   :  "Vendor_photo",
            P_banner  :  "Vendor_Banner",
            P_proof   :  "Vendor_Proof",

            ## Finisher,MailBin
            P_ProcessingType  : "Vendor_ProcessingType",
            P_ProcessingOption: "Vendor_ProcessingOption",
            P_OutbinProcess  : "Vendor_OutbinProcess",
            P_FinisherType   : "Vendor_FinisherType",   
            P_FinisherOption : "Vendor_FinisherOption", 

            ## Transparency (OHP) :insert paper
            P_insertPaper   : "Vendor_insert",
            P_insertMedia   : "Vendor_insertMedia",
            P_insertPrinting: "Vendor_insertPrinting",
            P_insertColor   : "Vendor_insertColor",
            #P_insertTray:
            # FrontCover and BackCover
            #P_BcoverPrint
            #P_BcoverMedia
            #P_BcoverPrinting
            #P_BcoverDuplex
            #P_BcoverColor

            P_coverPrint : "Vendor_cover",
            P_coverMedia : "Vendor_coverMedia",
            P_coverPrinting: "Vendor_coverPrinting",
            P_coverDuplex: "Vendor_coverDuplex",
            P_coverColor : "Vendor_coverColor",

            P_division    : "Vendor_division",
            P_divisionName: "Vendor_divisionName",
            P_delayPrint  : "Vendor_DelayPrint",
            P_delayTime   : "Vendor_DelayTime",

            # Hold
            P_hold    :  "Vendor_Hold",
            P_holdKey :  "Vendor_HoldKey",
            P_holdType:  "Vendor_HoldType",

            ## Security
            P_diskLock :   "Vendor_DiskLock",
            P_panelLock:   "Vendor_PanelLock",
            P_panelPass:   "Vendor_PanelPassword",
            P_accounting:  "Vendor_Accounting",
            P_accountName: "Vendor_AccountName",

            P_security: "Vendor_security",
            P_userName: "Vendor_UserName",
            P_password: "Vendor_password",

            ## Color Printer
            P_colorPrinter: "Vendor_colorPrinter",
            #P_colorImage  : "Vendor_ColorImage",
            #P_colorInk    : "Vendor_ColorInk",
            #P_colorDensity: "Vendor_ColorDensity",
            #P_colorRed  : "Vendor_BalanceRed",
            #P_colorGreen: "Vendor_BalanceGreen",
            #P_colorBlue : "Vendor_BalanceBlue",
        }


