#
#       xerox_pjl.py
#
#       2003.11.6
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_class
import Lpy.pjl.pjl_printer
import Lpy.printer_model
import Lpy.pjl.pjl_title

class Xerox_Model(Lpy.printer_model.Model_lang):
    model_lists = [Lpy.printer_model.Model_lang.Laser,Lpy.printer_model.Model_lang.CLaser] 

    def __init__(self):
        Lpy.printer_model.Model_lang.__init__(self)

xerox_ColorMedia = ("blue","green","buff","white","red","ivory","gray",
                    "clear","pink","goldenrod","orange","yellow")


class Vendor_PrinterType(Lpy.pjl.pjl_printer.PrinterType,Xerox_Model):
    def __init__(self,ptype = None,model = None):
        Lpy.pjl.pjl_printer.PrinterType.__init__(self)
        Xerox_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_model(Lpy.pjl.pjl_printer.PrinterModel,Xerox_Model):
    def __init__(self,ptype,model = None):
        Lpy.pjl.pjl_printer.PrinterModel.__init__(self)
        Xerox_Model.__init__(self)
        self.check_model(ptype,model)

class Vendor_lang(Lpy.pjl.pjl_printer.PrinterLang,Xerox_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.PrinterLang.__init__(self)
        Xerox_Model.__init__(self)
        self.check_model(ptype,model)
        self.value = self.value_list[0]

class Vendor_gs(Lpy.pjl.pjl_printer.GhostScript,Xerox_Model):
    def __init__(self,ptype,model):
        Lpy.pjl.pjl_printer.GhostScript.__init__(self)
        Xerox_Model.__init__(self)
        self.support = self.ON
        self.value = 'ljet4'

class Vendor_PrinterPJL(Lpy.pjl.pjl_printer.PrinterPJL,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.PrinterPJL.__init__(self)
        Xerox_Model.__init__(self)
        self.support = self.ON
    def check_model(self,ptype,model):
        self.support = self.ON

#####
class Vendor_SNMP(Lpy.pjl.pjl_printer.SNMP,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.SNMP.__init__(self)
        Xerox_Model.__init__(self)
        self.vendorID = 253
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_IPP(Lpy.pjl.pjl_printer.IPP,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.IPP.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_Duplex(Lpy.pjl.pjl_printer.Duplex,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_printer.Duplex.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

#####
class Vendor_Copies(Lpy.pjl.pjl_class.Copies,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Copies.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_Orientation(Lpy.pjl.pjl_class.Orientation,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Orientation.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support =  self.ON

class Vendor_resolv(Lpy.pjl.pjl_class.Resolution,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Resolution.__init__(self)
        Xerox_Model.__init__(self)
        resolv = ['400','600','1200','1800']
        self.support = self.ON
        self.set_vlist(resolv,0)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_density(Lpy.pjl.pjl_class.Density,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Density.__init__(self)
        Xerox_Model.__init__(self)
        self.max_val = 7
        self.value = 4
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_TonerSave(Lpy.pjl.pjl_class.TonerSave,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.TonerSave.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_quality(Lpy.pjl.pjl_class.Quality,Xerox_Model): # P_quality
    def __init__(self):
        Lpy.pjl.pjl_class.Quality.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd  = 'OID_ATT_PRINT_QUALITY'
        self.pjl_lists = ("OID_VAL_PRINT_QUALITY_NORMAL","OID_VAL_PRINT_QUALITY_DRAFT")
        self.value_list = (_("NORMAL"),_("DRAFT"))

    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        return "%s %s;" % (self.pjl_cmd,self.pjl_lists[self.value])

    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_Banner(Lpy.pjl.pjl_class.Banner,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Banner.__init__(self)
        Xerox_Model.__init__(self)
        self.support = self.ON
        self.pjl_cmd = 'OID_ATT_STRAT_SHEET'
        self.pjl_lists = ("OID_VAL_JOB_SHEET_NONE","OID_VAL_JOB_SHEET_FULL")

    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None or self.pjl_lists is None:
            return None
        return "%s %s;" % (self.pjl_cmd,self.value_list[self.value])

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_Proof(Lpy.pjl.pjl_class.Proof,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Proof.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_JOB_TYPE'
        self.pjl_lists = ("OID_VAL_JOB_TYPE_PRINT","OID_VAL_JOB_TYPE_PROOF_PRINT")

    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None or self.pjl_lists is None:
            return None
        return "%s %s;" % (self.pjl_cmd,self.value_list[self.value])

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_intray(Lpy.pjl.pjl_class.InputTray,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.InputTray.__init__(self)
        Xerox_Model.__init__(self)
        #self.set_tray_support(self.TR_tray,self.ON)
        #self.set_tray_support(self.TR_auto,self.ON)
        #self.set_tray_support(self.TR_manual,self.ON)

    def check_model(self,ptype,model):
        self.support = self.Never

class Vendor_mediatype(Lpy.pjl.pjl_class.MediaType,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.MediaType.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_MEDIUM_TYPE'
        self.xerox_media(self.typeMedia)
        self.set_selectDict()

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
        else:
            self.support = self.ON

    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        media = self.get_pjl_media()
        if self.pjl_cmd and media:
            return "%s %s;" % (self.pjl_cmd,media)
        else:
            return None

class Vendor_mediaColor(Lpy.pjl.pjl_class.MediaColor,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.MediaColor.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_MEDIUM_COLOR'
        self.support = self.OFF
        self.value_list = xerox_ColorMedia

    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None:
            return None
        return "%s %s;" % (self.pjl_cmd,self.value_list[self.value])

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_Collation(Lpy.pjl.pjl_class.Collation,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Collation.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_OUTPUT'
        self.pjl_lists = ("OID_VAL_OUTPUT_NO_PAGE_COLLATE","OID_VAL_OUTPUT_PAGE_COLLATE")

    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None or self.pjl_lists is None:
            return None
        return "%s %s;" % (self.pjl_cmd,self.value_list[self.value])

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_outtray(Lpy.pjl.pjl_class.OutTray,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.OutTray.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_OUTPUT_BINS'
        #self.pjl_lists = ("OID_VAL_OUTPUT_BIN_TOP","OID_VAL_OUTPUT_BIN_MAIN")

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
            self.set_vlist(1,0) # outtray == 1,2,3
        else:
            self.support = self.ON
            self.pjl_lists = ("OID_VAL_OUTPUT_BIN_TOP","OID_VAL_OUTPUT_BIN_STACKER",
                              "OID_VAL_OUTPUT_BIN_SIDE")
            self.set_vlist(3,0) # outtray == 1,2,3

    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None or self.pjl_lists is None:
            return None
        return "%s %d;" % (self.pjl_cmd,self.pjl_lists[self.value])

class Vendor_staple(Lpy.pjl.pjl_class.Staple,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Staple.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_FINISHING'
        self.pjl_lists = ("OID_VAL_GENERIC_NONE","OID_VAL_FINISHING_STAPLE")
        # COMMENT XRXSTAPLE = DUAL,PORTRAIT,LANDSCAPE
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON
    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None or self.pjl_lists is None:
            return None
        return "%s %d;" % (self.pjl_cmd,self.pjl_lists[self.value])

class Vendor_smooth(Lpy.pjl.pjl_class.Smoothing,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Smoothing.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.Never

class Vendor_binding(Lpy.pjl.pjl_class.Binding,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Binding.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.Never

class Vendor_punch(Lpy.pjl.pjl_class.Punch,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.Punch.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_PUNCH'

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON
    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None:
            return None
        return "%s %d;" % (self.pjl_cmd,self.value)

## InsertPaper :Transparency OHP
class Vendor_insert(Lpy.pjl.pjl_class.InsertPaper,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.InsertPaper.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_INTERLEAVE'
        self.pjl_lists = ("OID_VAL_INTERLEAVE_NONE","OID_VAL_INTERLEAVE_BLANK")
 
    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None:
            return None
        return "%s %s;" % (self.pjl_cmd,self.pjl_lists[self.value])

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_insertPrinting(Lpy.pjl.pjl_class.InsertPrinting,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.InsertPrinting.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_INTERLEAVE'
        self.pjl_lists = ("OID_VAL_INTERLEAVE_BLANK","OID_VAL_INTERLEAVE_IMAGED")
    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None:
            return None
        return "%s %s;" % (self.pjl_cmd,self.pjl_lists[self.value])

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_insertColor(Lpy.pjl.pjl_class.InsertColor,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.InsertColor.__init__(self)
        Xerox_Model.__init__(self)
        self.value_list = xerox_ColorMedia
    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None:
            return None
        return "%s %s;" % (self.pjl_cmd,self.value_list[self.value])

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

## Front Cover
class Vendor_cover(Lpy.pjl.pjl_class.CoverPrint,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.CoverPrint.__init__(self)
        Xerox_Model.__init__(self)

    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_coverPrinting(Lpy.pjl.pjl_class.CoverPrinting,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.CoverPrinting.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_FIRSTLAST_PAGE_IMAGED'
        self.pjl_lists = ("FALSE","TRUE")
        self.support = self.OFF
        self.set_value(0)
        self.auto_value = self.ON
    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None:
            return None
        return "%s %s;" % (self.pjl_cmd,self.pjl_lists[self.value])
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_coverMedia(Lpy.pjl.pjl_class.CoverMedia,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.CoverMedia.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_FIRST_PAGE_MEDIA_TYPE'
        self.xerox_media(self.typeCover) 
        self.set_selectDict()

    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        media = self.get_pjl_media()
        if self.pjl_cmd and media:
            return "%s %s;" % (self.pjl_cmd,media)
        else:
            return None
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_coverColor(Lpy.pjl.pjl_class.CoverColor,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.CoverColor.__init__(self)
        Xerox_Model.__init__(self)
        self.value_list = xerox_ColorMedia
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON
    def get_pjlparm(self):
        if self.support != self.ON or self.pjl_cmd is None:
            return None
        return "%s %s;" % (self.pjl_cmd,self.value_list[self.value])

## DelayPrint ##
class Vendor_DelayPrint(Lpy.pjl.pjl_class.DelayPrint,Xerox_Model): # P_delayPrint
    def __init__(self):
        Lpy.pjl.pjl_class.DelayPrint.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_JOB_PRINT_AFTER'
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON
class Vendor_DelayTime(Lpy.pjl.pjl_class.DelayTime,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.DelayTime.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

## Accounting
class Vendor_Accounting(Lpy.pjl.pjl_class.Accounting,Xerox_Model): # P_accounting
    def __init__(self):
        Lpy.pjl.pjl_class.Accounting.__init__(self)
        Xerox_Model.__init__(self)
        self.pjl_cmd = 'OID_ATT_ACCOUNTING_INFORMATION'
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.Never
        else:
            self.support = self.ON

class Vendor_AccountName(Lpy.pjl.pjl_class.AccountName,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.AccountName.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

class Vendor_UserName(Lpy.pjl.pjl_class.UserName,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.UserName.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        self.support = self.ON

## Color Printer
class Vendor_colorPrinter(Lpy.pjl.pjl_class.ColorPrinter,Xerox_Model):
    def __init__(self):
        Lpy.pjl.pjl_class.ColorPrinter.__init__(self)
        Xerox_Model.__init__(self)
    def check_model(self,ptype,model):
        if model == self.N_personal:
            self.support = self.OFF
        else:
            self.support = self.ON
