<?php
/**
 * a copy of menu.inc.php v1.8
 *
 * @copyright  PukiWiki Developers Team
 * @license    GPL v2 or (at your option) any later version
 * @version    $Id: side.inc.php 260 2007-08-01 12:47:09Z lunt $
 */

// サブメニューを使用する
define('SIDE_ENABLE_SUBMENU', FALSE);

// サブメニューの名称
define('SIDE_SUBMENUBAR', 'SideBar');

function plugin_side_convert()
{
	global $vars;
	static $side = NULL;

	$num = func_num_args();
	if ($num > 0) {
		// Try to change default 'SideBar' page name (only)
		if ($num > 1)       return '#side(): Zero or One argument needed';
		if ($side !== NULL) return '#side(): Already set: ' . htmlspecialchars($side);
		$args = func_get_args();
		if (! is_page($args[0])) {
			return '#side(): No such page: ' . htmlspecialchars($args[0]);
		} else {
			$side = $args[0]; // Set
			return '';
		}

	} else {
		// Output sidebar page data
		$page = ($side === NULL) ? 'SideBar' : $side;

		if (SIDE_ENABLE_SUBMENU) {
			$path = explode('/', strip_bracket($vars['page']));
			while(! empty($path)) {
				$_page = join('/', $path) . '/' . SIDE_SUBMENUBAR;
				if (is_page($_page)) {
					$page = $_page;
					break;
				}
				array_pop($path);
			}
		}

		if (! is_page($page)) {
			return '';
		} else if ($vars['page'] == $page) {
			return '<!-- #side(): You already view ' . htmlspecialchars($page) . ' -->';
		} else {
			// Cut fixed anchors
			$sidetext = preg_replace('/^(\*{1,3}.*)\[#[A-Za-z][\w-]+\](.*)$/m', '$1$2', get_source($page));

			return preg_replace('/<ul[^>]*>/', '<ul>', convert_html($sidetext));  
		}
	}
}
?>
