<?php
/**
 * CSS Style Plugin
 *  
 * @author     sonots
 * @license    http://www.gnu.org/licenses/gpl.html GPL v2
 * @link       http://lsx.sourceforge.jp/?Plugin%2Fstyle.inc.hp
 * @version    $Id: style.inc.php,v 1.4 2007-12-30 19:02:47Z sonots $
 * @package    plugin
 */

function plugin_style_convert()
{
    $args = func_get_args();
    $end = end($args);
    if (substr($end, -1) == "\r") {
        $body = array_pop($args);
    }
    $options = array(
        'style' => NULL,
        'class' => NULL,
        'addstyle' => NULL,
        'putclass' => NULL,
        'putstyle' => NULL,
        'end'   => FALSE,
    );
    foreach ($args as $arg) {
        list($key, $val) = array_pad(explode('=', $arg, 2), 2, TRUE);
        if (array_key_exists($key, $options)) {
            $options[$key] = $val;
        } else { // default
            $options['style'] = $arg;
        }
    }

    $open = '';
    $open .= (! is_null($options['class'])) ? ' class="' . htmlspecialchars($options['class']) . '"' : '';
    $open .= (! is_null($options['style'])) ? ' style="' . htmlspecialchars($options['style']) . '"' : '';
    $open = ($open != '') ? '<div' . $open . '>' . "\n" : '';
    if (isset($body)) {
        $body = str_replace("\r", "\n", $body);
        $body = convert_html($body);
        plugin_style_replace_leadingtag($body, $options['putclass'], $options['addstyle'], $options['putstyle']);
    }
    $close = (isset($body) && $open != '') || $options['end'] ? '</div>' : '';
    return $open . $body . $close;
}

function plugin_style_replace_leadingtag(&$html, $putclass = NULL, $addstyle = NULL, $putstyle = NULL)
{
    if (is_null($putclass) && is_null($addstyle) && is_null($putstyle)) return;
    preg_match('#^([^<]*)(<[^>]*>)(.*)#s', $html, $matches);
    $head = $matches[1];
    $tag  = $matches[2];
    $rest = $matches[3];
    if (! is_null($putclass)) {
        $putclass = ($putclass == '') ? '' : 'class="' . htmlspecialchars($putclass) . '"';
        $replace = preg_replace('#class="[^"]*"#', $putclass, $tag);
        if ($replace == $tag) {
            $replace = str_replace('>', ' ' . $putclass . '">', $tag);
        }
        $tag = $replace;
    }
    if (! is_null($putstyle)) {
        $putstyle = ($putstyle == '') ? '' : 'style="' . htmlspecialchars($putstyle) . '"';
        $replace = preg_replace('#style="[^"]*"#', $putstyle, $tag);
        if ($replace == $tag) {
            $replace = str_replace('>', ' ' .  $putstyle . '">', $tag);
        }
    } elseif (! is_null($addstyle)) {
        $replace = preg_replace('#style="[^"]*"#', 'style="\\1' . htmlspecialchars($addstyle) . '"', $tag);
        if ($replace == $tag) {
            $replace = str_replace('>', ' style="' . htmlspecialchars($addstyle) . '">', $tag);
        }
    }
    $html = $head . $replace . $rest;
}

?>
