/* Copyright(C) 2004-2005 Brazil

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _SEN_SNIP_H
#define _SEN_SNIP_H

#ifndef _SENNA_H
#include "senna_in.h"
#endif /* _SENNA_H */

#define ASIZE                   256U
#define MAX_SNIP_TAG_COUNT      512U
#define MAX_SNIP_COND_COUNT     32U
#define MAX_SNIP_RESULT_COUNT   8U

#ifdef  __cplusplus
extern "C"
{
#endif

#include "str.h"

typedef struct __snip_cond
{
  /* initial parameters */
  const char *opentag;
  const char *closetag;
  size_t opentag_len;
  size_t closetag_len;
  sen_nstr *keyword;

  /* Tuned BM pre */
  size_t bmBc[ASIZE];
  size_t shift;

  /* Tuned BM temporal result */
  size_t found;
  size_t last_found;
  size_t start_offset;
  size_t end_offset;
  size_t found_alpha_head;

  /* search result */
  int count;

  /* stop flag */
  int_least8_t stopflag;      /* 0=go, 1=stop, 2=temporal stop */
} _snip_cond;

typedef struct
{
  size_t start_offset;
  size_t end_offset;
  _snip_cond *cond;
} _snip_tag_result;

typedef struct
{
  size_t start_offset;
  size_t end_offset;
  unsigned int first_tag_result_idx;
  unsigned int last_tag_result_idx;
  unsigned int tag_count;
} _snip_result;

struct _sen_snip
{
  sen_encoding encoding;
  int flags;
  size_t width;
  unsigned int max_results;
  const char *defaultopentag;
  const char *defaultclosetag;
  size_t defaultopentag_len;
  size_t defaultclosetag_len;

  sen_snip_mapping *mapping;

  _snip_cond cond[MAX_SNIP_COND_COUNT];
  unsigned int cond_len;

  unsigned int tag_count;
  unsigned int snip_count;

  const char *string;
  sen_nstr *nstr;

  _snip_result snip_result[MAX_SNIP_RESULT_COUNT];
  _snip_tag_result tag_result[MAX_SNIP_TAG_COUNT];

  size_t max_tagged_len;
};

#ifdef __cplusplus
}
#endif

#endif /* _SEN_SNIP_H */
