$LOAD_PATH << "/usr/lib64/ruby/site_ruby/1.8/x86_64-linux"
require 'pp'
require "RRD" 
HOSTS_FILE="/etc/hosts"
IMG_FORMAT="PNG"
SUFFIX=IMG_FORMAT.downcase

class IpvsRRD
  @@vs_table=Hash.new
  File.open(HOSTS_FILE).each do |line|
    vs_name, vs_string = line.split(/\s+/).values_at(0,1)
    @@vs_table[vs_name] = vs_string
  end

  def self.mk_title(rrd_basename, graph_type=nil)
    vs_name=rrd_basename.sub("_",":")
    search=vs_name.split(":")[0]
    @@vs_table.key?(search) ? "#{@@vs_table[search]} #{vs_name}" : vs_name
  end

  def shared_graph_opt
    [
    "--imgformat=#{IMG_FORMAT}", "--start=-86400", "--end=-1",
    "--base=1000", "--height=120", "--width=500",
    ]
  end

  def uniq_graph_opt(graph_type, rrd)
    title=IpvsRRD.mk_title(@basename)

    case graph_type
    when "actconn":
      title="#{title} active connections" ; vertical_label="active conn"
      return [
        "--title=#{title}",
        "--vertical-label=#{vertical_label}",
        "DEF:a=#{rrd}:ActiveConn:AVERAGE",
        'AREA:a#EAAF00:active connection\n',
        'LINE1:a#DA4725',
        'GPRINT:a:LAST:current\:%8.2lf %S',
        'GPRINT:a:AVERAGE:average\:%8.2lf %S',
        'GPRINT:a:MAX:max\:%8.2lf %S\n'
    ]
    when "inactconn":
      title="#{title} inactive connections" ; vertical_label="inactive conn"
      return [
      "--title=#{title}",
      "--vertical-label=#{vertical_label}",
      "DEF:a=#{rrd}:InActConn:AVERAGE",
      'AREA:a#12B3B5:inactive connection\n',
      'LINE1:a#002A97',
      'GPRINT:a:LAST:current\:%8.2lf %S',
      'GPRINT:a:AVERAGE:average\:%8.2lf %S',
      'GPRINT:a:MAX:max\:%8.2lf %S\n'
    ]
    when "conn"
      title="#{title} cps" ; vertical_label="conn per sec"
      return [
      "--title=#{title}",
      "--vertical-label=#{vertical_label}",
      "DEF:a=#{rrd}:Conns:AVERAGE",
      'AREA:a#7CB3F1:num of connection\n',
      'LINE1:a#00234B',
      'GPRINT:a:LAST:current\:%8.2lf %S',
      'GPRINT:a:AVERAGE:average\:%8.2lf %S',
      'GPRINT:a:MAX:max\:%8.2lf %S\n'
    ]
    when "traffic"
      title="#{title} traffic" ; vertical_label="bit per second"
      return [
      "--title=#{title}",
      "--vertical-label=#{vertical_label}",
    "DEF:a=#{rrd}:InBytes:AVERAGE",
    "DEF:b=#{rrd}:OutBytes:AVERAGE",
    "CDEF:cdefa=a,8,*",
    "CDEF:cdefb=b,8,*",  
    "AREA:cdefa#00CF00:Inbound ",
    'GPRINT:cdefa:LAST:current\:%8.2lf %S',
    'GPRINT:cdefa:AVERAGE:average\:%8.2lf %S',
    'GPRINT:cdefa:MAX:max\:%8.2lf %S\n',
    "LINE1:cdefb#002A97:Outbound",
    'GPRINT:cdefb:LAST:current\:%8.2lf %S',
    'GPRINT:cdefb:AVERAGE:average\:%8.2lf %S',
    'GPRINT:cdefb:MAX:max\:%8.2lf %S\n'
    ]
    when "pps"
      title="#{title} packet per second" ; vertical_label="pps"
      return [
      "--title=#{title}",
      "--vertical-label=#{vertical_label}",
    "DEF:a=#{rrd}:InPkts:AVERAGE",
    "DEF:b=#{rrd}:OutPkts:AVERAGE",
    "AREA:a#00CF00:Inbound ",
    'GPRINT:a:LAST:current\:%8.2lf %S',
    'GPRINT:a:AVERAGE:average\:%8.2lf %S',
    'GPRINT:a:MAX:max\:%8.2lf %S\n',
    "LINE1:b#002A97:Outbound",
    'GPRINT:b:LAST:current\:%8.2lf %S',
    'GPRINT:b:AVERAGE:average\:%8.2lf %S',
    'GPRINT:b:MAX:max\:%8.2lf %S\n'
    ]
    when "pktsize"
      title="#{title} packet size" ; vertical_label="average packet size"
      return [
      "--title=#{title}",
      "--vertical-label=#{vertical_label}",
    "DEF:a=#{rrd}:InBytes:AVERAGE",
    "DEF:b=#{rrd}:OutBytes:AVERAGE",
    "DEF:c=#{rrd}:InPkts:AVERAGE",
    "DEF:d=#{rrd}:OutPkts:AVERAGE",
    "CDEF:cdefa=a,c,/",
    "CDEF:cdefb=b,d,/",  
    "AREA:cdefa#00CF00:Inbound ",
    'GPRINT:cdefa:LAST:current\:%8.2lf %S',
    'GPRINT:cdefa:AVERAGE:average\:%8.2lf %S',
    'GPRINT:cdefa:MAX:max\:%8.2lf %S\n',
    "LINE1:cdefb#002A97:Outbound",
    'GPRINT:cdefb:LAST:current\:%8.2lf %S',
    'GPRINT:cdefb:AVERAGE:average\:%8.2lf %S',
    'GPRINT:cdefb:MAX:max\:%8.2lf %S\n'
    ]
    when "bit_per_conn"
      title="#{title} bit/conn" ; vertical_label="bit per conn"
      return [
      "--title=#{title}",
      "--vertical-label=#{vertical_label}",
    "DEF:a=#{rrd}:InBytes:AVERAGE",
    "DEF:b=#{rrd}:OutBytes:AVERAGE",
    "DEF:c=#{rrd}:Conns:AVERAGE",
    "CDEF:cdefa=a,8,*,c,/",
    "CDEF:cdefb=b,8,*,c,/",  
    "AREA:cdefa#00CF00:Inbound ",
    'GPRINT:cdefa:LAST:current\:%8.2lf %S',
    'GPRINT:cdefa:AVERAGE:average\:%8.2lf %S',
    'GPRINT:cdefa:MAX:max\:%8.2lf %S\n',
    "LINE1:cdefb#002A97:Outbound",
    'GPRINT:cdefb:LAST:current\:%8.2lf %S',
    'GPRINT:cdefb:AVERAGE:average\:%8.2lf %S',
    'GPRINT:cdefb:MAX:max\:%8.2lf %S\n'

    ]
    when "pkt_per_conn"
      title="#{title} packet/conn" ; vertical_label="packet per conn"
      return [
      "--title=#{title}",
      "--vertical-label=#{vertical_label}",
    "DEF:a=#{rrd}:InPkts:AVERAGE",
    "DEF:b=#{rrd}:OutPkts:AVERAGE",
    "DEF:c=#{rrd}:Conns:AVERAGE",
    "CDEF:cdefa=a,8,*,c,/",
    "CDEF:cdefb=b,8,*,c,/",  
    "AREA:cdefa#00CF00:Inbound ",
    'GPRINT:cdefa:LAST:current\:%8.2lf %S',
    'GPRINT:cdefa:AVERAGE:average\:%8.2lf %S',
    'GPRINT:cdefa:MAX:max\:%8.2lf %S\n',
    "LINE1:cdefb#002A97:Outbound",
    'GPRINT:cdefb:LAST:current\:%8.2lf %S',
    'GPRINT:cdefb:AVERAGE:average\:%8.2lf %S',
    'GPRINT:cdefb:MAX:max\:%8.2lf %S\n'
    ]
    else
    end
  end

  def initialize(rrd)
    @rrd=rrd
    @basename=File.basename(@rrd, ".rrd")
  end

  def set_graph_opt(graph_type)
    @graph_opt=Array.new
    @filename="#{GRAPH_DIR}/#{@basename}-#{graph_type}.#{SUFFIX}"
    @graph_opt << @filename
    @graph_opt.concat(shared_graph_opt)
    @graph_opt.concat(uniq_graph_opt(graph_type, @rrd))
    #dump_graphopt
    self
  end

  def dump_graphopt; pp @graph_opt         ; end
  def graph        ; RRD.graph(*@graph_opt); end
end

class IpvsRRD_All
  def color_list(num)
    color=0xFFFFFF
    color_step=0xFFFFFF/num
    color_list = Array.new
    num.times do
      color = color - color_step
      color_list << sprintf("%06x",color)
    end
    color_list
  end

  def initialize(rrd_files)
    @rrd_files=rrd_files
    @colors=color_list(rrd_files.size)
    @range=nil
  end

  def each_rrd(&block)
    ary=Array.new
    @rrd_files.each_with_index do |rrd, index|
      basename=File.basename(rrd,".rrd")
      vs_name=IpvsRRD.mk_title(basename).sub(":","\\:")
      draw_method = index.zero? ? "AREA" : "STACK"
      ary.concat(yield(rrd, index,vs_name, draw_method))
    end
    ary
  end

  def set_graph_opt(graph_type,range="d")
    @graph_opt=Array.new
    @range=range
    if @range=="d"
      @filename ="#{GRAPH_DIR}/vs_all-#{graph_type}.#{SUFFIX}"
    else
      @filename ="#{GRAPH_DIR}/#{@range}/vs_all-#{graph_type}.#{SUFFIX}"
    end
    @graph_opt << @filename
    @graph_opt.concat(uniq_graph_opt(graph_type))
    #dump_graphopt
    self
  end

  def uniq_graph_opt(graph_type)
    a=Array.new
    colors=@colors.dup

    case graph_type
    when "actconn":
      title="Active Connections"; vertical_label="active connections"
      a=self.each_rrd do |rrd, index, vs_name, draw_method|
      [
         "DEF:v#{index}=#{rrd}:ActiveConn:AVERAGE",
          %Q!#{draw_method}:v#{index}##{colors.shift}:#{vs_name}\\n!
      ]
      end
    when "inactconn":
      title="Inactive Connections"; vertical_label="inactive connections"
      a=self.each_rrd do |rrd, index, vs_name, draw_method|
      [
         "DEF:v#{index}=#{rrd}:InActConn:AVERAGE",
          %Q!#{draw_method}:v#{index}##{colors.shift}:#{vs_name}\\n!
      ]
      end
    when "conn":
      title="Connections"; vertical_label="conn per sec"
      a=self.each_rrd do |rrd, index, vs_name, draw_method|
      [
          "DEF:v#{index}=#{rrd}:Conns:AVERAGE",
          %Q!#{draw_method}:v#{index}##{colors.shift}:#{vs_name}\\n!
      ]
      end
    when "traffic_recv":
      title="Inbound bps"; vertical_label="Inbound bps"
      a=self.each_rrd do |rrd, index, vs_name, draw_method|
      [
          "DEF:v#{index}=#{rrd}:InBytes:AVERAGE",
          "CDEF:cdef#{index}=v#{index},8,*",
          %Q!#{draw_method}:cdef#{index}##{colors.shift}:#{vs_name}\\n!
      ]
      end
    when "traffic_send":
      title="Outbound bps"; vertical_label="Outbound bps"
      a=self.each_rrd do |rrd, index, vs_name, draw_method|
      [ 
          "DEF:v#{index}=#{rrd}:OutBytes:AVERAGE",
          "CDEF:cdef#{index}=v#{index},8,*",
          %Q!#{draw_method}:cdef#{index}##{colors.shift}:#{vs_name}\\n!
      ]
      end
    else
    end

    grid=""
    now=Time.now.to_i
    day = 60 * 60 * 24
    case @range
    when "d"
      start=-day
    when "w"
      start=-day * 7
      grid="--x-grid=HOUR:6:HOUR:12:DAY:1:0:%m/%d(%a)"
    when "m"
      start=-day * 31
      grid="--x-grid=DAY:1:DAY:15:DAY:1:0:%d"
    when "y"
      start=-day * 365
      grid="--x-grid=MONTH:1:MONTH:3:MONTH:1:0:%m/%d"
    end

    ary= [
    "--imgformat=#{IMG_FORMAT}", "--start=#{start}", "--end=-1",
    "--base=1000", "--height=240", "--width=1000", "--title=#{title}",
    "--vertical-label=#{vertical_label}",
    ]
    ary.concat(a)
    ary << grid unless grid.empty?
    return ary
  end

  def dump_graphopt; pp @graph_opt         ; end
  def graph        ; RRD.graph(*@graph_opt); end
end
