#!/usr/bin/env ruby
SCRIPT_DIR=File.dirname(File.expand_path(__FILE__))
require "#{SCRIPT_DIR}/ipvs_rrd.rb"
RRD_DIR="#{SCRIPT_DIR}/rrd"
GRAPH_DIR="#{SCRIPT_DIR}/graph"

rrd_files=Dir.glob("#{RRD_DIR}/*.rrd").sort

rrd_files.each do |rrd|
  vs=IpvsRRD.new(rrd)
  vs.set_graph_opt("actconn").graph
  vs.set_graph_opt("inactconn").graph
  vs.set_graph_opt("conn").graph
  vs.set_graph_opt("traffic").graph
  vs.set_graph_opt("pps").graph
  vs.set_graph_opt("pktsize").graph
  vs.set_graph_opt("bit_per_conn").graph
  vs.set_graph_opt("pkt_per_conn").graph
end
all_vs=IpvsRRD_All.new(rrd_files)
%w( d w m y ).each do |range|
  all_vs.set_graph_opt("actconn",range).graph
  all_vs.set_graph_opt("inactconn",range).graph
  all_vs.set_graph_opt("conn",range).graph
  all_vs.set_graph_opt("traffic_send",range).graph
  all_vs.set_graph_opt("traffic_recv",range).graph
end
