# spec file for lxcf

%define name           lxcf
%define release        1
%define version        0.5

Summary:               A LXC facility tool
License:               GPLv2
Name:                  %{name}
Version:               %{version}
Release:               %{release}
Source:                %{name}-%{version}.tar.gz
Prefix:                %{_prefix}
Group:                 Applications/Emulators
BuildRequires:         libvirt-daemon-driver-lxc
Requires:              python
Requires:              python-IPy
Requires:              virt-manager
URL:                   https://sourceforge.net/projects/lxcfacility/

%description
LXCF is a LXC facility tool.
LXCF efficiently makes the instance. One-instance making is a few
minutes or less.
The LXCF instance can dynamically change the resource of CPU, MEMORY,
IO and NET. Even if the instance has stopped, the change in the resource
can be changed.
LXCF can be used by installing it on Linux on VM as well as bare metal.
LXCF can be operated stabilizing the job like a past system at a long term.
Moreover, a lot of LXCF instances are generate in a short time. If a lot
of LXCF instances become unnecessary, it is possible to delete it
collectively. Such stateless instance can be operated.

%prep
%setup -q

%build
make clean
make

%install
make install DESTDIR=$RPM_BUILD_ROOT

%post
%{_libdir}/lxcf/lxcf-init
pkill -term virt-manager
systemctl restart libvirtd
systemctl start lxcf-sched >& /dev/null

%postun
pkill -term virt-manager
systemctl restart libvirtd

%files
%defattr(-,root,root)
%{_prefix}/sbin/lxcf
%{_libdir}/lxcf/lxcf-init
%{_libdir}/lxcf/lxcf-keygen
%{_libdir}/lxcf/lxcf-rc
%{_libdir}/lxcf/lxcf-config
%{_libdir}/lxcf/lxcf-maintenance
%{_libdir}/lxcf/lxcf-resource
%{_libdir}/lxcf/lxcf-resource1
%{_libdir}/lxcf/lxcf-resource2
%{_libdir}/lxcf/lxcf-sched
%{_libdir}/lxcf/lxcf-sysgen
%{_libdir}/lxcf/lxcf-check-json
%{_libdir}/lxcf/lxcf-createfile
%{_libdir}/lxcf/lxcf-clearlog
%{_libdir}/lxcf/lxcf-setup
%{_libdir}/lxcf/lxcf-define
%{_libdir}/lxcf/lxcf-load
%{_libdir}/lxcf/lxcf-clone
%{_libdir}/lxcf/lxcf-clone-setup
%{_libdir}/lxcf/lxcf-erase
%{_libdir}/lxcf/lxcf-erase-setup
%{_libdir}/lxcf/lxcf-list
%{_libdir}/lxcf/lxcf-update
%{_libdir}/lxcf/lxcf-update1
%{_libdir}/lxcf/lxcf-update2
%{_libdir}/lxcf/lxcf-deploy
%{_libdir}/lxcf/lxcf-start
%{_libdir}/lxcf/lxcf-stop
%{_libdir}/lxcf/lxcf-reboot
%{_libdir}/lxcf/lxcf-suspend
%{_libdir}/lxcf/lxcf-resume
%{_libdir}/lxcf/lxcf-run
%{_libdir}/lxcf/lxcf-autostart
%{_libdir}/lxcf/lxcf-submit
%{_libdir}/lxcf/lxcf-skipjob
%{_libdir}/lxcf/lxcf-queue-list
%{_libdir}/lxcf/lxcf-queue-clear
%{_libdir}/lxcf/lxcf-queue-cancel
%{_libdir}/lxcf/lxcf-queue-move
%{_libdir}/lxcf/lxcf-parmchk-num
%{_libdir}/lxcf/lxcf-parmchk-num-kmg
%{_libdir}/lxcf/lxcf-parmchk-cname
%{_libdir}/lxcf/lxcf-parmchk-float
%{_libdir}/lxcf/lxcf-parmchk-float-kmg
%{_libdir}/lxcf/lxcf-parmchk-hexdig
%{_libdir}/lxcf/lxcf-parmchk-MJMI
%{_libdir}/lxcf/helpfile.txt
%{_libdir}/lxcf/sbin/update-alert
%{_libdir}/lxcf/sbin/cpun
%{_libdir}/lxcf/sbin/cpurate
%{_libdir}/lxcf/sbin/numa
%{_libdir}/lxcf/sbin/memlimit
%{_libdir}/lxcf/sbin/memswlimit
%{_libdir}/lxcf/sbin/blkio_r
%{_libdir}/lxcf/sbin/blkio_w
%{_libdir}/lxcf/sbin/blkiops_r
%{_libdir}/lxcf/sbin/blkiops_w
%{_libdir}/lxcf/sbin/net_cls
%{_libdir}/lxcf/sbin/set
%{_libdir}/lxcf/sbin/set-n
%{_libdir}/lxcf/sbin/show
%{_libdir}/lxcf/sbin/sysgen
%{_libdir}/lxcf/sbin/sysgen-n
%{_libdir}/lxcf/sbin/clone
%{_libdir}/lxcf/sbin/clone-n
%{_libdir}/lxcf/sbin/erase
%{_libdir}/lxcf/sbin/erase-n
%{_libdir}/lxcf/sbin/list
%{_libdir}/lxcf/sbin/update
%{_libdir}/lxcf/sbin/deploy
%{_libdir}/lxcf/sbin/start
%{_libdir}/lxcf/sbin/start-n
%{_libdir}/lxcf/sbin/stop
%{_libdir}/lxcf/sbin/stop-n
%{_libdir}/lxcf/sbin/reboot
%{_libdir}/lxcf/sbin/suspend
%{_libdir}/lxcf/sbin/suspend-n
%{_libdir}/lxcf/sbin/resume
%{_libdir}/lxcf/sbin/resume-n
%{_libdir}/lxcf/sbin/run
%{_libdir}/lxcf/sbin/autostart
%{_libdir}/lxcf/sbin/submit
%{_libdir}/lxcf/sbin/skipjob
%{_libdir}/lxcf/sbin/queue
%{_libdir}/lxcf/sbin/helpcmd
%{_libdir}/lxcf/sbin/version
%{_libdir}/lxcf/lxcf.conf
%config(noreplace) %{_sysconfdir}/lxcf/lxcf.conf
%{_sysconfdir}/libvirt/hooks/lxc
%{_sysconfdir}/libvirt/hooks/qemu
%config(noreplace) %{_sysconfdir}/libvirt/qemu/networks/lxcfnet1.xml
%{_sysconfdir}/libvirt/qemu/networks/autostart/lxcfnet1.xml
%{_unitdir}/lxcf.service
%{_unitdir}/lxcf-sched.service
%{_sysconfdir}/systemd/system/multi-user.target.wants/lxcf.service
%{_sysconfdir}/systemd/system/multi-user.target.wants/lxcf-sched.service
%{_var}/lib/libvirt/network/lxcfnet1.xml

%doc %attr(-,root,root)
%{_datadir}/man/man1/lxcf.1.gz
%{_datadir}/doc/lxcf-%{version}/README
%{_datadir}/doc/lxcf-%{version}/COPYING
%{_datadir}/doc/lxcf-%{version}/ChangeLog
%{_datadir}/doc/lxcf-%{version}/AUTHORS
%{_datadir}/doc/lxcf-%{version}/example/README
%{_datadir}/doc/lxcf-%{version}/example/HA10
%{_datadir}/doc/lxcf-%{version}/example/ops-script

%changelog 
* Tue Apr 15 2014 NIWA Hideyuki <niwa.hideyuki@jp.fujitsu.com> - 0.5-1  
- Correction of document related to batch queue 

* Sat Apr 12 2014 NIWA Hideyuki <niwa.hideyuki@jp.fujitsu.com> - 0.5-1  
- The bug to which the json file cannot be read with sysgen -c is corrected.

* Thu Apr 10 2014 Yasunori Goto <y-goto@jp.fujitsu.com> - 0.5-1
- Make natural expression for lxcf-start

* Thu Apr 10 2014 Ken ICHIKAWA <ichikawa.ken@jp.fujitsu.com> - 0.5-1  
- Support writing into SysV IPC related parameters

* Thu Apr 10 2014 TAMUKI Shoichi <tamuki@linet.gr.jp> - 0.5-1  
- Fix the rule in Makefile

* Wed Apr 09 2014 Ken ICHIKAWA <ichikawa.ken@jp.fujitsu.com> - 0.5-1  
- Specify absolute path for virsh

* Tue Apr 08 2014 NIWA Hideyuki <niwa.hideyuki@jp.fujitsu.com> - 0.5-1  
- /usr/lib/lxcf is moved to /usr/lib64/lxcf.

* Wed Apr 05 2014 MUNEDA Takahiro <mux003@gmail.com> - 0.5-1  
- Cleanup lxf-* python scripts

