#!/bin/sh

LXC_VERSION=$(grep "^VERSION" ../Makefile | sed -e s'/VERSION=//')

rm -rf SOURCES/*

cd ../../
rm -f lxcf-"$LXC_VERSION".tar.gz
mv lxcf lxcf-"$LXC_VERSION"
tar czf lxcf-"$LXC_VERSION".tar.gz lxcf-"$LXC_VERSION"
mv lxcf-"$LXC_VERSION" lxcf

cp lxcf-"$LXC_VERSION".tar.gz lxcf/package/SOURCES

cd lxcf/package/SOURCES
tar xzf lxcf-"$LXC_VERSION".tar.gz

cd ..
cp SOURCES/lxcf-*/lxcf.spec SPECS/lxcf.spec

rpmbuild -v -ba --clean SPECS/lxcf.spec
