#!/usr/bin/python
#-*- coding:utf-8 -*-

# LXCF - LXC Facility
# Copyright (C) 2014 FUJITSU LIMITED

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

#
# A scripts for creating LXC domain in which some daemons are running.
# running systemd, rsyslog, sshd in a container.
#

import sys, os, datetime, cgi, StringIO, commands
from wsgiref import util, simple_server
from xml.sax import saxutils
import hashlib

# sanity check
def sanity_check(parm):
    for c in parm:
        if c.isdigit() or c.isalpha() or (c == '-') or \
		(c == '_') or (c == ' ') or (c == ',') or \
                (c == '.') or (c == ':') or (c == '/') :
            continue
        else:
            return False
    return True

# Conversion of character string
def conv_char(str):
    s = ""
    for c in str:
        if (c == '"'):
            c = '&quot;'
        elif (c == '&'):
            c = '&amp;'
        elif (c == '<'):
            c = '&lt;'
        elif (c == '>'):
            c = '&gt;'
        s = s + c
    return s

# check a password
def check_passwd(newpasswd):
    try:
        with open('/etc/lxcf/passwd/api-passwd', 'r') as f:
            passwd = f.read().strip()
        f.close()
    except:
        passwd = hashlib.sha512("").hexdigest()+"  -"
        try:
            os.makedir('/etc/lxcf/passwd/', 700)
            with open('/etc/lxcf/passwd/api-passwd', 'r') as f:
                f.write(passwd)
            f.close()
        except:
            pass

    newpasswd_hash = hashlib.sha512(newpasswd).hexdigest()+"  -"

    if (newpasswd_hash == passwd):
        return True
    else:
        return False


# API common class
class api_common(object):
    def __init__(self, callcmd):
        self.messages = "no operation"
        self.status = 0
        self.callcmd = callcmd

    def __call__(self, environ, start_response):
        method = environ['REQUEST_METHOD']
        try:
            if method == 'GET':
                return self.get_response(environ, start_response)
            elif method == 'POST':
                return self.post_response(environ, start_response)
            else:
                start_response('501 Not Implemented', [('Content-type', 'text/plain')])
                return 'Not Implemented'
        except:
            return self.common_response(environ, start_response, 1, "stop")

    # common respose of html
    def common_response(self, environ, start_response, status, messages):
        self.status = status
        self.messages = messages

        fp = StringIO.StringIO()

        fp.write('''<html>
<head><title>LXCF API</title>
<meta http-equiv="Content-type" content="text/html; charset=utf-8">
</head>
<body>
<pre>
''')
        fp.write("status="+str(self.status)+"\n")
        fp.write(conv_char(self.messages)+"\n")

        fp.write('''</pre>\n<HR><form action="%s" method="POST" AcceptEncoding="utf-8">
<dl>
<dt>password</dt>
<dd><input type="password" name="password" value=""/></dd>
</dl>
<input type="submit" name="save" value="Execution" />
</form></body></html>''' % util.request_uri(environ))

        fp.seek(0)
        start_response('200 OK', [('Content-type', 'text/html; charset=utf-8')])
        return fp

    def get_response(self, environ, start_response):
        script_name = environ['SCRIPT_NAME']
        path_info = script_name+environ['PATH_INFO']
	cmdline=path_info.split("/")
        cmdstr = ""
        for str in cmdline:
            cmdstr = cmdstr + " " + str
        return self.common_response(environ, start_response, 0, cmdstr)

    def post_response(self, environ, start_response):
	self.status = 0
	self.messages = "no operation"
        inpt = environ['wsgi.input']
        length = int(environ.get('CONTENT_LENGTH', 0))

        query = dict(cgi.parse_qsl(inpt.read(length)))

	try:
            password = query['password']
        except:
            password = ""

        path_info = environ['PATH_INFO']

	cmdline=path_info.split("/")
        cmd = self.callcmd(cmdline)

        if (check_passwd(password)):
            if (sanity_check(cmd)):
                # exec command
                check = commands.getstatusoutput("/usr/sbin/lxcf "+cmd)
            else:
                check = (255, "error: sanity error ... "+cmd)
        else:
            check = (2, "Password is not corresponding. ")

        self.status = check[0] >> 8
        self.messages = check[1]

        fp = StringIO.StringIO()

        fp.write('''<html>
<head><title>LXCF API</title>
<meta http-equiv="Content-type" content="text/html; charset=utf-8">
</head>
<body>
<pre>
''')
        fp.write("status="+str(self.status)+"\n")
        fp.write(conv_char(self.messages)+"\n")
        self.status = 0
	self.messages = "no operation"

        fp.write('''</pre>\n<HR><form action="%s" method="POST" AcceptEncoding="utf-8">
<dl>
<dt>password</dt>
<dd><input type="password" name="password" value=""/></dd>
</dl>
<input type="submit" name="save" value="Execution" />
</form></body></html>''' % util.request_uri(environ))

        fp.seek(0)

        start_response('200 OK', [('Content-type', 'text/html; charset=utf-8')])

        return fp


# API: autostart
def call_autostart(cmdline):
    cmdstr = "autostart "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_autostart(api_common):
    def __init__(self, callcmd):
        super(api_autostart, self).__init__(callcmd)

# API: autostart-n
def call_autostart_n(cmdline):
    cmdstr = "autostart-n "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_autostart_n(api_common):
    def __init__(self, callcmd):
        super(api_autostart_n, self).__init__(callcmd)

# API: blkio_r
def call_blkio_r(cmdline):
    cmdstr = "blkio_r "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_blkio_r(api_common):
    def __init__(self, callcmd):
        super(api_blkio_r, self).__init__(callcmd)

# API: blkio_w
def call_blkio_w(cmdline):
    cmdstr = "blkio_w "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_blkio_w(api_common):
    def __init__(self, callcmd):
        super(api_blkio_w, self).__init__(callcmd)

# API: blkiops_r
def call_blkiops_r(cmdline):
    cmdstr = "blkiops_r "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_blkiops_r(api_common):
    def __init__(self, callcmd):
        super(api_blkiops_r, self).__init__(callcmd)


# API: blkiops_w
def call_blkiops_w(cmdline):
    cmdstr = "blkiops_w "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_blkiops_w(api_common):
    def __init__(self, callcmd):
        super(api_blkiops_w, self).__init__(callcmd)

# API: clone
def call_clone(cmdline):
    cmdstr = "clone "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_clone(api_common):
    def __init__(self, callcmd):
        super(api_clone, self).__init__(callcmd)


# API: clone-n
def call_clone_n(cmdline):
    cmdstr = "clone-n "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_clone_n(api_common):
    def __init__(self, callcmd):
        super(api_clone_n, self).__init__(callcmd)

# API: cpun
def call_cpun(cmdline):
    cmdstr = "cpun "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_cpun(api_common):
    def __init__(self, callcmd):
        super(api_cpun, self).__init__(callcmd)

# API: cpurate
def call_cpurate(cmdline):
    cmdstr = "cpurate "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_cpurate(api_common):
    def __init__(self, callcmd):
        super(api_cpurate, self).__init__(callcmd)



# API: erase
def call_erase(cmdline):
    cmdstr = "erase"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_erase(api_common):
    def __init__(self, callcmd):
        super(api_erase, self).__init__(callcmd)


# API: erase-n
def call_erase_n(cmdline):
    cmdstr = "erase-n"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_erase_n(api_common):
    def __init__(self, callcmd):
        super(api_erase_n, self).__init__(callcmd)


# API: export-docker
def call_export_docker(cmdline):
    cmdstr = "export-docker"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_export_docker(api_common):
    def __init__(self, callcmd):
        super(api_export_docker, self).__init__(callcmd)


# API: helpcmd
def call_helpcmd(cmdline):
    cmdstr = "helpcmd"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_helpcmd(api_common):
    def __init__(self, callcmd):
        super(api_helpcmd, self).__init__(callcmd)


# API: list
def call_list(cmdline):
    cmdstr = "list"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_list(api_common):
    def __init__(self, callcmd):
        super(api_list, self).__init__(callcmd)



# API: log
def call_log(cmdline):
    cmdstr = "log"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_log(api_common):
    def __init__(self, callcmd):
        super(api_log, self).__init__(callcmd)

# API: memlimit
def call_memlimit(cmdline):
    cmdstr = "memlimit"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_memlimit(api_common):
    def __init__(self, callcmd):
        super(api_memlimit, self).__init__(callcmd)


# API: memswlimit
def call_memswlimit(cmdline):
    cmdstr = "memswlimit"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_memswlimit(api_common):
    def __init__(self, callcmd):
        super(api_memswlimit, self).__init__(callcmd)


# API: net_cls
def call_net_cls(cmdline):
    cmdstr = "net_cls"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_net_cls(api_common):
    def __init__(self, callcmd):
        super(api_net_cls, self).__init__(callcmd)


# API: numa
def call_numa(cmdline):
    cmdstr = "numa"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_numa(api_common):
    def __init__(self, callcmd):
        super(api_numa, self).__init__(callcmd)


# API: q
def call_q(cmdline):
    cmdstr = "q"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_q(api_common):
    def __init__(self, callcmd):
        super(api_q, self).__init__(callcmd)


# API: queue
def call_queue(cmdline):
    cmdstr = "queue"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_queue(api_common):
    def __init__(self, callcmd):
        super(api_queue, self).__init__(callcmd)


# API: reboot
def call_reboot(cmdline):
    cmdstr = "reboot"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_reboot(api_common):
    def __init__(self, callcmd):
        super(api_reboot, self).__init__(callcmd)


# API: rename
def call_rename(cmdline):
    cmdstr = "rename"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_rename(api_common):
    def __init__(self, callcmd):
        super(api_rename, self).__init__(callcmd)


# API: restore
def call_restore(cmdline):
    cmdstr = "restore"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_restore(api_common):
    def __init__(self, callcmd):
        super(api_restore, self).__init__(callcmd)


# API: resume
def call_resume(cmdline):
    cmdstr = "resume"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_resume(api_common):
    def __init__(self, callcmd):
        super(api_resume, self).__init__(callcmd)


# API: resume-n
def call_resume_n(cmdline):
    cmdstr = "resume-n"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_resume_n(api_common):
    def __init__(self, callcmd):
        super(api_resume_n, self).__init__(callcmd)


# API: set
def call_set(cmdline):
    cmdstr = "set"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_set(api_common):
    def __init__(self, callcmd):
        super(api_set, self).__init__(callcmd)


# API: set-n
def call_set_n(cmdline):
    cmdstr = "set-n"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_set_n(api_common):
    def __init__(self, callcmd):
        super(api_set_n, self).__init__(callcmd)


# API: show
def call_show(cmdline):
    cmdstr = "show"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_show(api_common):
    def __init__(self, callcmd):
        super(api_show, self).__init__(callcmd)

# API: snapshot
def call_snapshot(cmdline):
    cmdstr = "snapshot"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_snapshot(api_common):
    def __init__(self, callcmd):
        super(api_snapshot, self).__init__(callcmd)


# API: snapshot-list
def call_snapshot_list(cmdline):
    cmdstr = "snapshot-list"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_snapshot_list(api_common):
    def __init__(self, callcmd):
        super(api_snapshot_list, self).__init__(callcmd)


# API: snapshot-erase
def call_snapshot_erase(cmdline):
    cmdstr = "snapshot-erase"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_snapshot_erase(api_common):
    def __init__(self, callcmd):
        super(api_snapshot_erase, self).__init__(callcmd)


# API: snapshot-n
def call_snapshot_n(cmdline):
    cmdstr = "snapshot-n"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_snapshot_n(api_common):
    def __init__(self, callcmd):
        super(api_snapshot_n, self).__init__(callcmd)


# API: start
def call_start(cmdline):
    cmdstr = "start "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_start(api_common):
    def __init__(self, callcmd):
        super(api_start, self).__init__(callcmd)

# API: start-n
def call_start_n(cmdline):
    cmdstr = "start-n "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_start_n(api_common):
    def __init__(self, callcmd):
        super(api_start_n, self).__init__(callcmd)


# API: stop
def call_stop(cmdline):
    cmdstr = "stop "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_stop(api_common):
    def __init__(self, callcmd):
        super(api_stop, self).__init__(callcmd)


# API: stop-n
def call_stop_n(cmdline):
    cmdstr = "stop-n "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_stop_n(api_common):
    def __init__(self, callcmd):
        super(api_stop_n, self).__init__(callcmd)


# API: submit
def call_submit(cmdline):
    cmdstr = "submit"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_submit(api_common):
    def __init__(self, callcmd):
        super(api_submit, self).__init__(callcmd)


# API: suspend
def call_suspend(cmdline):
    cmdstr = "suspend"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_suspend(api_common):
    def __init__(self, callcmd):
        super(api_suspend, self).__init__(callcmd)


# API: suspend-n
def call_suspend_n(cmdline):
    cmdstr = "suspend-n"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_suspend_n(api_common):
    def __init__(self, callcmd):
        super(api_suspend_n, self).__init__(callcmd)


# API: sysgen
def call_sysgen(cmdline):
    cmdstr = "sysgen"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_sysgen(api_common):
    def __init__(self, callcmd):
        super(api_sysgen, self).__init__(callcmd)


# API: sysgen-n
def call_sysgen_n(cmdline):
    cmdstr = "sysgen-n"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_sysgen_n(api_common):
    def __init__(self, callcmd):
        super(api_sysgen_n, self).__init__(callcmd)


# API: version
def call_version(cmdline):
    cmdstr = "version"
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_version(api_common):
    def __init__(self, callcmd):
        super(api_version, self).__init__(callcmd)


# API: snapshot-pull-data from repository
class api_snapshot_pull_data(api_common):
    def __init__(self):
        self.messages = "no operation"
        self.status = 0

    def post_response(self, environ, start_response):
	self.status = 0
	self.messages = "no operation"
        errorflg = 0

        inpt = environ['wsgi.input']
        length = int(environ.get('CONTENT_LENGTH', 0))

        query = dict(cgi.parse_qsl(inpt.read(length)))

	try:
            password = query['password']
        except:
            password = ""

        path_info = environ['PATH_INFO']

	cmdline=path_info.split("/")

        if (len(cmdline) != 2) :
            errorflg = 1
            result = "error: argument is mistaken."
            check = (1, "error: argument is mistaken.")
        elif (check_passwd(password)):
            if (sanity_check(cmdline[1])):
                check = (0, "OK snapshot-pull-data "+cmdline[1])
            else:
                errorflg = 1
                check = (255, "error: sanity error ... "+cmdline[1])
        else:
            errorflg = 1
            check = (1, "Password is not corresponding. ")

        self.status = check[0]
        result = self.messages

        file_name = cmdline[1]
        file_path = "/opt/lxcf_rep/"+file_name

        if (not sanity_check(file_path)):
            errorflg = 1
            result = "error: sanity error ... "+file_path
        elif os.path.exists(file_path):
            file_size = str(os.path.getsize(file_path))
        else:
            errorflg = 1
            result = "error: file does not exist."

        if (errorflg != 0):
           return self.common_response(environ, start_response, errorflg, result)
        
        try:
           fp = open(file_path,'rb')
           self.status = 0
           self.messages = "snapshot-pull-data succeeded. "
           start_response('200 OK', [('Content-Disposition', \
                'inline; filename="' + file_name + '"'), \
                ('Content-Length', file_size), \
                ('Content-type', 'application/octet-stream')])
           return fp
        except:
           errorflg = 1
           result = "error: file does not open."
           return self.common_response(environ, start_response, errorflg, result)


# API: snapshot-pull
def call_snapshot_pull(cmdline):
    cmdstr = "snapshot-pull -d "
    for str in cmdline:
        cmdstr = cmdstr + " " + str
    return cmdstr

class api_snapshot_pull(api_common):
    def __init__(self, callcmd):
        super(api_snapshot_pull, self).__init__(callcmd)


