/*
 *  m2m_caster.c:
 *     pthread(POSIX thread) routines.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */


typedef struct m2m_dvddesc_t {
  m2m_descripter_t desc;
  struct m2m_ifo_s *ifo;
  off64_t title_start;
  int n_pgci_cells;
  int title_set;
  int title;
  int chapter;
  int pgci_cell_index;
  ifo_cell_addr_t *cells;
  ifo_cell_addr_t *last_cell;
  ifo_pgci_cell_addr_t *pgci_cells;
  u_char chain_info_low;
  char name[32];
} m2m_dvddesc_t;

typedef struct m2m_ifo_s {
  char *  path;
  int     fd;
  off64_t pos; // is fgetpos()
  ifo_t **ifo_s;
  ifo_cell_addr_t *current_cell;
  int     current_title_set;
  int     nchapters;
  m2m_dvddesc_t *chapters;
#ifdef USE_css_auth
  unsigned char title_key[5];
#endif
} m2m_ifo_t;

