/*
 *  m2m_caster.c:
 *     pthread(POSIX thread) routines.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */


typedef struct m2m_desctipter_s {
  off64_t st;  // offset on desc
  off64_t ed;
  int type; /* 0=file,1=VOB,2=stdin,3=net */
  int (*read)( struct m2m_desctipter_s *instance,uint8_t buf[],int * size );
  int (*seek)( struct m2m_desctipter_s *instance,off64_t  );
  void (*close)( struct m2m_desctipter_s *instance );
  void (*eject)( struct m2m_desctipter_s *instance );
} m2m_descripter_t;

typedef struct m2m_filedesc_s {
  m2m_descripter_t desc;
  off64_t pos; // is fgetpos()
  int fd;
} m2m_filedesc_t;

