/*
 *  m2m_negosiate.c:
 *     pthread(POSIX thread) routines.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#ifndef _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <stdint.h>
#include <pthread.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <unistd.h>
#include "m2m.h"
#include "m2m_descripter.h"
#include "m2m_playlist.h"
#include "m2m_command.h"

static int sd=-1;
static int pipe_in=-1;
static int pipe_out=-1;

static struct {
  char *cmd;
  int param_type; // 0=no,1=int,2=string
} cmds[]={
  {"HELLO NEW ID"          ,0},
  {"ADM GET LINSTENER LIST",0},
  {"GET LINSTENER LIST"    ,0},
  {"GET PLAYLIST"          ,0},
  {"GET CURRENT INFO"      ,0},
  {"JUMP TITLE"            ,2},
  {"START"                 ,0},
  {"PAUSE"                 ,0},
  {"ATTACH DVD"            ,2},
  {"DETTACH AND EJECT DVD" ,2},
  {"ADD PLAYLIST"          ,2},
  {"RMOVE PLAYLIST"        ,2},
  {"GET BRIGHTNESS"        ,0},
  {"SET BRIGHTNESS"        ,1},
  {"GET CONTRAST"          ,0},
  {"SET CONTRAST"          ,1},
  {"KILL LISTENER"         ,1},
  {"GET SERVERS"           ,0},
  {"FORWARD"               ,2},
};

inline void free_result( char ***result )
{
  if ( result && *result ){
    int i;
    for(i=0;(*result)[i];i++) if ( (*result)[i] ) free( (*result)[i] );
    free( *result );
    *result=NULL;
  }
}

inline int m2m_sendline(int in_desc,int out_desc,char *buf)
{
  int len=strlen(buf);
  if ( buf[len-1] != '\n' ){
    if ( buf[len-1] != '\r' ){
      strcat(buf,"\r\n");
    }else{
      strcat(buf,"\n");
    }
  }
  if ( in_desc == out_desc ){
    return send(out_desc,buf,strlen(buf),0);
  }else{
    return write(out_desc,buf,strlen(buf));
  }
}

static inline int recvline(int in_desc,int out_desc,char **ret)
{
  int n;
  int i;
  char buf[2048];
  *ret=NULL;
  for( i=0 ; i<sizeof(buf) ;i++ )
  {
    if ( in_desc == out_desc ){
      n=recv(in_desc,buf+i,1,0);
    }else{
      n=read(in_desc,buf+i,1);
    }
    if ( n == -1 ){ perror("recv"); return -1; }
    if ( buf[i] == '\n' ) break;
  }
  buf[(i<sizeof(buf))?i:(sizeof(buf)-1)]=0x0;
  for( n=i-1 ; n>=0 ; n-- ){
    if ( buf[n] == '\r' || buf[n] == '\n'
      || buf[n] == '\t' || buf[n] == ' '){
      buf[n]=0x0;
    }else{
      break;
    }
  }
  *ret=(char *)malloc( (strlen(buf)+1)*sizeof(char) );
  strcpy(*ret,buf);
  return 0;
}

static inline int recvlines(int in_desc,int out_desc,char ***buf)
{
  int i;
  int status ;
  for(i=0;;i++){
    *buf=(char **)realloc(*buf,(i+1)*sizeof(char *) );
    status = recvline(in_desc,out_desc,(*buf)+i );
    if ( status != 0 ){
      if ( (*buf)[i] ) free( (*buf)[i] );
      (*buf)[i]=NULL;
      free_result(buf);
      return -1;
    }
    if ( strncmp( (*buf)[i] ,"END",3) == 0 ){
      if ( (*buf)[i] ) free( (*buf)[i] );
      (*buf)[i] =NULL;
      break;
    }
  }
  return i;
}

int m2m_attach_command (int in_desc,int out_desc,int *id,int *command ,int *int_param,char **str_param )
{
  char *buf=NULL;
  int status = recvline(in_desc,out_desc,&buf );
  for( *command=0 ; *command <= M2M_CMD_FORWARD  ; (*command)++ ){
    if(strncmp(buf,cmds[*command].cmd,strlen(cmds[*command].cmd))) continue;
    switch(cmds[*command].param_type){
    case 0:
      sscanf(buf+strlen(cmds[*command].cmd),"%d",id );
      *int_param=-1;
      *str_param=NULL;
      break;
    case 1:
      sscanf(buf+strlen(cmds[*command].cmd),"%d %d",id,int_param );
      *str_param=NULL;
      break;
    case 2:
      *str_param =malloc(strlen(buf)*sizeof(char));
      sscanf(buf+strlen(cmds[*command].cmd),"%d %s",id,*str_param );
      *int_param=-1;
      break;
    default:
      return -3;
    }
    break;
  }
  if ( buf ) free(buf);
  if ( *command <= M2M_CMD_FORWARD ){
    return 0;
  }else{
fprintf(stderr,"not founf command\n" );
    return -1;
  }
}

int request_command(int in_desc,int out_desc,int id,int command ,void *param, char ***result_v )
{
  int status;
  char buf[2048];
  if ( result_v == NULL ) return -1;
  *result_v = NULL ;
  if ( command < 0 || command > M2M_CMD_FORWARD )
    return -2;
  switch( cmds[command].param_type ){
  case 0:
    sprintf( buf,"%s %d",cmds[command].cmd,id );
    break;
  case 1:
    sprintf( buf,"%s %d %d",cmds[command].cmd,id,param );
    break;
  case 2:
    snprintf( buf,sizeof(buf),"%s %d %s",cmds[command].cmd,id,param );
    break;
  default:
    return -3;
  }
  status = m2m_sendline(in_desc,out_desc,buf);
  if ( status < 0 ){
fprintf(stderr,"reauest_command:m2m_sendline err.%d\n",status);
    return status;
  }
  return recvlines( in_desc,out_desc, result_v);
}

int send_hello_from_listener( int in_desc,int out_desc,int tno,char *dev,int is_autostart )
{
  char command[2048];
  char **result;
  int status;
  int id;
  status= request_command(in_desc,out_desc,0,M2M_CMD_HELLO_NEW_ID,NULL,&result);
  if ( status < 0 ) return status;
  if ( status < 1 || strncmp(result[0],"OK ",3) != 0 ){
    fprintf(stderr,"send_hello_from_listener:HELLO status=%d[%s]\n",status,result[0]);
    free_result( &result );
    return -1;
  }
  id=atol(result[0]+3);
  free_result( &result );
  if ( dev ){
    status= request_command(in_desc,out_desc,id,M2M_CMD_ATTACH_DVD,dev,&result);
    free_result( &result );
  }
  if ( tno > 0 ){
    status= request_command(in_desc,out_desc,id,M2M_CMD_JUMP_TITLE,(void *)tno,&result);
    free_result( &result );
  }
  status= request_command(in_desc,out_desc,id,is_autostart?M2M_CMD_START:M2M_CMD_PAUSE,NULL,&result);
  free_result( &result );
  return 0;
}

