package map.map25000.cell;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import util.Log;

import map.data.City;
import map.map25000.Map25000Factory;
import map.map25000.Map25000Storage;

/**
 * セルメソッド用のファイルを生成します。
 * @author Masayasu Fujiwara
 */
public class CellPreprocessing {
	private final String ENCODING = "SJIS";
	private File cityList = new File("./data/city.csv");
	
	public static void main(String[] args) throws FileNotFoundException, IOException {
		// ディレクトリ指定
		final String dir = "../data25k/";
		final String cellCache = "./data/";
		final String prefecture = "./data/prefecture.csv";
		final int cellSize = 250000;
		new CellPreprocessing(dir, cellCache, prefecture, cellSize);
//		new CellPreprocessing().delete(cellCache);
	}

	public CellPreprocessing() {
		
	}

	/**
	 * 
	 * @param dir
	 * @param cellCache 
	 * @param list
	 * @param cellSize
	 * @throws IOException
	 */
	public CellPreprocessing(String dir, String cellCache, String list, int cellSize) throws IOException {
		File celldir = new File(dir + "cell");
		if(!celldir.isDirectory()) {
			celldir.mkdirs();
		}
		Map25000Factory factory = new Map25000Factory(new Map25000Storage(dir, list, null));

		BufferedWriter pbo = null;
		try {
			pbo = new BufferedWriter(new FileWriter(cellCache + "prefecture.cell", false));

			for (int i = 1; i <= 47; i++) {

				final String[] codes = this.getCityCode(i);
				
				City[] maps = new City[codes.length];
				// 外接長方形
				int n = Integer.MIN_VALUE;
				int s = Integer.MAX_VALUE;
				int w = Integer.MAX_VALUE;
				int e = Integer.MIN_VALUE;
	
				for(int j = 0; j < codes.length; j++) {
	
					maps[j] = factory.preproduct(Integer.parseInt(codes[j]));
	
					Rectangle area = maps[j].getArea();
					// 西
					if(area.x < w) {
						w = area.x;
					}
					// 東
					if(area.x + area.width > e) {
						e = area.x + area.width;
					}
					// 南
					if(area.y < s) {
						s = area.y;
					}
					// 北
					if(area.y + area.height > n) {
						n = area.y + area.height;
					}
				}
				String code = City.prefectureFormat(i);

				Log.out(this, "code : " + code);
				Log.out(this, e + ", "+ w + ", "+ s + ", "+ n);
				Log.out(this, w + ", "+ s + ", "+ (e - w) +", "+ (n - s));

//				Prefecture prefecure = new Prefecture(i, w, s, (e - w), (n - s));
				pbo.write(w + ","+ s + "," + (e - w) +","+ (n-s));
				pbo.newLine();
				pbo.flush();
				
				Log.out(this, code +","+ w + ","+ s + "," + (e - w) +","+ (n-s));
				
				int cellMinX = w - w % cellSize;
				int cellMinY = s - s % cellSize;
				int cellMaxX = e - e % cellSize + cellSize;
				int cellMaxY = n - n % cellSize + cellSize;
				
				BufferedWriter bo = null;
				try {
					bo = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(cellCache + code + File.separatorChar + "city.cell"), this.ENCODING));
					int value1 = (cellMinX / cellSize);
					int value2 = (cellMinY / cellSize);
					int value3 = (cellMaxY / cellSize - cellMinY / cellSize);
					int value4 = (cellMaxX / cellSize - cellMinX / cellSize);
					bo.write(value1 + "," + value2 + "," + cellSize + "," + value4 + "," + value3);
					bo.newLine();
					bo.flush();
					
					for(int cellX = cellMinX; cellX < cellMaxX; cellX += cellSize) {
						for(int cellY = cellMinY; cellY < cellMaxY; cellY += cellSize) {
			
							List<City> tmp = new ArrayList<City>();
							for(City map : maps) {
								if(new Rectangle(cellX, cellY, cellSize, cellSize).intersects(map.getArea())) {
									tmp.add(map);
								}
							}
							Iterator<City> itr = tmp.iterator();
							if (itr.hasNext()) {
								City city = itr.next();
								bo.write(Integer.toString(city.getCode()));
							}
							while (itr.hasNext()) {
								City city = itr.next();
								bo.write(',' + Integer.toString(city.getCode()));
							}
							bo.newLine();
							bo.flush();
						}
					}
				} finally {
					if (bo != null) {
						bo.close();
					}
				}
			}
		} finally {
			if (pbo != null) {
				pbo.close();
			}
		}
	}

	/**
	 * 都道府県番号に対応する市町村番号の取得
	 * @param code 都道府県番号
	 * @return 市区町村番号配列
	 * @throws IOException 
	 */
	public String[] getCityCode(int code) throws IOException {

		final List<String> list = new ArrayList<String>();
		BufferedReader bi = null;
		try {
			bi = new BufferedReader(new InputStreamReader(new FileInputStream(this.cityList), this.ENCODING));
			while (bi.ready()) {
				String line = bi.readLine();
				String[] data = line.split(",");
				if (data[1].startsWith(City.prefectureFormat(code))) {
					list.add(data[1]);
				}
			}
		} finally {
			if (bi != null) {
				bi.close();
			}
		}
		return list.toArray(new String[]{});
	}

	public void delete(String cache) throws IOException {
		for (int i = 1; i <= 47; i++) {
			String code = City.prefectureFormat(i);
			File file = new File(cache + code + File.separatorChar + "city.cell");
			Log.out(this, "delete " + file.getCanonicalPath());
			file.delete();
		}
	}
}
