package util;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * 簡易に一般化したFileFilter
 * @author fujiwara
 *
 */
public class GeneralFileFilter extends FileFilter {

	/**
	 * 許可する拡張子
	 */
	private final String[] extensions;
	
	/**
	 * FileFilterの説明
	 */
	private final String description;


	/**
	 * 許可する拡張子を与えてインスタンスを生成する
	 * @param extension
	 */
	public GeneralFileFilter(String extension) {
		this(new String[]{extension}, extension);
	}

	/**
	 * 許可する拡張子を与えてインスタンスを生成する
	 * @param extension
	 * @param description 
	 */
	public GeneralFileFilter(String extension, String description) {
		this(new String[]{extension}, description);
	}

	/**
	 * 許可する拡張子を与えてインスタンスを生成する
	 * 
	 * @param extensions 許可する拡張子
	 * @param description FileFilterの説明
	 */
	public GeneralFileFilter(String[] extensions, String description) {
		this.extensions = extensions;
		this.description = description;
	}

	@Override
	public boolean accept(File file) {
		if (file.isDirectory()) {
			return true;
		}
		String path = file.getPath();
		String format = path.substring(path.lastIndexOf('.') + 1, path.length());
		for (String extension : this.extensions) {
			if (extension.compareToIgnoreCase(format) == 0) {
				return true;
			}
		}
		return false;
	}

	/**
	 * 標準の拡張子を返します
	 * @return 標準の拡張子
	 */
	public String getDefaultExtension() {
		return this.extensions[0];
	}
	@Override
	public String getDescription() {
		return this.description;
	}
}
