package util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

import map.store.Store;

/**
 * プラグインをロードするためのクラス。
 * @author Masayasu Fujiwara
 */
public class PluginLoader {

	/**
	 * クラスパスを追加する。
	 * @param url URL 追加するパッケージのあるのURL
	 * @throws NoSuchMethodException 
	 * @throws SecurityException
	 * @throws InvocationTargetException 
	 * @throws IllegalAccessException 
	 * @throws IllegalArgumentException 
	 */
	private static void addClassPath(URL url) throws SecurityException,
			NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {

		// URLClassLoaderのprotectedメソッドaddURLを取得する
		Method method = URLClassLoader.class.getDeclaredMethod("addURL", new Class[] { URL.class });

		// アクセス可能に変更する
		method.setAccessible(true);

		// システムクラスローダーをURLClassLoaderと仮定し、addURLをコールする
		method.invoke(ClassLoader.getSystemClassLoader(), new Object[] { url });
	}

	/**
	 * 店舗情報取得のためのプラグインをロードします。
	 * @param path プラグインのあるパス
	 * @param cacheDir 店舗情報のキャッシュディレクトリ
	 * @return 店舗情報のリスト
	 */
	public static List<Store> loadStorePlugin(String path, String cacheDir) {
		List<Store> list = new ArrayList<Store>();
		File dir = new File(path);
		try {
			PluginLoader.addClassPath(dir.toURI().toURL());
			for (File file : dir.listFiles()) {
				String name = file.getName();
				if (name.endsWith("Plugin.class")) {
					String title = name.substring(0, name.length() - 6);
					Store store = (Store) Class.forName(title).newInstance();
					store.setCacheDirectory(cacheDir);
					list.add(store);
					Log.out(PluginLoader.class, "loaded "+ store.getClass().getName());
				}
			}
		} catch (Throwable e) {
			Log.err(PluginLoader.class, e);	
		}
		return list;
	}
}
