# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1904
## - Date: 2019-05-07
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3.1904) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

from gluon.html import *
import re
import json
import urllib.request


def __get_canvas(MR_CONF, parent, d_d, array):
    """
    d_d: dict
    array: files
    """
    for i,r in enumerate(array):

        if r:
            d_canvas = {"@type": "sc:Canvas"}
            parent.append(d_canvas)

            canves_id = "%s/default/iiif/%s/%s/canvas/image%s" % (MR_CONF['SERVER_URL'],r['role'],str(r['subid']),str(i+1))

            d_canvas['@id'] = canves_id
            d_canvas['label'] = r['title']

            if 'area' in d_d:
                d_canvas['width'] = d_d['area']['value'][2]
                d_canvas['height'] = d_d['area']['value'][3]
            else:
                d_canvas['width'] = r['width']
                d_canvas['height'] = r['height']

            # get default @id
            default_id = ''
            if ('format' in r) and (r['format'] in ('tif','jp2')):
                default_id = '%s%s.%s/full/full/0/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'])
            else:
            #elif ('format' in r) and (r['format'] in ('jpg')):
                default_id = "%s/resources/%s.%s" % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(r['href'][:-1]),r['format'])

            # get image @id
            resource_id = ''
            if ('format' in r) and (r['format'] in ('tif','jp2')):
                if 'area' in d_d:
                    resource_id = '%s%s.%s/%s/full/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'],','.join([str(v) for v in d_d['area']['value']]),int(d_d['rotation']['value']))
                else:
                    resource_id = '%s%s.%s/full/full/0/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'])
            elif ('format' in r) and (r['format'] in ('fzp','fzp3','dzi','zoomify')):
                #resource_id = "%s/resources/%s" % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(r['snapimage']))
                resource_id = "%s/resources/%s.%s" % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(r['href'][:-1]),r['format'])
            else:
            #elif ('format' in r) and (r['format'] in ('jpg')):
                resource_id = "%s/resources/%s.%s" % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(r['href'][:-1]),r['format'])

            # get thumbnail image @id
            thumbnail_id = ''
            if ('format' in r) and (r['format'] in ('tif','jp2')):
                if 'area' in d_d:
                    thumbnail_id = '%s%s.%s/%s/%d,/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'],','.join([str(v) for v in d_d['area']['value']]),MR_CONF['IMG_THUMBNAIL_SIZE'],int(d_d['rotation']['value']))
                elif r['thumbnail'] is not None:
                    thumbnail_id = "%s/resources/%s" % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(r['thumbnail']))
                else:
                    thumbnail_id = '%s%s.%s/full/%d,/0/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['format'],MR_CONF['IMG_THUMBNAIL_SIZE'])

            elif ('format' in r) and (r['format'] in ('fzp','fzp3','dzi','zoomify')):
                thumbnail_id = "%s/resources/%s" % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(r['thumbnail']))


            elif ('format' in r) and (r['format'] in ('pdf')):
                thumbnail_id = "%s/resources/%s" % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(r['thumbnail']))

            elif ('format' in r) and (r['format'] in ('jpg')):
                thumbnail_id = "%s/resources/%s" % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(r['thumbnail']))

            # Thumbnail
            d_canvas['thumbnail'] = { "@type": "dctypes:Image"
                        ,"@id": thumbnail_id
                        ,"format": "image/jpeg"
                        }
            # Images
            d_canvas['images'] = []
            if r:
                d_image = {"@type": "oa:Annotation"
                        ,"motivation": "sc:painting"
                        ,"on": canves_id
                        }
                d_canvas['images'].append(d_image)

                # Resource
                d_resource = {"@type": "dctypes:Image"
                        ,"@id": resource_id
                        ,"format": "image/jpeg"
                        }
                d_image['resource'] = d_resource

                if ('format' in r) and (r['format'] in ('tif','jp2')):

                    if 'area' in d_d:
                        # default
                        d_default = {"@type": "dctypes:Image"
                            ,"@id": default_id
                            }
                        d_resource['default'] = d_default

                        # Service
                        d_service = {"@context": "http://iiif.io/api/image/2/context.json"
                            ,"@id": '%s%s.%s' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['href'][-1])
                            }
                        d_default['service'] = d_service

                    else:
                        # Service
                        d_service = {"@context": "http://iiif.io/api/image/2/context.json"
                            ,"@id": '%s%s.%s' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(r['href'][:-1]),r['href'][-1])
                            }
                        d_resource['service'] = d_service

                if 'area' in d_d:
                    # Selector
                    d_selector = {
                        "@context": "http://iiif.io/api/presentation/2/context.json"
                        ,"@type": "iiif:ImageApiSelector"
                        ,"region": "%s" % ','.join([str(v) for v in d_d['area']['value']])
                        }
                    d_image['selector'] = d_selector

            # アノテーションの場合は補正
            if d_d['role'] == 'annote':
                file_subid = d_d['files'][0]['subid']
            else:
                file_subid = r['subid']

            # Annotation link
            d_canvas['otherContent'] = []
            d_annote = {"@type": "sc:AnnotationList"
                        ,"@id": "%s/default/iiif/file/%d/annotationlist.json" % (MR_CONF['SERVER_URL'], file_subid)
                        }
            if ('annotes' in r) and (len(r['annotes'])>0) and (d_d['role'] != 'annote') and (r['role'] == 'file'):
                d_canvas['otherContent'].append(d_annote)


def __get_iiif_manifest(MR_CONF,array):
    """
    Construction of IIIF Presentation API 2.1
    2018-11
    """
    # Context
    d_context = {
                    "@context": "http://iiif.io/api/presentation/2/context.json"
                    ,"@type": "sc:Manifest"
                    ,"@id": "%s/iiif/%s/manifest.json" % (MR_CONF['SERVER_URL'],'test')
                    ,"label": "test"
                    ,"sequences":[
                        {
                            "@type": "sc:Sequence"
                            ,"canvases": [
                                {
                                    "@type": "sc:Canvas"
                                }
                            ]
                        }
                    ]
                 }

    if len(array) == 1:

        d_d = array[0]

        l_d_metadata = []
        for ky in d_d:
            if ky and (not ky in ('description','title','keyset','subid','folders','files','thumbnails','annotes','ids','contains','role','area','data','rotation')):
                l_d_metadata.append(d_d[ky])

        if 'role' in d_d:
            if d_d['role'] == 'annote':
                d_context['@id'] = "%s/default/iiif/annote/%s/manifest.json" % (MR_CONF['SERVER_URL'],str(d_d['subid']))
            elif d_d['role'] == 'folder':
                d_context['@id'] = "%s/default/iiif/folder/%s/manifest.json" % (MR_CONF['SERVER_URL'],str(d_d['subid']))
            elif d_d['role'] == 'file':
                d_context['@id'] = "%s/default/iiif/file/%s/manifest.json" % (MR_CONF['SERVER_URL'],str(d_d['subid']))
            else:
                d_context['@id'] = "%s/default/iiif/resource/%s/manifest.json" % (MR_CONF['SERVER_URL'],str(d_d['subid']))
                pass
        else:
            d_context['@id'] = "%s/default/iiif/resource/%s/manifest.json" % (MR_CONF['SERVER_URL'],str(d_d['subid']))

        d_context['role'] = d_d['role']
        d_context['label'] = d_d['title']['value'] or ''
        d_context['description'] = d_d['description']['value'] or ''
        d_context['metadata'] = l_d_metadata

        # Sequences
        d_context['sequences'] = []

        if 'folders' in d_d:

            for i,r in enumerate(d_d['folders']):
                if r:
                    d_sequense = {"@type": "sc:Sequence"}
                    d_context['sequences'].append(d_sequense)

                    # Canvases
                    d_sequense['canvases'] = []

                    if 'files' in r:

                        __get_canvas(MR_CONF, d_sequense['canvases'], d_d, r['files'])

        if 'files' in d_d:

            d_sequense = {"@type": "sc:Sequence"}
            d_context['sequences'].append(d_sequense)

            # Canvases
            d_sequense['canvases'] = []

            __get_canvas(MR_CONF, d_sequense['canvases'], d_d, d_d['files'])

    return d_context


def __get_iiif_annotationlist(MR_CONF,array):
    """
    Construction of IIIF Presentation API 2.1
    2018-11
    """
    # Context
    d_context = {
                    "@context": "http://iiif.io/api/presentation/2/context.json"
                    ,"@type": "sc:AnnotationList"
                    ,"@id": "%s/iiif/%s/annotationlist.json" % (MR_CONF['SERVER_URL'],'test')
                    ,"resources":[
                        {
                            "@type": "oa:Annotation"
                            ,"motivation": "sc:painting"
                            ,"resource": [
                                {
                                    "@type": "cnt:ContentAsText"
                                    ,"chars": ""
                                    ,"format": "text/plain"
                                    ,"language": "ja"
                                }
                            ]
                            ,"on": {
                                "@type": "oa:SpecificResource"
                                ,"full": "%s/iiif/%s/canvas/image" % (MR_CONF['SERVER_URL'],'test')
                                ,"selector": {
                                    "@type": "oa:FragmentSelector"
                                    ,"value": "xywh=0,0,0,0"
                                }
                                ,"within": {
                                    "@id": "%s/iiif/%s/manifest.json" % (MR_CONF['SERVER_URL'],'test')
                                    ,"@type": "sc:Manifest"
                                }
                            }
                        }
                    ]
                 }

    if len(array) == 1:

        d_d = array[0]

        l_d_metadata = []
        for ky in d_d:
            if ky and (not ky in ('description','title','keyset','subid','files')):
                l_d_metadata.append(d_d[ky])

        d_context['@id'] = "%s/default/iiif/%s/%s/annotationlist.json" % (MR_CONF['SERVER_URL'],d_d['role'],str(d_d['subid']))

        d_manifest = "%s/default/iiif/%s/%s/manifest.json" % (MR_CONF['SERVER_URL'],d_d['role'],str(d_d['subid']))

        d_full = "%s/default/iiif/%s/%s/canvas/image1" % (MR_CONF['SERVER_URL'],d_d['role'],str(d_d['subid']))

        d_context['resources'] = []
        for i,r in enumerate(d_d['annotes']):
            if r['annotetype'] == 'area':
                continue

            if r:
                # Canvases
                d_annote = {
                    "@type": "oa:Annotation"
                    ,"motivation": "sc:painting"
                    ,"resource": {
                        "@type": "cnt:ContentAsText"
                        ,"chars": r['title'] or ''
                        ,"format": "text/plain"
                        ,"language": "ja"
                    }
                    ,"on": {
                        "@type": "oa:SpecificResource"
                        ,"full": d_full
                        ,"selector": {
                            "@type": "oa:FragmentSelector"
                            ,"value": "xywh=%s" % ','.join([str(v) for v in r['annotedata']])
                        }
                        ,"within": {
                            "@type": "sc:Manifest"
                            ,"@id": d_manifest
                        }
                    }
                }
                d_context['resources'].append(d_annote)

    return d_context
