# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1906r2
## - Date: 2019-06-10
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3.1906) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

import os
import io
import datetime
import re
import json
import urllib
from gluon.sanitizer import sanitize

mr_datahelper = local_import('mr_datahelper', reload=MR_CONF['RELOAD'])
mr_helper = local_import('mr_helper', reload=MR_CONF['RELOAD'])
mr_manifesthelper = local_import('mr_iiifmanifesthelper', reload=MR_CONF['RELOAD'])


# ========================================
# Main controllers
# 2018-11/2019-06
# ========================================

def index():
    """
    トップ
    2018-11/2019-06
    """
    # 引数（ページID）の取得
    pageid = 1  #デフォルト
    if len(request.args) > 0:
        pageid = request.args(0, cast=int) or 1

    # ページの内容（ページ・セクション）一覧
    # ページがpageidであるページセクション（複数）の取得
    da = mr_datahelper.d_d_page(dbm, pageid)

    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_d in da['array']:

        dom_section = TAG.section(
                        DIV(
                            *[P(mr_helper.__helper_br(v['value']),_class='') for v in d_d['description']]
                            ,_class='m-div-text'
                        )
                        ,_class='m-page-section m-index-section'
                    )
        dom_div.append(dom_section)

    # メニュー索引の作成
    dom_menu = __get_menu()

    return dict(linemenu=dom_menu, title=title, dom=dom_div)


def page():
    """
    ページ
    2018-11/2019-05
    """
    # 引数（ページID）の取得
    pageid = 1  #デフォルト
    if len(request.args) > 0:
        pageid = request.args(0, cast=int) or 1

    # ページ指定（内容＝セクション）一覧
    da = mr_datahelper.d_d_page(dbm, pageid)

    # ページがpageidであるページセクション（複数）の取得
    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_d in da['array']:

        dom_section = TAG.section(
                        *[H2(mr_helper.__helper_br(v['value'])) for v in d_d['title']]
                        ,DIV(
                            *[P(mr_helper.__helper_br(v['value']),_class='') for v in d_d['description']]
                            ,_class='m-div-text'
                        )
                        ,DIV(
                            SPAN(T(d_d['date'][0]['label']),': ',XML(d_d['date'][0].get('value','')) or XML('&mdash;'))
                            ,XML('&nbsp'),'|',XML('&nbsp;'),SPAN(T(d_d['creator'][0]['label']),': ',XML(d_d['creator'][0].get('value','')) or XML('&mdash;'))
                            ,_class='m-div-info'
                        )
                        ,_class='m-page-section'
                    )
        dom_div.append(dom_section)

    # サイドメニュー索引の作成
    dom_sidemenu = __get_sidemenu()

    return dict(sidemenu=dom_sidemenu, title=title, dom=dom_div)


def __form_search():
    """
    検索フォーム（最小）
    2018-11
    """
    form = FORM(
                DIV(
                    DIV(
                        INPUT(
                            _type='search'
                            ,_placeholder=T('Search words')
                            ,_name='q'
                            ,_class='form-control'
                        )
                        ,_class='col col-8'
                    )
                    ,DIV(
                        TAG.button(
                            I(_class='fa fa-search')
                            ,T('Search')
                            ,_type='submit'
                            ,_name='dosearch'
                            ,_class='btn btn-primary'
                        )
                        ,_class='col col-4'
                    )
                    ,_class='formgroup row m-search-box'
                )
            )

    return form


def items():
    """
    アイテム・リスト
    2018-11/2019-05
    """
    # 引数（コレクションID）の取得
    collid = 0  #デフォルト
    if len(request.args) > 0:
        collid = request.args(0, cast=int) or 0

    l_query = []

    form = __form_search()

    if form.accepts(request, session, keepvalues=True):
        #response.flash = T('form accepted')
        l_query = sanitize(form.vars.get('q')).split()

    elif form.errors:
        response.flash = T('form has errors')
    else:
        #response.flash = T('please fill the form')
        pass

    # コレクション指定リソース一覧
    #da = mr_datahelper.d_d_collection(dbm, collid, l_query)
    da = mr_datahelper.d_d_finder(dbm, collid, l_query)

    session.imgs = {}

    # コレクションがcollidであるリソース（複数）の取得
    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_d in da['array']:

        dom_items = TAG.dl(_class='col col-12')
        for ky in d_d['keyset']:
            if not ky in ['title','description']:
                if ky in d_d and d_d[ky]['value'] is not None:
                    dom_item1 = TAG.dt(d_d[ky].get('label',T('(Undefined)')))
                    dom_item2 = TAG.dd(d_d[ky].get('value',''))
                    dom_items.append(dom_item1)
                    dom_items.append(dom_item2)

        dom_resource = DIV(
                        DIV(
                            __image_ul_for_items(session, d_d)
                            ,_class='col'
                        )
                        ,DIV(
                            H4(A(d_d['title'].get('value','')
                                ,_href=URL('item',args=[d_d['subid']])
                                )
                            )
                            ,DIV(
                                P(mr_helper.__helper_br(d_d['description'].get('value',[''])),_class='col col-12')
                                ,dom_items
                                ,_class='row'
                            )
                            ,_class='col'
                        )
                        ,_class='row m-resource-block'
                    )

        dom_div.append(dom_resource)

    # サイドメニュー索引の作成
    dom_sidemenu = __get_sidemenu()

    return dict(sidemenu=dom_sidemenu, title=title, dom=dom_div, form=form)


def item():
    """
    リソース・アイテム
    2018-11/2019-05
    """
    # 引数（リソースID）の取得
    resourceid = 1  #デフォルト
    if len(request.args) > 0:
        resourceid = request.args(0, cast=int) or 1

    # リソース
    da = mr_datahelper.d_d_resource(dbm, resourceid)

    session.imgs = {}

    # リソースがresourceidであるリソースアイテム（複数）の取得
    dom_div = DIV(_class='m-content')

    title = da['title'] or T('Undefined')

    for d_d in da['array']:

        dom_resource = DIV(
                        H2(d_d['title'].get('value',''))
                        ,DIV(
                            P(mr_helper.__helper_br(d_d['description'].get('value','')),_class='col col-12')
                        )
                        ,__image_ul_for_eachitem(session, d_d, ['area'], True)
                        ,DIV(
                            TABLE(*[
                                TR(TD(d_d[ky]['label'], _class='m-label'),TD(mr_helper.__helper_br(d_d[ky].get('value','')))) for ky in d_d['keyset']
                                if (ky not in ('title','description')) and (ky in d_d) and (d_d[ky]['value'] is not None)
                            ],_class='col col-12')
                            ,_class='row'
                        )
                        ,DIV(
                            __get_dom_attribution_table(d_d)   # 外部Manifest対応
                            ,_class='row'
                        )
                        ,_class='m-resource-item'
                    )
        dom_div.append(dom_resource)

    # サイドメニュー索引の作成
    dom_sidemenu = __get_sidemenu()

    return dict(sidemenu=dom_sidemenu, title=title, dom=dom_div)


def viewer():
    """
    画像表示
    2018-11/2019-05
    """
    var_a_id = 0
    var_external = False

    var_target = tuple(request.args)
    (var_r_id,var_folder_id,var_f_id,var_a_id) = session.imgs[var_target]

    var_manifest = None
    var_f_manifest = ''

    var_folder = None
    var_name = None
    var_format = None

    var_on_annote = False

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            # IIIF Manifest
            if request.args[1]=='external':
                r_row = dbm.mr_resources[var_r_id]
                if r_row.mr_manifest_id:
                    var_manifest = r_row.mr_manifest_id
                else:
                    var_manifest = r_row.mr_manifest_link
                var_external = True
            else:
                var_manifest = '/'.join(request.args)
        else:
            var_folder = sanitize(request.args(0))
            var_name = sanitize(request.args(1))
            var_format = sanitize(request.args(2))
        if 'annote' in request.args:
            var_on_annote = True

    return dict(vmanifest=var_manifest, vfolder=var_folder, vname=var_name, vformat=var_format, preview=UL(), subview=UL(), infoview='', idset=session.imgs[var_target], external=var_external)


def viewer_mirador():
    """
    画像表示
    Mirador Viewer（Experimantal)
    2019-06
    """
    var_external = False

    var_manifest = None

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            var_manifest = '/'.join(request.args)

    return dict(vmanifest=var_manifest, external=var_external)


def viewer_lflt():
    """
    画像表示
    Leaflet IIIF Viewer（Experimantal)
    2019-06
    """
    var_external = False

    var_manifest = None

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            var_manifest = '/'.join(request.args)

    return dict(vmanifest=var_manifest, external=var_external)


def viewer_osdg():
    """
    画像表示
    OpenSeadragon Viewer（Experimantal)
    2019-06
    """
    var_external = False

    var_manifest = None

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            var_manifest = '/'.join(request.args)

    return dict(vmanifest=var_manifest, external=var_external)


# ========================================
# IIIF Manifest
# 2018-11/2019-05
# ========================================

def iiif():
    """
    IIIF Presentation API 2.1
    2018-11
    """
    # 引数（リソースID/アノートID）の取得
    resourceid = 1  # Default
    folderid = 1  # Default
    fileid = 1  # Default
    annoteid = 1  # Default
    req_api_type = 'manifest.json'
    if len(request.args) > 1:
        domain = sanitize(request.args(0))
        if domain == 'annote':
            annoteid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'file':
            fileid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'folder':
            folderid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'resource':
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        else:
            domain = 'resource'
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))

    if req_api_type.startswith('manifest'):

        if domain == 'annote':
            da = mr_datahelper.d_d_annote(dbm, annoteid)
        elif domain == 'file':
            da = mr_datahelper.d_d_file(dbm, fileid)
        elif domain == 'folder':
            da = mr_datahelper.d_d_folder(dbm, folderid)
        else:
            da = mr_datahelper.d_d_resource(dbm, resourceid)

        # get Manifest JSON
        json_ld = mr_manifesthelper.__get_iiif_manifest(MR_CONF, da['array'])

        return response.json(json_ld)

    elif req_api_type.startswith('annotationlist'):

        if domain == 'resource':
            cvid = None
            if 'cvid' in request.vars:
                cvid = request.vars.get('cvid')

            da = mr_datahelper.d_d_canvas(dbm, cvid, resourceid)

        #elif domain == 'file':
        #    da = mr_datahelper.d_d_file(dbm, fileid)
        else:
            da = mr_datahelper.d_d_file(dbm, fileid)

        # get Annotation List JSON
        json_ld = mr_manifesthelper.__get_iiif_annotationlist(MR_CONF, da['array'])

        return response.json(json_ld)

    else:
        return response.json({})


# ========================================
# Menu
# 2018-11/2019-05
# ========================================

def __get_menu():
    """
    Menuを取得する
    2018-11
    """
    # トップのメニュー索引の作成
    dom_div = DIV(_class='m-line')

    ul = UL(_class='list-inline m-menu')

    li = LI(A(T('Home'),_href=URL('index')),_class="list-group-item m-menu-item")

    for r in dbm((dbm.mr_collections._id>1)&(dbm.mr_collections.mr_open==True)).select(orderby=[dbm.mr_collections.mr_order,dbm.mr_collections.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('items',args=[str(r.id)])),_class="list-group-item m-menu-item")
        ul.append(li)

    for r in dbm((dbm.mr_pages._id>1)&(dbm.mr_pages.mr_open==True)).select(orderby=[dbm.mr_pages.mr_order,dbm.mr_pages.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('page',args=[str(r.id)]),_class=""),_class="list-group-item m-menu-item")
        ul.append(li)

    dom_div.append(ul)

    return dom_div


def __get_sidemenu():
    """
    Side menuを取得する
    2018-11/2019-05
    """
    # トップ以外のサイドメニュー索引の作成
    dom_div = DIV(_class='m-leftside')

    ul = UL(_class='list-group list-group-flush m-collection')

    li = LI(A(T('Home'),_href=URL('index')),_class="list-group-item")
    ul.append(li)

    for r in dbm((dbm.mr_collections._id>1)&(dbm.mr_collections.mr_open==True)).select(orderby=[dbm.mr_collections.mr_order,dbm.mr_collections.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('items',args=[str(r.id)])),_class="list-group-item")
        ul.append(li)

    for r in dbm((dbm.mr_pages._id>1)&(dbm.mr_pages.mr_open==True)).select(orderby=[dbm.mr_pages.mr_order,dbm.mr_pages.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('page',args=[str(r.id)]),_class=""),_class="list-group-item")
        ul.append(li)

    dom_div.append(ul)

    return dom_div


# ========================================
# Thumbnail image
# 2018-11/2019-05
# ========================================

def __get_dom_icon_manifest(d_d):
    """
    Manifest link
    2018-11/2019-05
    """
    a_href = ['iiif',d_d['role'],str(d_d['subid']),'manifest.json']
    a_manifest = SPAN(A(
        IMG(
            _src=URL('static','mr_images/iiif_logo.png')
            ,_width='32'
        )
        ,_href=URL('iiif',args=[d_d['role'],d_d['subid'],'manifest.json'])
        ,_target='_blank'
        ,_title='IIIF-Manifest'
        )
        ,_class="m-manifest-link")

    return (a_manifest, a_href)


def __get_dom_icon_manifest_external(d_d):
    """
    Manifest link
    2019-05
    """
    a_href = ['iiif','external',str(d_d['ids'][0]),'manifest.json']
    a_manifest = SPAN(A(
        IMG(
            _src=URL('static','mr_images/iiif_logo.png')
            ,_width='32'
        )
        ,_href='%s://%s%s' % (d_d['href'][0],d_d['href'][1],d_d['href'][2])
        ,_target='_blank'
        ,_title='IIIF-Manifest'
        )
        ,_class="m-manifest-link")

    return (a_manifest, a_href, '%s://%s%s' % (d_d['href'][0],d_d['href'][1],d_d['href'][2]))


def __test_format(fcontains, refs):
    """
    フォーマットの含有テスト
    """
    b = False
    for v in fcontains:
        if v in refs:   #参照
            b = True
            break;
    return b


def __get_shimakuma_icon(fcontains, m_href_args):
    """
    Shimakuma link
    2019-06
    """
    if __test_format(fcontains, ('tif','jp2','jpg','fzp','fzp3','dzi','zoomify','external',)):
        a_viewer = SPAN(A(
            IMG(
                _src=URL('static','mr_libs/shimakuma/shimakuma-logo.png')
                ,_width='30',_height='30'
            )
            ,_href=URL('viewer',args=m_href_args)
            ,_target='_blank'
            ,_title='Shimakuma viewer'
            )
            ,_class="m-viewer-link m-viewer-link-dark")
    else:
        a_viewer = ''

    return a_viewer


#def __get_mirador_icon(fcontains, m_href_args):
#    """
#    Mirador link (Experimental)
#    2019-06
#    """
#    if __test_format(fcontains, ('tif','jpg','external',)):
#        a_viewer = SPAN(A(
#            IMG(
#                _src=URL('static','mr_libs/mirador/mirador-logo.png')
#                ,_width='30',_height='30'
#            )
#            ,_href=URL('viewer_mirador',args=m_href_args)
#            ,_target='_blank'
#            ,_title='Mirador viewer'
#            )
#            ,_class="m-viewer-link m-viewer-link-dark")
#    else:
#        a_viewer = ''
#
#    return a_viewer


def __image_ul_for_eachitem(_session, d_d, _atypes=['area'], enable_link=False):
    """
    Thumbnail imageのHTML(UL)を生成、item用
    2018-11/2019-05
    """
    dom_file_ul = None

    if 'folders' in d_d and len(d_d['folders'])>0:

        dom_file_ul = UL(_class='m-items')

        for d_fd in d_d['folders']:

            for idx in d_fd.get('tops',[]):

                d_f = d_fd['files'][idx]

                if 'external' in d_fd['role']:

                    # Manifest link
                    (a_manifest,m_href_args,m_href) = __get_dom_icon_manifest_external(d_f)

                    # Snap image
                    img = IMG(_src='/'.join(d_f.get('snapimage',''))
                            #,_width=240
                            ,_alt=d_f['title']
                            ,_class='m-snapimage'
                        )

                else:
                    # Manifest link
                    (a_manifest,m_href_args) = __get_dom_icon_manifest(d_fd)

                    # Snap image
                    img = IMG(_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f.get('snapimage','')))
                            #,_width=240
                            ,_alt=d_f['title']
                            ,_class='m-snapimage'
                        )

                if 'external' in d_fd['role']:
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']
                    d_f['format'] = 'external'

                elif d_fd['role']=='folder':
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                elif 'pdf' in d_f['href']:
                    href = '%s/resources/%s.pdf' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f['href'][:-1]))
                    _session.imgs[tuple(d_f['href'])] = d_f['ids']

                else:
                    #href = URL('viewer',args=d_f['href'])
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                dom_file_li= LI(
                                DIV(
                                    DIV(
                                        A(img
                                            ,_href=href
                                            ,_target='_blank'
                                            ,_title=d_f['title']
                                        )
                                        ,a_manifest
                                        ,_label=d_f['title']
                                        ,_class='m-image m-item-snapimage'
                                        ,**{'_data-id':d_f['subid']}
                                    )
                                    ,P(
                                        d_f['title']
                                    )
                                    #,DIV(
                                    #    __get_shimakuma_icon([d_f['format']], m_href_args)
                                    #    ,__get_mirador_icon([d_f['format']], m_href_args)
                                    #    ,_class='m-item'
                                    #)
                                )
                                ,_class='m-item m-item-wid240'
                            )

                dom_file_ul.append(dom_file_li)


                # セグメント
                if 'annotes' in d_f and len(d_f['annotes'])>0:

                    for d_a in d_f['annotes']:

                        # 対象のアノテーション形式（デフォルト'area'）以外はスルー（出力抑制）
                        if d_a['annotetype'] not in _atypes: continue

                        # Manifest link
                        (a_manifest,m_href_args) = __get_dom_icon_manifest(d_a)

                        # Snap image
                        if 'tif' in d_f['format'] or 'jp2' in d_f['format']:
                            img_src = '%s%s.%s/%s/240,/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(d_f['href'][:-1]),d_f['format'],','.join([str(v) for v in d_a['annotearea']]),int(d_a['annoterotation']))
                        elif 'jpg' in d_f['format']:
                            img_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_a['thumbnail']))
                        else:
                            continue

                        img = IMG(_src=img_src
                                    ,_alt=d_a['title']
                                    ,_class='m-thumbnail'
                                )
                        href = URL('viewer',args=d_a['href'])
                        var_args = d_f['href']
                        if 'tif' in d_f['format'] or 'jp2' in d_f['format']:
                            manifest_id = "iiif/annote/%s/manifest.json" % (str(d_a['subid']))
                            var_args = ['iiif','annote',str(d_a['subid']),'manifest.json']
                            href = URL('viewer',args=[manifest_id])

                        if enable_link:
                            img_obj = A(img
                                        ,_href=href
                                        ,_target='_blank'
                                        ,_title=d_a['title']
                                    )
                        else:
                            img_obj = img

                        _session.imgs[tuple(var_args)] = d_a['ids']

                        dom_file_li= LI(
                                        DIV(
                                            DIV(img_obj
                                                ,a_manifest
                                                ,_label=d_a['title']['value']
                                                ,_class='m-image m-item-thumbnail'
                                                ,**{'_data-id':d_a['subid']}
                                            )
                                            ,P(
                                                d_a['title']['value']
                                            )
                                            ,DIV(
                                                __get_shimakuma_icon([d_f['format']], m_href_args)
                                                ,__get_mirador_icon([d_f['format']], m_href_args)
                                                #,__get_leaflet_icon([d_f['format']], m_href_args)
                                                #,__get_osdg_icon([d_f['format']], m_href_args)
                                                ,_class='m-item'
                                            )
                                        )
                                        ,_class='m-item m-item-wid240'
                                    )

                        dom_file_ul.append(dom_file_li)

    return dom_file_ul or ''


def __image_ul_for_items(_session, d_d):
    """
    Thumbnail imageのHTML(UL)を生成
    2018-11/2019-05
    """
    dom_file_ul = None

    if 'folders' in d_d and len(d_d['folders'])>0:

        dom_file_ul = UL(_class='m-items')

        for d_fd in d_d['folders']:

            for idx in d_fd.get('tops',[0]):

                d_f = d_fd['files'][idx]

                if 'role' in d_f and d_f['role'].startswith('external'):

                    # Thumbnail image
                    img = IMG(_src=d_f.get('thumbnailuri','')
                                ,_alt=d_f['title']
                                ,_class='m-thumbnail'
                            )

                    href = URL('item',args=[d_d['subid']])

                    #_session.imgs[] = d_f['ids']

                else:

                    # Thumbnail image
                    img = IMG(_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f.get('thumbnail','')))
                                ,_alt=d_f['title']
                                ,_class='m-thumbnail'
                            )

                    href = URL('item',args=[d_d['subid']])

                    _session.imgs[tuple(d_f['href'])] = d_f['ids']

                dom_file_li= LI(
                                DIV(
                                    DIV(
                                        A(img
                                            ,_href=href
                                        )
                                        ,_label=d_f['title']
                                        ,_class='m-image m-item-thumbnail'
                                        ,**{'_data-id':d_f['subid']}
                                    )
                                    ,P(
                                        d_f['title']
                                    )
                                )
                                ,_class='m-item m-item-wid160'
                            )

                dom_file_ul.append(dom_file_li)

    return dom_file_ul or ''


def __get_dom_attribution_table(d_d):
    """
    外部マニフェスト属性対応
    2019-05/2019-06
    """
    dom_table = None

    if d_d['role'].startswith('external'):

        dom_table = TABLE(TR(TD(T('from Manifest'),_colspan='2',_class='m-label m-item-header')),_class='col col-12')

        for ky in d_d['externalkeyvalue']:
            if ky in d_d['keyset']:
                continue
            if isinstance(d_d['externalkeyvalue'][ky],list):
                atf = True
                for d in d_d['externalkeyvalue'][ky]:
                    if d and len(d.strip())>0:
                        dom_tr= TR(
                                TD(ky, _class='m-label')
                                ,TD(XML(d))
                            )
                        dom_table.append(dom_tr)

            elif isinstance(d_d['externalkeyvalue'][ky],str):
                if len(d_d['externalkeyvalue'][ky].strip())>0:
                    dom_tr= TR(
                                TD(ky, _class='m-label')
                                ,TD(d_d['externalkeyvalue'][ky])
                            )

                    dom_table.append(dom_tr)

    return dom_table or ''


# ========================================
# User
# 2018-11
# ========================================

def user():
    """
    ユーザー認証
    2018-11
    """
    auth.settings.controller = 'default'
    return dict(form=auth())
