<?php
/**
 * RouteConfigure.
 * @package magic.core
 * @subpackage config
 */
/**
 * リクエストURLから、呼び出すクラスを解決するインターフェイスです.
 * <p>
 * リクエストのURLを解析して、実際にコールするActionクラスと、
 * エントリポイントとなるファンクション名を取得します。<br/>
 * 一般的に.htaccessやhttpd.confのmod_rewriteと連動させて、
 * クエリパラメータより取得した値で解決する事になるでしょう。
 * </p>
 * @package magic.core
 * @subpackage config
 * @author T.Okumura
 * @version 1.0.0
 */
interface RouteConfigure {
    /**
     * コールするActionクラスの名前を取得します.
     * <p>
     * このファンクションが返すAction名には、
     * クラス名のsuffixを付けない事に注意してください。<br/>
     * 一般的にxxxActionという名前になりますが、
     * suffixは{@link PathConfigure}インターフェイスを実装したクラスで指定してください。<br/>
     * ここで返される文字列はxxxの部分のみです。<br/>
     * デフォルトでは、{@link RouteConfigureImpl}が使用されます。
     * </p>
     * @return string コールするべきAction名
     * @see PathConfigure
     */
    function getActionName();
    /**
     * エントリポイントとなるファンクション名を取得します.
     * <p>
     * デフォルトでは、{@link RouteConfigureImpl}が使用されます。
     * </p>
     * @return string コールするべきファンクション名
     */
    function getMethodName();
}
// EOF.