<?php
/**
 * PathConfigureImpl.
 * @package magic.core
 * @subpackage config.impl
 */
/**
 * アプリケーションのクラスパスを解決する、デフォルトの実装クラスです.
 * <p>
 * このクラスは必要な時に{@link Controller}によってロードされます。
 * </p>
 * @package magic.core
 * @subpackage config.impl
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class PathConfigureImpl implements PathConfigure {
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    /**
     * 'Action'という文字列を返します.
     * @see PathConfigure::getActionSuffix()
     */
    public function getActionSuffix() {
        return 'Action';
    }
    /**
     * '{ContextRoot}/app/action/'
     * (Windowsの場合は'{ContextRoot}\app\action\')という文字列を返します.
     * @see PathConfigure::getActionPath()
     */
    public function getActionPath() {
        return APP . 'action' . DIRECTORY_SEPARATOR;
    }
    /**
     * 'Dao'という文字列を返します.
     * @see PathConfigure::getDaoSuffix()
     */
    public function getDaoSuffix() {
        return 'Dao';
    }
    /**
     * '{ContextRoot}/app/dao/'
     * (Windowsの場合は'{ContextRoot}\app\dao\')という文字列を返します.
     * @see PathConfigure::getDaoPath()
     */
    public function getDaoPath() {
        return APP . 'dao' . DIRECTORY_SEPARATOR;
    }
    /**
     * 'Dto'という文字列を返します.
     * @see PathConfigure::getDtoSuffix()
     */
    public function getDtoSuffix() {
        return 'Dto';
    }
    /**
     * '{ContextRoot}/app/dto/'
     * (Windowsの場合は'{ContextRoot}\app\dto\')という文字列を返します.
     * @see PathConfigure::getDtoPath()
     */
    public function getDtoPath() {
        return APP . 'dto' . DIRECTORY_SEPARATOR;
    }
    /**
     * 'View'という文字列を返します.
     * @see PathConfigure::getViewSuffix()
     */
    public function getViewSuffix() {
        return 'View';
    }
    /**
     * '{ContextRoot}/app/view/'
     * (Windowsの場合は'{ContextRoot}\app\view\')という文字列を返します.
     * @see PathConfigure::getViewPath()
     */
    public function getViewPath() {
        return APP . 'view' . DIRECTORY_SEPARATOR;
    }
    /**
     * 'html'という文字列を返します.
     * @see PathConfigure::getHtmlSuffix()
     */
    public function getHtmlSuffix() {
        return 'html';
    }
    /**
     * '{ContextRoot}/web/'
     * (Windowsの場合は'{ContextRoot}\web\')という文字列を返します.
     * @see PathConfigure::getHtmlPath()
     */
    public function getHtmlPath() {
        return WEB;
    }
    /**
     * 'Message'という文字列を返します.
     * @see PathConfigure::getDefaultMessageFileName()
     */
    public function getDefaultMessageFileName() {
        return 'Message';
    }
    /**
     * '{ContextRoot}/app/message/'
     * (Windowsの場合は'{ContextRoot}\app\message\')という文字列を返します.
     * @see PathConfigure::getMessagePath()
     */
    public function getMessagePath() {
        return APP . 'message' . DIRECTORY_SEPARATOR;
    }
}
// EOF.