<?php
/**
 * UpperCamelCase.
 * @package magic.core
 * @subpackage helper.naming.impl
 */
/**
 * 先頭が大文字のキャメルケースクラスです.
 * @package magic.core
 * @subpackage helper.naming.impl
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class UpperCamelCase implements NamingType {
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    /**
     * 先頭が大文字のキャメルケースに変換された文字列を取得します.
     * @see NamingType::apply()
     */
    public function apply($text) {
        $text = strstr($text, '_') === FALSE ? $text
                : str_replace(' ', '', ucwords(str_replace('_', ' ', strtolower($text))));
        return strtoupper(substr($text, 0, 1)) . substr($text, 1);
    }
}
// EOF.