<?php
/**
 * EasySeparator.
 * @package magic.core
 * @subpackage tool.mobile
 */
/**
 * 携帯電話用のキャリア簡易判定クラスです.
 * <p>
 * 判定できるキャリアは、
 * <ul>
 * <li>DoCoMo</li>
 * <li>SoftBank</li>
 * <li>AU</li>
 * <li>E-Mobile</li>
 * </ul>
 * だけです。<bt/>
 * これは、GUIDやサブスクライブ番号で判定しているので、
 * ユーザー側で送出しない設定になっていると判別できません。<br/>
 * また、スマートフォンには対応していません。
 * </p>
 * @package magic.core
 * @subpackage tool.mobile
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class EasySeparator {
    /**
     * コンストラクタ.
     */
    private function __construct() {
    }
    /**
     * 携帯のキャリア判別を実行します.
     * <p>
     * 取得できるのは、個体識別子と呼ばれるものと便宜上の連番、キャリア名です。
     * </p>
     * @return mixed 個体識別子、連番、キャリア名の配列、取得できない場合はFALSE
     * @static
     */
    public static function getMobileInfo() {
        switch (TRUE) {
            case $id = ServerUtil::get('HTTP_X_DCMGUID'):
                return array($id, 1, 'DoCoMo');
            case $id = ServerUtil::get('HTTP_X_UP_SUBNO'):
                return array($id, 2, 'AU');
            case $id = ServerUtil::get('HTTP_X_JPHONE_UID'):
                return array($id, 3, 'SoftBank');
            case $id = ServerUtil::get('HTTP_X_EM_UID'):
                return array($id, 4, 'E-Mobile');
        }
        return FALSE;
    }
}
// EOF.