<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainConfigsysWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	const CAN_DETAIL_CONFIG	= 'permit_detail_config';				// 詳細設定が可能かどうか
	const REGENERATE_SESSION = 'regenerate_session_id';				// セッションIDを毎回更新するかどうか
	const SCRIPT_CACHE_IN_BROWSER = 'script_cache_in_browser';				// ブラウザにスクリプトのキャッシュを保持するかどうか
	const MENU_ITEM_DEVELOP = 'develop';				// 「開発」メニューの識別ID
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'configsystem.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gConfigManager;
		global $gEnvManager;
		
		$act = $request->trimValueOf('act');
		$canDetailConfig = ($request->trimValueOf('item_can_detail_config') == 'on') ? 1 : 0;		// 詳細システム設定が可能かどうか
		$regenerateSession = ($request->trimValueOf('item_regenerate_sesison') == 'on') ? 1 : 0;		// セッションIDを更新するかどうか
		$scriptCacheInBrowser = ($request->trimValueOf('item_script_cache_in_browser') == 'on') ? 1 : 0;		// ブラウザにスクリプトのキャッシュを保持するかどうか
		if ($act == 'update'){		// 設定更新のとき
			$isErr = false;
			if (!$isErr){
				if (!$this->db->updateSystemConfig(self::CAN_DETAIL_CONFIG, $canDetailConfig)) $isErr = true;
			}	
			if (!$isErr){
				if (!$this->db->updateSystemConfig(self::REGENERATE_SESSION, $regenerateSession)) $isErr = true;
			}
			if (!$isErr){
				if (!$this->db->updateSystemConfig(self::SCRIPT_CACHE_IN_BROWSER, $scriptCacheInBrowser)) $isErr = true;
			}
			if ($isErr){
				$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
			} else {
				$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
			}
			// システムパラメータを更新
			$gEnvManager->loadSystemParams();
			
			// 値を再取得
			$canDetailConfig	= $this->db->getSystemConfig(self::CAN_DETAIL_CONFIG);
			$regenerateSession	= $this->db->getSystemConfig(self::REGENERATE_SESSION);
			$scriptCacheInBrowser = $this->db->getSystemConfig(self::SCRIPT_CACHE_IN_BROWSER);
			
			// メニュー項目の制御
			$this->db->updateMenuVisible(self::MENU_ITEM_DEVELOP, $canDetailConfig);			// 「開発」メニュー
		} else {		// 初期表示の場合
			$canDetailConfig	= $this->db->getSystemConfig(self::CAN_DETAIL_CONFIG);
			$regenerateSession	= $this->db->getSystemConfig(self::REGENERATE_SESSION);
			$scriptCacheInBrowser = $this->db->getSystemConfig(self::SCRIPT_CACHE_IN_BROWSER);
		}
		// 画面に書き戻す
		$checked = '';
		if ($canDetailConfig) $checked = 'checked';
		$this->tmpl->addVar("_widget", "can_detail_config", $checked);
		
		$checked = '';
		if ($regenerateSession) $checked = 'checked';
		$this->tmpl->addVar("_widget", "regenerate_session", $checked);
		
		$checked = '';
		if ($scriptCacheInBrowser) $checked = 'checked';
		$this->tmpl->addVar("_widget", "script_cache_in_browser", $checked);
		
		$limit = ini_get('upload_max_filesize') > ini_get('post_max_size') ? ini_get('post_max_size') : ini_get('upload_max_filesize');
		$limit = $limit > ini_get('memory_limit') ? ini_get('memory_limit') : $limit;
		$this->tmpl->addVar("_widget", "upload_filesize_limit", $limit);
		$this->tmpl->addVar("_widget", "memory_limit", ini_get('memory_limit'));
		$this->tmpl->addVar("_widget", "post_max_size", ini_get('post_max_size'));
		$this->tmpl->addVar("_widget", "upload_max_filesize", ini_get('upload_max_filesize'));
		
		// バージョン
		$this->tmpl->addVar("_widget", "magic3_version", M3_SYSTEM_VERSION);
		$this->tmpl->addVar("_widget", "php_version", phpversion());
		if ($this->db->getDbType() == M3_DB_TYPE_MYSQL){		// MySQLの場合
			$dbType = 'MySQL';
		} else if ($this->db->getDbType() == M3_DB_TYPE_PGSQL){// PostgreSQLの場合
			$dbType = 'PostgreSQL';
		} else {
			$dbType = 'DB未設定';
		}
		$this->tmpl->addVar("_widget", "db_type", $dbType);			// 使用しているDB種
		$this->tmpl->addVar("_widget", "db_version", $this->db->getDbVersion());
		$this->tmpl->addVar("_widget", "os_version", php_uname('s') . ' ' . php_uname('r') . ' ' . php_uname('m'));		// OSバージョン
		
		// DB接続
		$gConfigManager->getDbConnectDsnByList($dbType, $hostname, $dbname);
		$this->tmpl->addVar("_widget", "db_type", $dbType);			// DB種
		$this->tmpl->addVar("_widget", "db_host_name", $hostname);			// DBホスト名
		$this->tmpl->addVar("_widget", "db_name", $dbname);			// DB名
		$dbuser = $gConfigManager->getDbConnectUser();		// 接続ユーザ
		$this->tmpl->addVar("_widget", "db_user_name", $dbuser);			// 接続ユーザ名
				
		// mbstring
		if (extension_loaded('mbstring')){
			$data = 'on';
		} else {
			$data = 'off';
		}
		$this->tmpl->addVar("_widget","current_mbstring", $data);
		// gd
		if (extension_loaded('gd')){
			$data = 'on';
		} else {
			$data = 'off';
		}
		$this->tmpl->addVar("_widget","current_gd", $data);
		// xml
		if (extension_loaded('xml')){
			$data = 'on';
		} else {
			$data = 'off';
		}
		$this->tmpl->addVar("_widget","current_xml", $data);
		
		// サーバ環境
		$hostname = exec('hostname');
		$this->tmpl->addVar("_widget", "host_name", $hostname);
		$dnsResolv = '解決できません';
		if ($hostname != 'localhost.localdomain'){
			$hosts = gethostbynamel($hostname);
			if (count($hosts) > 0) $dnsResolv = $hosts[0];
		}
		$this->tmpl->addVar("_widget", "dns_resolv", $dnsResolv);
		
		// phpinfo出力へのURL
		$phpinfoUrl = '?task=phpinfo&menu=off';			// メニューは非表示にする
		$this->tmpl->addVar("_widget", "phpinfo_url", $phpinfoUrl);
	}
}
?>
