<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainInitsystemWidgetContainer extends BaseWidgetContainer
{
	var $db;	// DB接続オブジェクト
	const SAMPLE_DIR = 'sample';				// サンプルSQLディレクトリ名
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'initsystem.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gDbManager;		// DBマネージャー
		global $gSystemManager;
		global $gEnvManager;
		global $gFileManager;
		
		$act = $request->trimValueOf('act');
		if ($act == 'initsys'){		// システム初期化のとき
			// テーブルの初期化フラグをリセット
			$gSystemManager->enableInitSystem();
			
			// インストーラを回復
			$gFileManager->recoverInstaller();
			
			$this->setMsg(self::MSG_GUIDANCE, 'システム初期化完了しました<br>一旦ログアウトしてください');
		} else if ($act == 'initother'){		// 追加テーブル再構築のとき
			// DB初期化実行
			$ret = $gDbManager->execInitScript(1, $errors);// 標準テーブル
			if ($ret) $ret = $gDbManager->execInitScript(2, $errors);// ECテーブル
			if ($ret){
				$this->setMsg(self::MSG_GUIDANCE, 'テーブル再構築完了しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, "テーブル再構築に失敗しました");
			}
			if (!empty($errors)){
				foreach ($errors as $error) {
					$this->setMsg(self::MSG_APP_ERR, $error);
				}
			}
		} else if ($act == 'installsampledata'){		// サンプルデータインストールのとき
			$filename = $request->trimValueOf('sample_sql');
			$scriptPath = $gEnvManager->getSqlPath() . '/' . self::SAMPLE_DIR . '/' . $filename;
			
			// スクリプト実行
			if ($gDbManager->execScriptWithConvert($scriptPath, $errors)){// 正常終了の場合
				$this->setMsg(self::MSG_GUIDANCE, 'スクリプト実行完了しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, "スクリプト実行に失敗しました");
			}
			if (!empty($errors)){
				foreach ($errors as $error) {
					$this->setMsg(self::MSG_APP_ERR, $error);
				}
			}
		}
		// DBのタイプ
		$dbType = $this->db->getDbType();
		
		// サンプルSQLスクリプトディレクトリのチェック
		$searchPath = $gEnvManager->getSqlPath() . '/' . self::SAMPLE_DIR;
		if (is_dir($searchPath)){
			$dir = dir($searchPath);
			while (($file = $dir->read()) !== false){
				$filePath = $searchPath . '/' . $file;
				// ファイルかどうかチェック
				if (strncmp($file, '.', 1) != 0 && $file != '..' && is_file($filePath)
					&& strncmp($file, '_', 1) != 0){	// 「_」で始まる名前のファイルは読み込まない
					//&& strncmp($file, $dbType . '_', strlen($dbType) + 1) == 0){	// 接続しているDBタイプのスクリプトのみ表示
					
					$selected = '';
					if ($file == $filename){
						$selected = 'selected';
					}
					$row = array(
						'value'    => $file,			// ファイル名
						'name'     => $file,			// ファイル名
						'selected' => $selected														// 選択中かどうか
					);
					$this->tmpl->addVars('sample__sql_list', $row);
					$this->tmpl->parseTemplate('sample__sql_list', 'a');
				}
			}
			$dir->close();
		}
	}
}
?>
